/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.layer;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.IModel;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.web.GWCIconFactory;
import org.geoserver.gwc.web.layer.TileLayerDetachableModel;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geowebcache.layer.TileLayer;

class CachedLayerProvider
extends GeoServerDataProvider<TileLayer> {
    private static final long serialVersionUID = -8599398086587516574L;
    static final GeoServerDataProvider.Property<TileLayer> TYPE = new GeoServerDataProvider.AbstractProperty<TileLayer>("type"){
        private static final long serialVersionUID = 3215255763580377079L;

        public ResourceReference getPropertyValue(TileLayer item) {
            return GWCIconFactory.getSpecificLayerIcon(item);
        }

        public Comparator<TileLayer> getComparator() {
            return new Comparator<TileLayer>(){

                @Override
                public int compare(TileLayer o1, TileLayer o2) {
                    ResourceReference r1 = this.getPropertyValue(o1);
                    ResourceReference r2 = this.getPropertyValue(o2);
                    return r1.getName().compareTo(r2.getName());
                }
            };
        }
    };
    static final GeoServerDataProvider.Property<TileLayer> NAME = new GeoServerDataProvider.BeanProperty("name", "name");
    static final GeoServerDataProvider.Property<TileLayer> QUOTA_LIMIT = new GeoServerDataProvider.AbstractProperty<TileLayer>("quotaLimit"){
        private static final long serialVersionUID = 5091453765439157623L;

        public Object getPropertyValue(TileLayer item) {
            GWC gwc = GWC.get();
            return gwc.getQuotaLimit(item.getName());
        }
    };
    static final GeoServerDataProvider.Property<TileLayer> QUOTA_USAGE = new GeoServerDataProvider.AbstractProperty<TileLayer>("quotaUsed"){
        private static final long serialVersionUID = 3503671083744555325L;

        public Object getPropertyValue(TileLayer item) {
            GWC gwc = GWC.get();
            if (gwc.isDiskQuotaEnabled()) {
                return gwc.getUsedQuota(item.getName());
            }
            return null;
        }
    };
    static final GeoServerDataProvider.Property<TileLayer> BLOBSTORE = new GeoServerDataProvider.BeanProperty("blobstore", "blobStoreId");
    static final GeoServerDataProvider.Property<TileLayer> ENABLED = new GeoServerDataProvider.BeanProperty("enabled", "enabled");
    static final GeoServerDataProvider.Property<TileLayer> PREVIEW_LINKS = new GeoServerDataProvider.AbstractProperty<TileLayer>("preview"){
        private static final long serialVersionUID = 4375670219356088450L;

        public Object getPropertyValue(TileLayer item) {
            return item.getName();
        }

        public boolean isSearchable() {
            return false;
        }

        public Comparator<TileLayer> getComparator() {
            return null;
        }
    };
    static final GeoServerDataProvider.Property<TileLayer> ACTIONS = new GeoServerDataProvider.AbstractProperty<TileLayer>("actions"){
        private static final long serialVersionUID = 247933970378482802L;

        public Object getPropertyValue(TileLayer item) {
            return item.getName();
        }

        public boolean isSearchable() {
            return false;
        }

        public Comparator<TileLayer> getComparator() {
            return null;
        }
    };
    static final List<GeoServerDataProvider.Property<TileLayer>> PROPERTIES = Collections.unmodifiableList(Arrays.asList(TYPE, NAME, QUOTA_LIMIT, QUOTA_USAGE, BLOBSTORE, ENABLED, PREVIEW_LINKS, ACTIONS));

    CachedLayerProvider() {
    }

    protected List<TileLayer> getItems() {
        GWC gwc = GWC.get();
        ArrayList tileLayerNames = new ArrayList(gwc.getTileLayerNames());
        Predicate<String> predicate = new Predicate<String>(){

            public boolean apply(@Nullable String input) {
                if (input != null && !input.isEmpty()) {
                    TileLayer layer = GWC.get().getTileLayerByName(input);
                    return layer.isAdvertised();
                }
                return false;
            }
        };
        tileLayerNames = new ArrayList(Collections2.filter(tileLayerNames, (Predicate)predicate));
        return Lists.transform(tileLayerNames, (Function)new Function<String, TileLayer>(){

            public TileLayer apply(String input) {
                return GWC.get().getTileLayerByName(input);
            }
        });
    }

    protected List<GeoServerDataProvider.Property<TileLayer>> getProperties() {
        return PROPERTIES;
    }

    public IModel<TileLayer> newModel(Object tileLayer) {
        return new TileLayerDetachableModel(((TileLayer)tileLayer).getName());
    }

    protected Comparator<TileLayer> getComparator(SortParam sort) {
        return super.getComparator(sort);
    }
}

