/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.gridset;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.IModel;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.web.gridset.GridSetDetachableModel;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geowebcache.diskquota.storage.Quota;
import org.geowebcache.grid.Grid;
import org.geowebcache.grid.GridSet;

public abstract class GridSetTableProvider
extends GeoServerDataProvider<GridSet> {
    private static final long serialVersionUID = 399110981279814481L;
    static final GeoServerDataProvider.Property<GridSet> NAME = new GeoServerDataProvider.BeanProperty("name", "name");
    static final GeoServerDataProvider.Property<GridSet> EPSG_CODE = new GeoServerDataProvider.AbstractProperty<GridSet>("epsg_code"){
        private static final long serialVersionUID = -4311392731568045337L;

        public Object getPropertyValue(GridSet item) {
            return item.getSrs().toString();
        }
    };
    static final GeoServerDataProvider.Property<GridSet> TILE_DIMENSION = new GeoServerDataProvider.AbstractProperty<GridSet>("tile_dimension"){
        private static final long serialVersionUID = 7300188694215155063L;

        public Object getPropertyValue(GridSet item) {
            return item.getTileWidth() + " x " + item.getTileHeight();
        }
    };
    static final GeoServerDataProvider.Property<GridSet> ZOOM_LEVELS = new GeoServerDataProvider.AbstractProperty<GridSet>("zoom_levels"){
        private static final long serialVersionUID = 3155098860179765581L;

        public Object getPropertyValue(GridSet item) {
            Grid[] grids = item.getGridLevels();
            return grids == null ? Integer.valueOf(0) : Integer.valueOf(grids.length);
        }
    };
    static final GeoServerDataProvider.Property<GridSet> QUOTA_USED = new GeoServerDataProvider.AbstractProperty<GridSet>("quota_used"){
        private static final long serialVersionUID = 1152149141759317288L;

        public Object getPropertyValue(GridSet item) {
            String gridSetName = item.getName();
            Quota usedQuotaByGridSet = GWC.get().getUsedQuotaByGridSet(gridSetName);
            return usedQuotaByGridSet;
        }
    };
    static final GeoServerDataProvider.Property<GridSet> ACTION_LINK = new GeoServerDataProvider.AbstractProperty<GridSet>(""){
        private static final long serialVersionUID = -7593097569735264194L;

        public Object getPropertyValue(GridSet item) {
            return item.getName();
        }
    };

    public abstract List<GridSet> getItems();

    protected List<GeoServerDataProvider.Property<GridSet>> getProperties() {
        return Arrays.asList(NAME, EPSG_CODE, TILE_DIMENSION, ZOOM_LEVELS, QUOTA_USED, ACTION_LINK);
    }

    protected Comparator<GridSet> getComparator(SortParam sort) {
        return super.getComparator(sort);
    }

    public IModel<GridSet> newModel(Object object) {
        String name = ((GridSet)object).getName();
        return new GridSetDetachableModel(name);
    }
}

