/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.gridset;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.web.gridset.GridSetTableProvider;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geowebcache.diskquota.storage.Quota;
import org.geowebcache.grid.GridSet;

public abstract class GridSetListTablePanel
extends GeoServerTablePanel<GridSet> {
    private static final long serialVersionUID = 5957961031378924960L;

    public GridSetListTablePanel(String id, GridSetTableProvider provider, boolean selectable) {
        super(id, (GeoServerDataProvider)provider, selectable);
    }

    protected Component getComponentForProperty(String id, IModel itemModel, GeoServerDataProvider.Property<GridSet> property) {
        if (property == GridSetTableProvider.NAME) {
            GridSet gridSet = (GridSet)itemModel.getObject();
            return this.nameLink(id, gridSet);
        }
        if (property == GridSetTableProvider.EPSG_CODE) {
            String epsgCode = (String)property.getModel(itemModel).getObject();
            return new Label(id, epsgCode);
        }
        if (property == GridSetTableProvider.TILE_DIMENSION) {
            String tileDimension = (String)property.getModel(itemModel).getObject();
            return new Label(id, tileDimension);
        }
        if (property == GridSetTableProvider.ZOOM_LEVELS) {
            Integer zoomLevels = (Integer)property.getModel(itemModel).getObject();
            return new Label(id, zoomLevels.toString());
        }
        if (property == GridSetTableProvider.QUOTA_USED) {
            Quota usedQuota = (Quota)property.getModel(itemModel).getObject();
            String quotaStr = usedQuota == null ? "N/A" : usedQuota.toNiceString();
            return new Label(id, quotaStr);
        }
        if (property == GridSetTableProvider.ACTION_LINK) {
            String gridSetName = (String)property.getModel(itemModel).getObject();
            Component actionLink = this.actionLink(id, gridSetName);
            return actionLink;
        }
        throw new IllegalArgumentException("Unknown property: " + property.getName());
    }

    protected abstract Component nameLink(String var1, GridSet var2);

    protected abstract Component actionLink(String var1, String var2);

    protected CheckBox selectOneCheckbox(Item item) {
        CheckBox cb = super.selectOneCheckbox(item);
        GridSet gs = (GridSet)item.getModelObject();
        String name = gs.getName();
        boolean internal = GWC.get().isInternalGridSet(name);
        if (internal) {
            cb.setEnabled(false);
            cb.setModelObject((Object)Boolean.FALSE);
        }
        return cb;
    }

    public List<GridSet> getSelection() {
        ArrayList<GridSet> selection = new ArrayList<GridSet>(super.getSelection());
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            GridSet g = (GridSet)it.next();
            if (!GWC.get().isInternalGridSet(g.getName())) continue;
            it.remove();
        }
        return selection;
    }
}

