/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.gridset;

import java.io.Serializable;
import org.apache.wicket.PageParameters;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.web.gridset.AbstractGridSetPage;
import org.geoserver.gwc.web.gridset.GridSetBuilder;
import org.geoserver.gwc.web.gridset.GridSetInfo;
import org.geoserver.gwc.web.gridset.GridSetsPage;
import org.geowebcache.grid.GridSet;

public class GridSetEditPage
extends AbstractGridSetPage {
    private String originalName;

    public GridSetEditPage(PageParameters parameters) {
        super(parameters);
        GridSetInfo info = (GridSetInfo)this.form.getModelObject();
        this.originalName = info.getName();
        if (info.isInternal()) {
            this.form.info(new ResourceModel("GridSetEditPage.internalGridSetMessage").getObject());
            this.name.getFormComponent().setEnabled(false);
            this.description.setEnabled(false);
            this.crs.setEnabled(false);
            this.tileWidth.getFormComponent().setEnabled(false);
            this.tileHeight.getFormComponent().setEnabled(false);
            this.bounds.setEnabled(false);
            this.computeBoundsLink.setEnabled(false);
            this.tileMatrixSetEditor.setEnabled(false);
            this.saveLink.setVisible(false);
            this.addLevelLink.setVisible(false);
        }
    }

    @Override
    protected void onSave(AjaxRequestTarget target, Form<?> form) {
        GridSet newGridset;
        GridSetInfo info = (GridSetInfo)form.getModelObject();
        GWC gwc = GWC.get();
        try {
            newGridset = GridSetBuilder.build(info);
        }
        catch (IllegalStateException e) {
            form.error((Serializable)((Object)e.getMessage()));
            target.addComponent(form);
            return;
        }
        try {
            gwc.modifyGridSet(this.originalName, newGridset);
            this.doReturn(GridSetsPage.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            form.error((Serializable)((Object)("Error saving gridset: " + e.getMessage())));
            target.addComponent(form);
        }
    }
}

