/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.diskquota;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.Radio;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.web.diskquota.JDBCConnectionPoolPanel;
import org.geoserver.gwc.web.diskquota.StatusBar;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.wicket.LocalizedChoiceRenderer;
import org.geotools.util.logging.Logging;
import org.geowebcache.diskquota.DiskQuotaConfig;
import org.geowebcache.diskquota.ExpirationPolicy;
import org.geowebcache.diskquota.QuotaStoreFactory;
import org.geowebcache.diskquota.jdbc.JDBCConfiguration;
import org.geowebcache.diskquota.jdbc.SQLDialect;
import org.geowebcache.diskquota.storage.Quota;
import org.geowebcache.diskquota.storage.StorageUnit;
import org.springframework.context.ApplicationContext;

public class DiskQuotaConfigPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logging.getLogger(DiskQuotaConfigPanel.class);
    private final IModel<StorageUnit> configQuotaUnitModel;
    private final IModel<Double> configQuotaValueModel;

    public DiskQuotaConfigPanel(String id, IModel<DiskQuotaConfig> diskQuotaConfigModel, IModel<JDBCConfiguration> jdbcQuotaConfigModel) {
        super(id, diskQuotaConfigModel);
        DiskQuotaConfig diskQuotaConfig = (DiskQuotaConfig)diskQuotaConfigModel.getObject();
        Quota globalQuota = diskQuotaConfig.getGlobalQuota();
        if (globalQuota == null) {
            LOGGER.info("There's no GWC global disk quota configured, setting a default of 100MiB");
            globalQuota = new Quota(100.0, StorageUnit.MiB);
            diskQuotaConfig.setGlobalQuota(globalQuota);
        }
        BigInteger bytes = globalQuota.getBytes();
        StorageUnit bestRepresentedUnit = StorageUnit.bestFit((BigInteger)bytes);
        BigDecimal transformedQuota = StorageUnit.B.convertTo(new BigDecimal(bytes), bestRepresentedUnit);
        this.configQuotaValueModel = new Model((Serializable)Double.valueOf(transformedQuota.doubleValue()));
        this.configQuotaUnitModel = new Model((Serializable)bestRepresentedUnit);
        this.addDiskQuotaIntegrationEnablement(diskQuotaConfigModel);
        this.addDiskQuotaStoreChooser(diskQuotaConfigModel, jdbcQuotaConfigModel);
        this.addCleanUpFrequencyConfig(diskQuotaConfigModel);
        this.addGlobalQuotaConfig(diskQuotaConfigModel, this.configQuotaValueModel, this.configQuotaUnitModel);
        this.addGlobalExpirationPolicyConfig(diskQuotaConfigModel);
    }

    private void addDiskQuotaStoreChooser(IModel<DiskQuotaConfig> diskQuotaModel, IModel<JDBCConfiguration> jdbcQuotaConfigModel) {
        final WebMarkupContainer quotaStoreContainer = new WebMarkupContainer("quotaStoreContainer");
        quotaStoreContainer.setOutputMarkupId(true);
        this.add(new Component[]{quotaStoreContainer});
        ApplicationContext applicationContext = GeoServerApplication.get().getApplicationContext();
        Map factories = applicationContext.getBeansOfType(QuotaStoreFactory.class);
        ArrayList storeNames = new ArrayList();
        for (QuotaStoreFactory sf : factories.values()) {
            storeNames.addAll(sf.getSupportedStoreNames());
        }
        Collections.sort(storeNames);
        PropertyModel storeNameModel = new PropertyModel(diskQuotaModel, "quotaStore");
        if (((DiskQuotaConfig)diskQuotaModel.getObject()).getQuotaStore() == null) {
            storeNameModel.setObject((Object)"H2");
        }
        final DropDownChoice quotaStoreChooser = new DropDownChoice("diskQuotaStore", (IModel)storeNameModel, storeNames, (IChoiceRenderer)new LocalizedChoiceRenderer((Component)this));
        quotaStoreChooser.setOutputMarkupId(true);
        quotaStoreContainer.add(new Component[]{quotaStoreChooser});
        final WebMarkupContainer jdbcContainer = new WebMarkupContainer("jdbcQuotaStoreContainer");
        jdbcContainer.setOutputMarkupId(true);
        jdbcContainer.setVisible("JDBC".equals(quotaStoreChooser.getModelObject()));
        quotaStoreContainer.add(new Component[]{jdbcContainer});
        ArrayList dialectBeanNames = new ArrayList(applicationContext.getBeansOfType(SQLDialect.class).keySet());
        ArrayList<String> dialectNames = new ArrayList<String>();
        for (String beanName : dialectBeanNames) {
            int idx = beanName.indexOf("QuotaDialect");
            if (idx <= 0) continue;
            dialectNames.add(beanName.substring(0, idx));
        }
        JDBCConfiguration config = (JDBCConfiguration)jdbcQuotaConfigModel.getObject();
        PropertyModel dialectModel = new PropertyModel(jdbcQuotaConfigModel, "dialect");
        DropDownChoice dialectChooser = new DropDownChoice("dialectChooser", (IModel)dialectModel, dialectNames);
        dialectChooser.setRequired(true);
        jdbcContainer.add(new Component[]{dialectChooser});
        List<String> connectionTypes = Arrays.asList("JNDI", "PRIVATE_POOL");
        Model connectionTypeModel = new Model();
        if (config.getJNDISource() == null) {
            connectionTypeModel.setObject((Serializable)((Object)"PRIVATE_POOL"));
        } else {
            connectionTypeModel.setObject((Serializable)((Object)"JNDI"));
        }
        final DropDownChoice connectionTypeChooser = new DropDownChoice("connectionTypeChooser", (IModel)connectionTypeModel, connectionTypes, (IChoiceRenderer)new LocalizedChoiceRenderer((Component)this));
        connectionTypeChooser.setOutputMarkupId(true);
        jdbcContainer.add(new Component[]{connectionTypeChooser});
        quotaStoreChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onChange"){

            protected void onUpdate(AjaxRequestTarget target) {
                jdbcContainer.setVisible("JDBC".equals(quotaStoreChooser.getModelObject()));
                target.addComponent((Component)quotaStoreContainer);
            }
        }});
        final WebMarkupContainer connectionTypeContainer = new WebMarkupContainer("connectionTypeContainer");
        connectionTypeContainer.setOutputMarkupId(true);
        jdbcContainer.add(new Component[]{connectionTypeContainer});
        final WebMarkupContainer jndiContainer = new WebMarkupContainer("jndiLocationContainer");
        jndiContainer.setVisible(config.getJNDISource() != null);
        connectionTypeContainer.add(new Component[]{jndiContainer});
        PropertyModel jndiModel = new PropertyModel(jdbcQuotaConfigModel, "jNDISource");
        TextField jndiLocation = new TextField("jndiLocation", (IModel)jndiModel);
        jndiLocation.setRequired(true);
        jndiContainer.add(new Component[]{jndiLocation});
        PropertyModel poolConfigurationModel = new PropertyModel(jdbcQuotaConfigModel, "connectionPool");
        final JDBCConnectionPoolPanel privatePoolPanel = new JDBCConnectionPoolPanel("connectionPoolConfigurator", (IModel<JDBCConfiguration.ConnectionPoolConfiguration>)poolConfigurationModel);
        privatePoolPanel.setVisible(config.getJNDISource() == null);
        connectionTypeContainer.add(new Component[]{privatePoolPanel});
        connectionTypeChooser.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onChange"){

            protected void onUpdate(AjaxRequestTarget target) {
                boolean jndiVisible = "JNDI".equals(connectionTypeChooser.getModelObject());
                jndiContainer.setVisible(jndiVisible);
                privatePoolPanel.setVisible(!jndiVisible);
                target.addComponent((Component)connectionTypeContainer);
            }
        }});
    }

    private void addGlobalQuotaConfig(IModel<DiskQuotaConfig> diskQuotaModel, IModel<Double> quotaValueModel, IModel<StorageUnit> unitModel) {
        PropertyModel globalQuotaModel = new PropertyModel(diskQuotaModel, "globalQuota");
        LoadableDetachableModel<Quota> globalUsedQuotaModel = new LoadableDetachableModel<Quota>(){
            private static final long serialVersionUID = 1L;

            protected Quota load() {
                GWC gwc = GWC.get();
                if (!gwc.isDiskQuotaAvailable()) {
                    return new Quota();
                }
                return gwc.getGlobalUsedQuota();
            }
        };
        Object[] progressMessageParams = new Object[]{((Quota)globalUsedQuotaModel.getObject()).toNiceString(), ((Quota)globalQuotaModel.getObject()).toNiceString()};
        StringResourceModel progressMessageModel = new StringResourceModel("DiskQuotaConfigPanel.usedQuotaMessage", null, progressMessageParams);
        this.addGlobalQuotaStatusBar((IModel<Quota>)globalQuotaModel, (IModel<Quota>)globalUsedQuotaModel, (IModel<String>)progressMessageModel);
        TextField quotaValue = new TextField("globalQuota", quotaValueModel);
        quotaValue.setRequired(true);
        this.add(new Component[]{quotaValue});
        List<StorageUnit> units = Arrays.asList(StorageUnit.MiB, StorageUnit.GiB, StorageUnit.TiB);
        DropDownChoice quotaUnitChoice = new DropDownChoice("globalQuotaUnits", unitModel, units);
        this.add(new Component[]{quotaUnitChoice});
    }

    private void addGlobalExpirationPolicyConfig(IModel<DiskQuotaConfig> diskQuotaModel) {
        PropertyModel globalQuotaPolicyModel = new PropertyModel(diskQuotaModel, "globalExpirationPolicyName");
        RadioGroup globalQuotaPolicy = new RadioGroup("globalQuotaExpirationPolicy", (IModel)globalQuotaPolicyModel);
        this.add(new Component[]{globalQuotaPolicy});
        Model lfuModel = new Model((Serializable)ExpirationPolicy.LFU);
        Model lruModel = new Model((Serializable)ExpirationPolicy.LRU);
        Radio globalQuotaPolicyLFU = new Radio("globalQuotaPolicyLFU", (IModel)lfuModel);
        Radio globalQuotaPolicyLRU = new Radio("globalQuotaPolicyLRU", (IModel)lruModel);
        globalQuotaPolicy.add(new Component[]{globalQuotaPolicyLFU});
        globalQuotaPolicy.add(new Component[]{globalQuotaPolicyLRU});
    }

    private void addCleanUpFrequencyConfig(IModel<DiskQuotaConfig> diskQuotaModel) {
        String resourceId;
        DiskQuotaConfig diskQuotaConfig = (DiskQuotaConfig)diskQuotaModel.getObject();
        int frequency = diskQuotaConfig.getCacheCleanUpFrequency();
        TimeUnit unit = diskQuotaConfig.getCacheCleanUpUnits();
        if (TimeUnit.SECONDS != unit) {
            frequency = (int)TimeUnit.SECONDS.convert(frequency, unit);
            diskQuotaConfig.setCacheCleanUpFrequency(frequency);
            diskQuotaConfig.setCacheCleanUpUnits(TimeUnit.SECONDS);
        }
        PropertyModel cleanUpFreqModel = new PropertyModel(diskQuotaModel, "cacheCleanUpFrequency");
        TextField cleanUpFreq = new TextField("cleanUpFreq", (IModel)cleanUpFreqModel);
        cleanUpFreq.setRequired(true);
        cleanUpFreq.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new StringResourceModel("DiskQuotaConfigPanel.cleanUpFreq.title", (Component)null, null))});
        this.add(new Component[]{cleanUpFreq});
        Date lastRun = diskQuotaConfig.getLastCleanUpTime();
        HashMap<String, String> params = new HashMap<String, String>();
        if (lastRun == null) {
            resourceId = "DiskQuotaConfigPanel.cleanUpLastRunNever";
        } else {
            resourceId = "DiskQuotaConfigPanel.cleanUpLastRun";
            long timeAgo = (System.currentTimeMillis() - lastRun.getTime()) / 1000L;
            String timeUnits = "s";
            if (timeAgo > 86400L) {
                timeUnits = "d";
                timeAgo /= 86400L;
            } else if (timeAgo > 3600L) {
                timeUnits = "h";
                timeAgo /= 3600L;
            } else if (timeAgo > 60L) {
                timeUnits = "m";
                timeAgo /= 60L;
            }
            params.put("x", String.valueOf(timeAgo));
            params.put("timeUnit", timeUnits);
        }
        StringResourceModel lastRunModel = new StringResourceModel(resourceId, (Component)this, (IModel)new Model(params));
        this.add(new Component[]{new Label("cleanUpLastRun", (IModel)lastRunModel)});
    }

    private void addDiskQuotaIntegrationEnablement(IModel<DiskQuotaConfig> diskQuotaModel) {
        PropertyModel quotaEnablementModel = new PropertyModel(diskQuotaModel, "enabled");
        CheckBox diskQuotaIntegration = DiskQuotaConfigPanel.checkbox("enableDiskQuota", (IModel<Boolean>)quotaEnablementModel, "DiskQuotaConfigPanel.enableDiskQuota.title");
        this.add(new Component[]{diskQuotaIntegration});
    }

    private void addGlobalQuotaStatusBar(IModel<Quota> globalQuotaModel, IModel<Quota> globalUsedQuotaModel, IModel<String> progressMessageModel) {
        StorageUnit bestUnitForUsed;
        Quota limit = (Quota)globalQuotaModel.getObject();
        Quota used = (Quota)globalUsedQuotaModel.getObject();
        BigInteger limitValue = limit.getBytes();
        BigInteger usedValue = used.getBytes();
        StorageUnit bestUnitForLimit = StorageUnit.bestFit((BigInteger)limitValue);
        StorageUnit biggerUnit = bestUnitForLimit.compareTo((Enum)(bestUnitForUsed = StorageUnit.bestFit((BigInteger)usedValue))) > 0 ? bestUnitForLimit : bestUnitForUsed;
        BigDecimal showLimit = StorageUnit.B.convertTo(new BigDecimal(limitValue), biggerUnit);
        BigDecimal showUsed = StorageUnit.B.convertTo(new BigDecimal(usedValue), biggerUnit);
        Model limitModel = new Model((Serializable)showLimit);
        Model usedModel = new Model((Serializable)showUsed);
        StatusBar statusBar = new StatusBar("globalQuotaProgressBar", (IModel<Number>)limitModel, (IModel<Number>)usedModel, progressMessageModel);
        this.add(new Component[]{statusBar});
    }

    public StorageUnit getStorageUnit() {
        return (StorageUnit)this.configQuotaUnitModel.getObject();
    }

    public Object getQuotaValue() {
        return this.configQuotaValueModel.getObject();
    }

    static CheckBox checkbox(String id, IModel<Boolean> model, String titleKey) {
        CheckBox checkBox = new CheckBox(id, model);
        if (null != titleKey) {
            AttributeModifier attributeModifier = new AttributeModifier("title", true, (IModel)new StringResourceModel(titleKey, (Component)null, null));
            checkBox.add(new IBehavior[]{attributeModifier});
        }
        return checkBox;
    }
}

