/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.blob;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.web.blob.BlobStoreTypes;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geowebcache.config.BlobStoreConfig;

public class BlobStoresProvider
extends GeoServerDataProvider<BlobStoreConfig> {
    public static final GeoServerDataProvider.Property<BlobStoreConfig> ID = new GeoServerDataProvider.BeanProperty("id", "id");
    public static final GeoServerDataProvider.Property<BlobStoreConfig> TYPE = new GeoServerDataProvider.BeanProperty("type", "class");
    public static final GeoServerDataProvider.Property<BlobStoreConfig> ENABLED = new GeoServerDataProvider.BeanProperty("enabled", "enabled");
    public static final GeoServerDataProvider.Property<BlobStoreConfig> DEFAULT = new GeoServerDataProvider.BeanProperty("default", "default");

    protected List<GeoServerDataProvider.Property<BlobStoreConfig>> getProperties() {
        return Arrays.asList(ID, TYPE, ENABLED, DEFAULT);
    }

    protected Comparator<BlobStoreConfig> getComparator(final SortParam sort) {
        if (sort != null && sort.getProperty().equals(TYPE.getName())) {
            return new Comparator<BlobStoreConfig>(){

                @Override
                public int compare(BlobStoreConfig o1, BlobStoreConfig o2) {
                    int r = BlobStoreTypes.getFromClass(o1.getClass()).toString().compareTo(BlobStoreTypes.getFromClass(o2.getClass()).toString());
                    return sort.isAscending() ? r : -r;
                }
            };
        }
        return super.getComparator(sort);
    }

    protected List<BlobStoreConfig> getItems() {
        return GWC.get().getBlobStores();
    }
}

