/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.blob;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.web.blob.BlobStorePage;
import org.geoserver.gwc.web.blob.BlobStoreTypes;
import org.geoserver.gwc.web.blob.BlobStoresProvider;
import org.geoserver.web.CatalogIconFactory;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.Icon;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.SimpleAjaxLink;
import org.geowebcache.config.BlobStoreConfig;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.layer.TileLayer;

public class BlobStoresPage
extends GeoServerSecuredPage {
    private AjaxLink<Object> remove;
    private GeoServerTablePanel<BlobStoreConfig> blobStoresPanel;
    private GeoServerDialog dialog;

    public BlobStoresPage() {
        Component[] componentArray = new Component[1];
        this.dialog = new GeoServerDialog("confirmDeleteDialog");
        componentArray[0] = this.dialog;
        this.add(componentArray);
        this.dialog.setTitle((IModel)new ParamResourceModel("confirmDeleteDialog.title", (Component)this.getPage(), new Object[0]));
        this.dialog.setInitialHeight(200);
        Fragment header = new Fragment("headerPanel", "header", (MarkupContainer)this);
        header.add(new Component[]{new AjaxLink<Object>("addNew"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                this.setResponsePage((Page)new BlobStorePage());
            }
        }});
        Component[] componentArray2 = new Component[1];
        this.remove = new AjaxLink<Object>("removeSelected"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                final HashSet<String> ids = new HashSet<String>();
                final ArrayList<String> assignedLayers = new ArrayList<String>();
                for (BlobStoreConfig config : BlobStoresPage.this.blobStoresPanel.getSelection()) {
                    if (config.isDefault()) {
                        this.error((Serializable)((Object)new ParamResourceModel("deleteError", (Component)this.getPage(), new Object[0]).getString()));
                        target.addComponent((Component)BlobStoresPage.this.feedbackPanel);
                        return;
                    }
                    ids.add(config.getId());
                }
                for (TileLayer layer : GWC.get().getTileLayers()) {
                    if (layer.getBlobStoreId() == null || !ids.contains(layer.getBlobStoreId())) continue;
                    assignedLayers.add(layer.getName());
                }
                if (assignedLayers.size() > 0) {
                    BlobStoresPage.this.dialog.showOkCancel(target, new GeoServerDialog.DialogDelegate(){
                        private static final long serialVersionUID = 5257987095800108993L;
                        private String error = null;

                        protected Component getContents(String id) {
                            StringBuilder sb = new StringBuilder();
                            sb.append(new ParamResourceModel("confirmDeleteDialog.content", (Component)this.getPage(), new Object[0]).getString());
                            for (String layerName : assignedLayers) {
                                sb.append("\n&nbsp;&nbsp;");
                                sb.append(StringEscapeUtils.escapeHtml((String)layerName));
                            }
                            return new MultiLineLabel("userPanel", sb.toString()).setEscapeModelStrings(false);
                        }

                        protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                            try {
                                GWC.get().removeBlobStores((Iterable)ids);
                                for (String layerName : assignedLayers) {
                                    TileLayer layer = GWC.get().getTileLayerByName(layerName);
                                    layer.setBlobStoreId(null);
                                    GWC.get().save(layer);
                                }
                            }
                            catch (ConfigurationException e) {
                                this.error = e.getMessage();
                            }
                            return true;
                        }

                        public void onClose(AjaxRequestTarget target) {
                            if (this.error != null) {
                                this.error((Serializable)((Object)this.error));
                                target.addComponent((Component)BlobStoresPage.this.feedbackPanel);
                            } else {
                                target.addComponent((Component)BlobStoresPage.this.blobStoresPanel);
                            }
                        }
                    });
                } else {
                    try {
                        GWC.get().removeBlobStores(ids);
                    }
                    catch (ConfigurationException e) {
                        this.error((Serializable)((Object)e.toString()));
                        target.addComponent((Component)BlobStoresPage.this.feedbackPanel);
                    }
                    target.addComponent((Component)BlobStoresPage.this.blobStoresPanel);
                }
            }
        };
        componentArray2[0] = this.remove;
        header.add(componentArray2);
        this.remove.setOutputMarkupId(true);
        this.remove.setEnabled(false);
        this.setHeaderPanel((Component)header);
        Component[] componentArray3 = new Component[1];
        this.blobStoresPanel = new GeoServerTablePanel<BlobStoreConfig>("storesPanel", (GeoServerDataProvider)new BlobStoresProvider(), true){
            private static final long serialVersionUID = -5380703588873422601L;

            protected Component getComponentForProperty(String id, IModel itemModel, GeoServerDataProvider.Property<BlobStoreConfig> property) {
                final BlobStoreConfig blobStore = (BlobStoreConfig)itemModel.getObject();
                if (property == BlobStoresProvider.ID) {
                    return new SimpleAjaxLink(id, itemModel, property.getModel(itemModel)){
                        private static final long serialVersionUID = 1L;

                        protected void onClick(AjaxRequestTarget target) {
                            this.setResponsePage((Page)new BlobStorePage(blobStore));
                        }
                    };
                }
                if (property == BlobStoresProvider.DEFAULT) {
                    if (blobStore.isDefault()) {
                        return new Icon(id, CatalogIconFactory.ENABLED_ICON);
                    }
                    return new Label(id, "");
                }
                if (property == BlobStoresProvider.ENABLED) {
                    if (blobStore.isEnabled()) {
                        return new Icon(id, CatalogIconFactory.ENABLED_ICON);
                    }
                    return new Label(id, "");
                }
                if (property == BlobStoresProvider.TYPE) {
                    return new Label(id, BlobStoreTypes.getFromClass(blobStore.getClass()).toString());
                }
                return null;
            }

            protected void onSelectionUpdate(AjaxRequestTarget target) {
                BlobStoresPage.this.remove.setEnabled(BlobStoresPage.this.blobStoresPanel.getSelection().size() > 0);
                target.addComponent((Component)BlobStoresPage.this.remove);
            }
        };
        componentArray3[0] = this.blobStoresPanel;
        this.add(componentArray3);
        this.blobStoresPanel.setOutputMarkupId(true);
    }
}

