/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.blob;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.geoserver.gwc.web.blob.BlobStoreType;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.config.BlobStoreConfig;

public final class BlobStoreTypes {
    private static Map<Class<? extends BlobStoreConfig>, BlobStoreType> TYPES;

    private BlobStoreTypes() {
    }

    private static Map<Class<? extends BlobStoreConfig>, BlobStoreType> getTypes() {
        if (TYPES == null) {
            TYPES = new TreeMap<Class, BlobStoreType>(new Comparator<Class>(){

                @Override
                public int compare(Class o1, Class o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            });
            for (BlobStoreType type : GeoWebCacheExtensions.extensions(BlobStoreType.class)) {
                TYPES.put(type.getConfigClass(), type);
            }
        }
        return TYPES;
    }

    public static BlobStoreType getFromClass(Class<? extends BlobStoreConfig> clazz) {
        return BlobStoreTypes.getTypes().get(clazz);
    }

    public static List<BlobStoreType> getAll() {
        return new ArrayList<BlobStoreType>(BlobStoreTypes.getTypes().values());
    }
}

