/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.blob;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.validation.AbstractFormValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.web.blob.BlobStoreType;
import org.geoserver.gwc.web.blob.BlobStoreTypes;
import org.geoserver.gwc.web.blob.BlobStoresPage;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geowebcache.config.BlobStoreConfig;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.layer.TileLayer;

public class BlobStorePage
extends GeoServerSecuredPage {
    private DropDownChoice<BlobStoreType> typeOfBlobStore;
    private WebMarkupContainer blobConfigContainer;
    private Form<BlobStoreConfig> blobStoreForm;
    private TextField<String> tfId;
    private CheckBox cbDefault;
    private CheckBox cbEnabled;
    private GeoServerDialog dialog;

    public BlobStorePage() {
        this(null);
    }

    public BlobStorePage(final BlobStoreConfig originalStore) {
        final ArrayList<String> assignedLayers = new ArrayList<String>();
        Component[] componentArray = new Component[1];
        this.dialog = new GeoServerDialog("confirmDisableDialog");
        componentArray[0] = this.dialog;
        this.add(componentArray);
        this.dialog.setTitle((IModel)new ParamResourceModel("confirmDisableDialog.title", (Component)this.getPage(), new Object[0]));
        this.dialog.setInitialHeight(200);
        this.typeOfBlobStore = new DropDownChoice("typeOfBlobStore", (IModel)new Model(), BlobStoreTypes.getAll());
        this.typeOfBlobStore.setOutputMarkupId(true);
        this.typeOfBlobStore.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = 359589121400814043L;

            protected void onUpdate(AjaxRequestTarget target) {
                BlobStorePage.this.blobStoreForm.setVisible(BlobStorePage.this.typeOfBlobStore.getModelObject() != null);
                if (BlobStorePage.this.typeOfBlobStore.getModelObject() != null) {
                    BlobStorePage.this.blobStoreForm.getModel().setObject(((BlobStoreType)BlobStorePage.this.typeOfBlobStore.getModelObject()).newConfigObject());
                    BlobStorePage.this.blobStoreForm.addOrReplace(new Component[]{((BlobStoreType)BlobStorePage.this.typeOfBlobStore.getModelObject()).createPanel("blobSpecificPanel", BlobStorePage.this.blobStoreForm.getModel())});
                }
                target.addComponent((Component)BlobStorePage.this.blobConfigContainer);
            }
        }});
        this.typeOfBlobStore.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("typeOfBlobStore.title"))});
        Form selector = new Form("selector");
        selector.add(new Component[]{this.typeOfBlobStore});
        this.add(new Component[]{selector});
        this.blobConfigContainer = new WebMarkupContainer("blobConfigContainer");
        this.blobConfigContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.blobConfigContainer});
        this.blobStoreForm = new Form("blobStoreForm", (IModel)new CompoundPropertyModel(originalStore == null ? null : originalStore.clone()));
        this.blobConfigContainer.add(new Component[]{this.blobStoreForm});
        this.blobStoreForm.setVisible(originalStore != null);
        Component[] componentArray2 = new Component[1];
        this.tfId = new TextField("id");
        componentArray2[0] = this.tfId.setRequired(true);
        this.blobStoreForm.add(componentArray2);
        this.tfId.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("id.title"))});
        Component[] componentArray3 = new Component[1];
        this.cbEnabled = new CheckBox("enabled");
        componentArray3[0] = this.cbEnabled;
        this.blobStoreForm.add(componentArray3);
        this.cbEnabled.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("enabled.title"))});
        Component[] componentArray4 = new Component[1];
        this.cbDefault = new CheckBox("default");
        componentArray4[0] = this.cbDefault;
        this.blobStoreForm.add(componentArray4);
        this.cbDefault.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("default.title"))});
        if (originalStore != null) {
            this.typeOfBlobStore.getModel().setObject((Object)BlobStoreTypes.getFromClass(originalStore.getClass()));
            this.blobStoreForm.addOrReplace(new Component[]{((BlobStoreType)this.typeOfBlobStore.getModelObject()).createPanel("blobSpecificPanel", this.blobStoreForm.getModel())});
            this.typeOfBlobStore.setEnabled(false);
            for (TileLayer layer : GWC.get().getTileLayers()) {
                if (!originalStore.getId().equals(layer.getBlobStoreId())) continue;
                assignedLayers.add(layer.getName());
            }
        }
        this.blobStoreForm.add((IFormValidator)new AbstractFormValidator(){
            private static final long serialVersionUID = 5240602030478856537L;

            public FormComponent<?>[] getDependentFormComponents() {
                return new FormComponent[]{BlobStorePage.this.cbDefault, BlobStorePage.this.cbEnabled};
            }

            public void validate(Form<?> form) {
                BlobStoreConfig blobStore = (BlobStoreConfig)form.getModelObject();
                if (blobStore.isDefault() && !((Boolean)BlobStorePage.this.cbDefault.getConvertedInput()).booleanValue()) {
                    form.error((Serializable)((Object)new ParamResourceModel("defaultError", (Component)BlobStorePage.this.getPage(), new Object[0]).getString()));
                } else if (((Boolean)BlobStorePage.this.cbDefault.getConvertedInput()).booleanValue() && !((Boolean)BlobStorePage.this.cbEnabled.getConvertedInput()).booleanValue()) {
                    form.error((Serializable)((Object)new ParamResourceModel("enabledError", (Component)BlobStorePage.this.getPage(), new Object[0]).getString()));
                }
            }
        });
        this.blobStoreForm.add((IFormValidator)new AbstractFormValidator(){
            private static final long serialVersionUID = 5240602030478856537L;

            public FormComponent<?>[] getDependentFormComponents() {
                return new FormComponent[]{BlobStorePage.this.tfId};
            }

            public void validate(Form<?> form) {
                for (BlobStoreConfig otherBlobStore : GWC.get().getBlobStores()) {
                    if (otherBlobStore == originalStore || !otherBlobStore.getId().equals(BlobStorePage.this.tfId.getConvertedInput())) continue;
                    form.error((Serializable)((Object)new ParamResourceModel("duplicateIdError", (Component)BlobStorePage.this.getPage(), new Object[0]).getString()));
                }
            }
        });
        this.blobStoreForm.add(new Component[]{new AjaxSubmitLink("save"){
            private static final long serialVersionUID = 3735176778941168701L;

            public void onSubmit(AjaxRequestTarget target, Form<?> form) {
                final BlobStoreConfig blobStore = (BlobStoreConfig)this.getForm().getModelObject();
                if (originalStore != null && originalStore.isEnabled() && !blobStore.isEnabled() && assignedLayers.size() > 0) {
                    BlobStorePage.this.dialog.showOkCancel(target, new GeoServerDialog.DialogDelegate(){
                        private static final long serialVersionUID = 5257987095800108993L;
                        private boolean success;
                        private String error = null;

                        protected Component getContents(String id) {
                            StringBuilder sb = new StringBuilder();
                            sb.append(new ParamResourceModel("confirmDisableDialog.content", (Component)this.getPage(), new Object[0]).getString());
                            for (String layer : assignedLayers) {
                                sb.append("\n&nbsp;&nbsp;");
                                sb.append(StringEscapeUtils.escapeHtml((String)layer));
                            }
                            return new MultiLineLabel("userPanel", sb.toString()).setEscapeModelStrings(false);
                        }

                        protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                            try {
                                BlobStorePage.this.save(originalStore, blobStore, assignedLayers);
                                this.success = true;
                            }
                            catch (ConfigurationException e) {
                                this.error = e.getMessage();
                            }
                            return true;
                        }

                        public void onClose(AjaxRequestTarget target) {
                            if (this.success) {
                                BlobStorePage.this.doReturn(BlobStoresPage.class);
                            } else if (this.error != null) {
                                this.error((Serializable)((Object)this.error));
                                target.addComponent((Component)BlobStorePage.this.feedbackPanel);
                            }
                        }
                    });
                } else {
                    try {
                        BlobStorePage.this.save(originalStore, blobStore, assignedLayers);
                        BlobStorePage.this.doReturn(BlobStoresPage.class);
                    }
                    catch (ConfigurationException e) {
                        this.error((Serializable)((Object)e.getMessage()));
                        target.addComponent((Component)BlobStorePage.this.feedbackPanel);
                    }
                }
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                target.addComponent((Component)BlobStorePage.this.feedbackPanel);
            }
        }});
        this.blobStoreForm.add(new Component[]{new BookmarkablePageLink("cancel", BlobStoresPage.class)});
    }

    protected void save(BlobStoreConfig originalStore, BlobStoreConfig blobStore, List<String> assignedLayers) throws ConfigurationException {
        BlobStoreConfig defaultStore = null;
        if (blobStore.isDefault() && (originalStore == null || !originalStore.isDefault()) && (defaultStore = GWC.get().getDefaultBlobStore()) != null) {
            defaultStore.setDefault(false);
            GWC.get().modifyBlobStore(defaultStore.getId(), defaultStore);
        }
        try {
            if (originalStore == null) {
                GWC.get().addBlobStore(blobStore);
            } else {
                GWC.get().modifyBlobStore(originalStore.getId(), blobStore);
            }
        }
        catch (ConfigurationException e) {
            if (defaultStore != null) {
                defaultStore.setDefault(true);
                GWC.get().modifyBlobStore(defaultStore.getId(), defaultStore);
            }
            throw e;
        }
        if (originalStore != null) {
            boolean disable;
            boolean updateId = !blobStore.getId().equals(originalStore.getId());
            boolean bl = disable = originalStore.isEnabled() && !blobStore.isEnabled();
            if (updateId || disable) {
                for (String layerName : assignedLayers) {
                    TileLayer layer = GWC.get().getTileLayerByName(layerName);
                    if (updateId) {
                        layer.setBlobStoreId(blobStore.getId());
                    }
                    if (disable) {
                        layer.setEnabled(false);
                    }
                    GWC.get().save(layer);
                }
            }
        }
    }
}

