/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import java.awt.Rectangle;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import net.opengis.gml.CodeType;
import net.opengis.gml.DirectPositionType;
import net.opengis.gml.RectifiedGridType;
import net.opengis.gml.TimePositionType;
import net.opengis.gml.VectorType;
import net.opengis.wcs10.AxisSubsetType;
import net.opengis.wcs10.DescribeCoverageType;
import net.opengis.wcs10.DomainSubsetType;
import net.opengis.wcs10.GetCapabilitiesType;
import net.opengis.wcs10.GetCoverageType;
import net.opengis.wcs10.InterpolationMethodType;
import net.opengis.wcs10.IntervalType;
import net.opengis.wcs10.OutputType;
import net.opengis.wcs10.RangeSubsetType;
import net.opengis.wcs10.SpatialSubsetType;
import net.opengis.wcs10.TimePeriodType;
import net.opengis.wcs10.TimeSequenceType;
import net.opengis.wcs10.TypedLiteralType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.util.ReaderDimensionsAccessor;
import org.geoserver.config.GeoServer;
import org.geoserver.data.util.CoverageUtils;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.wcs.CoverageCleanerCallback;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs.WebCoverageService100;
import org.geoserver.wcs.response.Wcs10CapsTransformer;
import org.geoserver.wcs.response.Wcs10DescribeCoverageTransformer;
import org.geoserver.wcs.responses.CoverageResponseDelegate;
import org.geoserver.wcs.responses.CoverageResponseDelegateFinder;
import org.geotools.coverage.grid.GeneralGridGeometry;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.resources.CRSUtilities;
import org.geotools.util.DateRange;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.filter.Filter;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.vfny.geoserver.util.WCSUtils;
import org.vfny.geoserver.wcs.WcsException;

public class DefaultWebCoverageService100
implements WebCoverageService100 {
    private Catalog catalog;
    private GeoServer geoServer;
    private CoverageResponseDelegateFinder responseFactory;
    private static final Logger LOGGER = Logging.getLogger(DefaultWebCoverageService100.class);

    public DefaultWebCoverageService100(GeoServer geoServer, CoverageResponseDelegateFinder responseFactory) {
        this.geoServer = geoServer;
        this.catalog = geoServer.getCatalog();
        this.responseFactory = responseFactory;
    }

    @Override
    public WCSInfo getServiceInfo() {
        return (WCSInfo)this.geoServer.getService(WCSInfo.class);
    }

    @Override
    public Wcs10CapsTransformer getCapabilities(GetCapabilitiesType request) {
        String version;
        ArrayList<String> provided = new ArrayList<String>();
        provided.add("1.0.0");
        ArrayList<String> accepted = null;
        if (request.getVersion() != null) {
            accepted = new ArrayList<String>();
            accepted.add(request.getVersion());
        }
        if ("1.0.0".equals(version = RequestUtils.getVersionPreOws(provided, accepted))) {
            Wcs10CapsTransformer capsTransformer = new Wcs10CapsTransformer(this.geoServer);
            capsTransformer.setEncoding(Charset.forName(this.getServiceInfo().getGeoServer().getSettings().getCharset()));
            return capsTransformer;
        }
        throw new WcsException("Could not understand version:" + version);
    }

    @Override
    public Wcs10DescribeCoverageTransformer describeCoverage(DescribeCoverageType request) {
        String version = request.getVersion();
        if ("1.0.0".equals(version)) {
            WCSInfo wcs = this.getServiceInfo();
            Wcs10DescribeCoverageTransformer describeTransformer = new Wcs10DescribeCoverageTransformer(wcs, this.catalog);
            describeTransformer.setEncoding(Charset.forName(wcs.getGeoServer().getSettings().getCharset()));
            return describeTransformer;
        }
        throw new WcsException("Could not understand version:" + version);
    }

    @Override
    public GridCoverage[] getCoverage(GetCoverageType request) {
        WCSInfo wcs = this.getServiceInfo();
        CoverageInfo meta = null;
        GridCoverage2D coverage = null;
        ArrayList<GridCoverage2D> coverageResults = new ArrayList<GridCoverage2D>();
        try {
            EList axisSubset;
            Filter filter;
            String axisName;
            AxisSubsetType axis;
            DimensionInfo elevationDimension;
            Rectangle destinationSize;
            AffineTransform2D destinationG2W;
            CoordinateReferenceSystem targetCRS;
            meta = this.catalog.getCoverageByName(request.getSourceCoverage());
            if (meta == null) {
                throw new WcsException("Cannot find sourceCoverage " + request.getSourceCoverage() + " in the catalog!");
            }
            DefaultWebCoverageService100.checkRangeSubset(meta, request.getRangeSubset());
            DefaultWebCoverageService100.checkInterpolationMethod(meta, request.getInterpolationMethod());
            this.checkOutput(meta, request.getOutput());
            DomainSubsetType domainSubset = request.getDomainSubset();
            TimeSequenceType temporalSubset = domainSubset.getTemporalSubset();
            SpatialSubsetType spatialSubset = domainSubset.getSpatialSubset();
            EList grids = spatialSubset.getGrid();
            if (grids.size() == 0) {
                throw new IllegalArgumentException("Invalid number of Grid for spatial subsetting was set:" + grids.size());
            }
            RectifiedGridType grid = (RectifiedGridType)grids.get(0);
            EList envelopes = spatialSubset.getEnvelope();
            if (envelopes.size() == 0) {
                throw new IllegalArgumentException("Invalid number of Envelope for spatial subsetting was set:" + envelopes.size());
            }
            GeneralEnvelope requestedEnvelope = (GeneralEnvelope)envelopes.get(0);
            OutputType output = request.getOutput();
            if (output == null) {
                throw new IllegalArgumentException("Output type was null");
            }
            CodeType outputCRS = output.getCrs();
            int dimension = grid.getDimension().intValue();
            if (dimension == 3) {
                throw new WcsException("We support a third dimension only via a specifica Axis in Range", WcsException.WcsExceptionCode.InvalidParameterValue, null);
            }
            GridCoverage2DReader reader = (GridCoverage2DReader)meta.getGridCoverageReader(null, WCSUtils.getReaderHints((WCSInfo)wcs));
            if (reader == null) {
                return (GridCoverage[])coverageResults.toArray(new GridCoverage2D[0]);
            }
            GeneralEnvelope nativeEnvelope = reader.getOriginalEnvelope();
            CoordinateReferenceSystem nativeCRS = nativeEnvelope.getCoordinateReferenceSystem();
            String requestedCRS = null;
            if (outputCRS != null) {
                requestedCRS = outputCRS.getValue();
            }
            if (requestedCRS == null) {
                targetCRS = reader.getOriginalEnvelope().getCoordinateReferenceSystem();
                requestedCRS = CRS.lookupIdentifier((IdentifiedObject)targetCRS, (boolean)true);
            } else {
                targetCRS = CRS.decode((String)requestedCRS, (boolean)true);
            }
            GridEnvelope limits = grid.getLimits();
            if (limits != null) {
                int[] lowers = limits.getLow().getCoordinateValues();
                destinationG2W = null;
                destinationSize = new Rectangle(lowers[0], lowers[1], limits.getSpan(0), limits.getSpan(1));
            } else if (grid.getOffsetVector() != null && grid.getOffsetVector().size() > 0) {
                VectorType offsetVector = (VectorType)grid.getOffsetVector().get(0);
                List offsetValues = offsetVector.getValue();
                double resX = (Double)offsetValues.get(0);
                double resY = (Double)offsetValues.get(1);
                DirectPositionType origin_ = grid.getOrigin().getPos();
                destinationSize = null;
                destinationG2W = new AffineTransform2D(resX, 0.0, 0.0, resY, ((Double)origin_.getValue().get(0)).doubleValue(), ((Double)origin_.getValue().get(1)).doubleValue());
            } else {
                throw new WcsException("Invalid Grid value:" + grid.toString(), WcsException.WcsExceptionCode.InvalidParameterValue, null);
            }
            ParameterValueGroup readParametersDescriptor = reader.getFormat().getReadParameters();
            GeneralParameterValue[] readParameters = CoverageUtils.getParameters((ParameterValueGroup)readParametersDescriptor, (Map)meta.getParameters());
            readParameters = readParameters != null ? readParameters : new GeneralParameterValue[]{};
            GridGeometry2D requestedGridGeometry = destinationSize != null ? new GridGeometry2D((GridEnvelope)new GridEnvelope2D(destinationSize), DefaultWebCoverageService100.getHorizontalEnvelope(requestedEnvelope)) : new GridGeometry2D(PixelInCell.CELL_CENTER, destinationG2W, DefaultWebCoverageService100.getHorizontalEnvelope(requestedEnvelope), null);
            ParameterValue requestedGridGeometryParam = new DefaultParameterDescriptor(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString(), GeneralGridGeometry.class, null, (Object)requestedGridGeometry).createValue();
            GeneralParameterValue[] tmpArray = new GeneralParameterValue[readParameters.length + 1];
            System.arraycopy(readParameters, 0, tmpArray, 0, readParameters.length);
            tmpArray[tmpArray.length - 1] = requestedGridGeometryParam;
            readParameters = tmpArray;
            ArrayList parameterDescriptors = new ArrayList(readParametersDescriptor.getDescriptor().descriptors());
            Set dynamicParameters = reader.getDynamicParameters();
            parameterDescriptors.addAll(dynamicParameters);
            ReaderDimensionsAccessor dimensions = new ReaderDimensionsAccessor(reader);
            DimensionInfo timeDimension = (DimensionInfo)meta.getMetadata().get("time", DimensionInfo.class);
            if (timeDimension != null && timeDimension.isEnabled() && dimensions.hasTime()) {
                ArrayList<Date> timeValues = new ArrayList<Date>();
                if (temporalSubset != null && temporalSubset.getTimePosition() != null) {
                    EList timePosition = temporalSubset.getTimePosition();
                    for (TimePositionType tp : timePosition) {
                        Date date = (Date)tp.getValue();
                        if (date == null) {
                            date = dimensions.getMaxTime();
                        }
                        timeValues.add(date);
                    }
                    EList timePeriods = temporalSubset.getTimePeriod();
                    for (TimePeriodType tp : timePeriods) {
                        Date begin = (Date)tp.getBeginPosition().getValue();
                        Date end = (Date)tp.getEndPosition().getValue();
                        timeValues.add((Date)new DateRange(begin, end));
                    }
                }
                if (timeValues.isEmpty()) {
                    Date date = dimensions.getMaxTime();
                    timeValues.add(date);
                }
                readParameters = CoverageUtils.mergeParameter(parameterDescriptors, (GeneralParameterValue[])readParameters, timeValues, (String[])new String[]{"TIME", "Time"});
            }
            if ((elevationDimension = (DimensionInfo)meta.getMetadata().get("elevation", DimensionInfo.class)) != null && elevationDimension.isEnabled() && dimensions.hasElevation()) {
                ArrayList<Double> elevations = new ArrayList<Double>();
                EList axisSubset2 = null;
                if (request.getRangeSubset() != null && (axisSubset2 = request.getRangeSubset().getAxisSubset()).size() > 0) {
                    for (int a = 0; a < axisSubset2.size(); ++a) {
                        axis = (AxisSubsetType)axisSubset2.get(a);
                        axisName = axis.getName();
                        if (!axisName.equalsIgnoreCase("ELEVATION")) continue;
                        if (axis.getSingleValue().size() > 0) {
                            for (int s = 0; s < axis.getSingleValue().size(); ++s) {
                                elevations.add(Double.parseDouble(((TypedLiteralType)axis.getSingleValue().get(s)).getValue()));
                            }
                            continue;
                        }
                        if (axis.getInterval().size() <= 0) continue;
                        IntervalType interval = (IntervalType)axis.getInterval().get(0);
                        int min = Integer.parseInt(interval.getMin().getValue());
                        int max = Integer.parseInt(interval.getMax().getValue());
                        int res = interval.getRes() != null ? Integer.parseInt(interval.getRes().getValue()) : 1;
                        int count = (int)(Math.floor(max - min) / (double)res + 1.0);
                        for (int b = 0; b < count; ++b) {
                            elevations.add(new Double(min + b * res));
                        }
                    }
                }
                if (elevations.isEmpty()) {
                    elevations.add(dimensions.getMinElevation());
                }
                readParameters = CoverageUtils.mergeParameter(parameterDescriptors, (GeneralParameterValue[])readParameters, elevations, (String[])new String[]{"ELEVATION", "Elevation"});
            }
            if (request.getRangeSubset() != null) {
                EList axisSubset3 = request.getRangeSubset().getAxisSubset();
                int asCount = axisSubset3 == null ? 0 : axisSubset3.size();
                for (int i = 0; i < asCount; ++i) {
                    int valueCount;
                    axis = (AxisSubsetType)axisSubset3.get(i);
                    axisName = axis.getName();
                    if (axisName.equalsIgnoreCase("ELEVATION")) continue;
                    Serializable dimInfo = meta.getMetadata().get((Object)("custom_dimension_" + axisName));
                    axisName = axisName.toUpperCase();
                    if (!(dimInfo instanceof DimensionInfo) || !dimensions.hasDomain(axisName) || (valueCount = axis.getSingleValue().size()) <= 0) continue;
                    ArrayList<String> dimValues = new ArrayList<String>(valueCount);
                    for (int s = 0; s < valueCount; ++s) {
                        dimValues.add(((TypedLiteralType)axis.getSingleValue().get(s)).getValue());
                    }
                    readParameters = CoverageUtils.mergeParameter(parameterDescriptors, (GeneralParameterValue[])readParameters, dimValues, (String[])new String[]{axisName});
                }
            }
            if ((filter = WCSUtils.getRequestFilter()) != null) {
                readParameters = CoverageUtils.mergeParameter(parameterDescriptors, (GeneralParameterValue[])readParameters, (Object)filter, (String[])new String[]{"FILTER", "Filter"});
            }
            WCSUtils.checkInputLimits((WCSInfo)wcs, (CoverageInfo)meta, (GridCoverage2DReader)reader, (GridGeometry2D)requestedGridGeometry);
            Interpolation interpolation = Interpolation.getInstance((int)0);
            String interpolationType = null;
            if (request.getInterpolationMethod() != null && (interpolationType = request.getInterpolationMethod().getLiteral()) != null) {
                if (interpolationType.equalsIgnoreCase("bilinear")) {
                    interpolation = Interpolation.getInstance((int)1);
                } else if (interpolationType.equalsIgnoreCase("bicubic")) {
                    interpolation = Interpolation.getInstance((int)2);
                } else if (interpolationType.equalsIgnoreCase("nearest neighbor")) {
                    interpolation = Interpolation.getInstance((int)0);
                }
                readParameters = CoverageUtils.mergeParameter(parameterDescriptors, (GeneralParameterValue[])readParameters, (Object)interpolation, (String[])new String[]{"interpolation"});
                if (meta.getStore().getFormat() instanceof ImageMosaicFormat) {
                    GeneralParameterValue[] temp = new GeneralParameterValue[readParameters.length + 1];
                    System.arraycopy(readParameters, 0, temp, 0, readParameters.length);
                    temp[temp.length - 1] = ImageMosaicFormat.INTERPOLATION.createValue();
                    ((ParameterValue)temp[temp.length - 1]).setValue((Object)interpolation);
                    readParameters = temp;
                }
            }
            if ((coverage = reader.read(readParameters = WCSUtils.replaceParameter((GeneralParameterValue[])readParameters, (Object)Boolean.FALSE, (ParameterDescriptor)AbstractGridFormat.USE_JAI_IMAGEREAD))) == null || !(coverage instanceof GridCoverage2D)) {
                throw new IOException("No raster data found in the request (it may be that the request bbox is outside of the coverage area, or that the filters used match no portions of it.");
            }
            WCSUtils.checkInputLimits((WCSInfo)wcs, (GridCoverage2D)coverage);
            GridCoverage2D bandSelectedCoverage = coverage;
            if (request.getRangeSubset() != null && (axisSubset = request.getRangeSubset().getAxisSubset()).size() > 0) {
                for (int a = 0; a < axisSubset.size(); ++a) {
                    AxisSubsetType axis2 = (AxisSubsetType)axisSubset.get(a);
                    try {
                        String axisName2 = axis2.getName();
                        if (!axisName2.equalsIgnoreCase("Band")) continue;
                        int[] bands = null;
                        if (axis2.getSingleValue().size() > 0) {
                            bands = new int[axis2.getSingleValue().size()];
                            for (int s = 0; s < axis2.getSingleValue().size(); ++s) {
                                bands[s] = Integer.parseInt(((TypedLiteralType)axis2.getSingleValue().get(s)).getValue()) - 1;
                            }
                        } else if (axis2.getInterval().size() > 0) {
                            IntervalType interval = (IntervalType)axis2.getInterval().get(0);
                            int min = Integer.parseInt(interval.getMin().getValue());
                            int max = Integer.parseInt(interval.getMax().getValue());
                            int res = interval.getRes() != null ? Integer.parseInt(interval.getRes().getValue()) : 1;
                            bands = new int[(int)(Math.floor(max - min) / (double)res + 1.0)];
                            for (int b = 0; b < bands.length; ++b) {
                                bands[b] = min + b * res - 1;
                            }
                        }
                        bandSelectedCoverage = (GridCoverage2D)WCSUtils.bandSelect((GridCoverage)coverage, (int[])bands);
                        continue;
                    }
                    catch (Exception e) {
                        throw new WcsException("Band Select Operation: " + e.getLocalizedMessage());
                    }
                }
            }
            GeneralEnvelope destinationEnvelope = (GeneralEnvelope)DefaultWebCoverageService100.getHorizontalEnvelope(DefaultWebCoverageService100.computeIntersectionEnvelope(requestedEnvelope, nativeEnvelope));
            if (targetCRS != null) {
                destinationEnvelope = CRS.transform((Envelope)destinationEnvelope, (CoordinateReferenceSystem)targetCRS);
                destinationEnvelope.setCoordinateReferenceSystem(targetCRS);
            }
            GridGeometry2D destinationGridGeometry = destinationSize != null ? new GridGeometry2D((GridEnvelope)new GridEnvelope2D(destinationSize), (Envelope)destinationEnvelope) : new GridGeometry2D(PixelInCell.CELL_CENTER, (MathTransform)destinationG2W, (Envelope)destinationEnvelope, null);
            WCSUtils.checkOutputLimits((WCSInfo)wcs, (GridEnvelope2D)destinationGridGeometry.getGridRange2D(), (SampleModel)bandSelectedCoverage.getRenderedImage().getSampleModel());
            GridCoverage2D finalCoverage = WCSUtils.resample((GridCoverage2D)bandSelectedCoverage, (CoordinateReferenceSystem)nativeCRS, (CoordinateReferenceSystem)targetCRS, (GridGeometry2D)destinationGridGeometry, (Interpolation)interpolation);
            coverageResults.add(finalCoverage);
            return (GridCoverage[])coverageResults.toArray(new GridCoverage2D[0]);
        }
        catch (Exception e) {
            if (coverage != null) {
                CoverageCleanerCallback.addCoverages((GridCoverage[])new GridCoverage[]{coverage});
            }
            if (e instanceof WcsException) {
                throw (WcsException)e;
            }
            throw new WcsException((Throwable)e);
        }
    }

    private static Envelope getHorizontalEnvelope(GeneralEnvelope originalEnvelope) throws FactoryException, TransformException {
        SingleCRS horizontalCRS;
        CoordinateReferenceSystem originalCRS = originalEnvelope.getCoordinateReferenceSystem();
        if (CRS.equalsIgnoreMetadata((Object)originalCRS, (Object)(horizontalCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)originalEnvelope.getCoordinateReferenceSystem())))) {
            return originalEnvelope;
        }
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)originalCRS, (CoordinateReferenceSystem)horizontalCRS);
        if (transform.isIdentity()) {
            return originalEnvelope;
        }
        return CRS.transform((MathTransform)transform, (Envelope)originalEnvelope);
    }

    private static GeneralEnvelope computeIntersectionEnvelope(GeneralEnvelope requestedEnvelope, GeneralEnvelope nativeEnvelope) {
        SingleCRS nativeCRS;
        SingleCRS requestCRS;
        block13: {
            requestCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)requestedEnvelope.getCoordinateReferenceSystem());
            nativeCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)nativeEnvelope.getCoordinateReferenceSystem());
            try {
                GeneralEnvelope retVal;
                Object destinationToSourceTransform = null;
                if (!CRS.equalsIgnoreMetadata((Object)requestCRS, (Object)nativeCRS)) {
                    retVal = CRS.transform((Envelope)DefaultWebCoverageService100.getHorizontalEnvelope(requestedEnvelope), (CoordinateReferenceSystem)nativeCRS);
                    retVal.setCoordinateReferenceSystem((CoordinateReferenceSystem)nativeCRS);
                } else {
                    retVal = new GeneralEnvelope(DefaultWebCoverageService100.getHorizontalEnvelope(requestedEnvelope));
                }
                if (!retVal.intersects((Envelope)nativeEnvelope, true)) {
                    return null;
                }
                retVal.intersect((Envelope)nativeEnvelope);
                retVal.setCoordinateReferenceSystem((CoordinateReferenceSystem)nativeCRS);
                return retVal;
            }
            catch (TransformException te) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, te.getLocalizedMessage(), te);
                }
            }
            catch (FactoryException fe) {
                if (!LOGGER.isLoggable(Level.FINE)) break block13;
                LOGGER.log(Level.FINE, fe.getLocalizedMessage(), fe);
            }
        }
        try {
            GeographicCRS nativeGeoCRS = CRSUtilities.getStandardGeographicCRS2D((CoordinateReferenceSystem)nativeCRS);
            GeneralEnvelope nativeGeoEnvelope = CRS.transform((Envelope)nativeEnvelope, (CoordinateReferenceSystem)nativeGeoCRS);
            nativeGeoEnvelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)nativeGeoCRS);
            GeneralEnvelope requestedBBOXInNativeGeographicCRS = null;
            if (!CRS.equalsIgnoreMetadata((Object)nativeCRS, (Object)requestCRS)) {
                requestedBBOXInNativeGeographicCRS = CRS.transform((Envelope)requestedEnvelope, (CoordinateReferenceSystem)nativeGeoCRS);
                requestedBBOXInNativeGeographicCRS.setCoordinateReferenceSystem((CoordinateReferenceSystem)nativeGeoCRS);
            }
            if (requestedBBOXInNativeGeographicCRS == null) {
                requestedBBOXInNativeGeographicCRS = new GeneralEnvelope((CoordinateReferenceSystem)requestCRS);
            }
            if (!requestedBBOXInNativeGeographicCRS.intersects((Envelope)nativeEnvelope, true)) {
                return null;
            }
            requestedBBOXInNativeGeographicCRS.intersect((Envelope)nativeGeoEnvelope);
            requestedBBOXInNativeGeographicCRS.setCoordinateReferenceSystem((CoordinateReferenceSystem)nativeGeoCRS);
            GeneralEnvelope approximateRequestedBBox = CRS.transform((Envelope)requestedBBOXInNativeGeographicCRS, (CoordinateReferenceSystem)requestCRS);
            approximateRequestedBBox.setCoordinateReferenceSystem((CoordinateReferenceSystem)requestCRS);
            return approximateRequestedBBox;
        }
        catch (TransformException te) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, te.getLocalizedMessage(), te);
            }
            LOGGER.log(Level.INFO, "We did not manage to crop the requested envelope, we fall back onto loading the whole coverage.");
            return null;
        }
    }

    private static void checkInterpolationMethod(CoverageInfo info, InterpolationMethodType interpolationMethod) {
        String interpolation = interpolationMethod.getLiteral();
        if (interpolation != null) {
            boolean interpolationSupported = false;
            if (interpolation.startsWith("nearest")) {
                interpolation = "nearest neighbor";
            }
            if (interpolation.equals("nearest neighbor") || info.getDefaultInterpolationMethod() != null && info.getDefaultInterpolationMethod().equalsIgnoreCase(interpolation)) {
                interpolationSupported = true;
            }
            for (String method : info.getInterpolationMethods()) {
                if (!interpolation.equalsIgnoreCase(method)) continue;
                interpolationSupported = true;
            }
            if (!interpolationSupported) {
                throw new WcsException("The requested Interpolation method is not supported by this Coverage.", WcsException.WcsExceptionCode.InvalidParameterValue, "RangeSubset");
            }
        }
    }

    private void checkOutput(CoverageInfo meta, OutputType output) {
        if (output == null) {
            return;
        }
        String format = output.getFormat().getValue();
        String declaredFormat = this.getDeclaredFormat(meta.getSupportedFormats(), format);
        if (declaredFormat == null) {
            throw new WcsException("format " + format + " is not supported for this coverage", WcsException.WcsExceptionCode.InvalidParameterValue, "format");
        }
    }

    private String getDeclaredFormat(List<String> supportedFormats, String format) {
        for (String sf : supportedFormats) {
            if (sf.equalsIgnoreCase(format.trim())) {
                return sf;
            }
            CoverageResponseDelegate delegate = this.responseFactory.encoderFor(sf);
            if (delegate == null || !delegate.canProduce(format)) continue;
            return sf;
        }
        return null;
    }

    private static void checkRangeSubset(CoverageInfo info, RangeSubsetType rangeSubset) {
        if (rangeSubset == null) {
            return;
        }
        for (int a = 0; a < rangeSubset.getAxisSubset().size(); ++a) {
            int b;
            int res;
            int max;
            int min;
            IntervalType interval;
            AxisSubsetType axisSubset = (AxisSubsetType)rangeSubset.getAxisSubset().get(a);
            if (axisSubset.getName().equalsIgnoreCase("Band")) {
                int[] bands = null;
                if (axisSubset.getSingleValue().size() > 0) {
                    bands = new int[]{Integer.parseInt(((TypedLiteralType)axisSubset.getSingleValue().get(0)).getValue())};
                } else if (axisSubset.getInterval().size() > 0) {
                    interval = (IntervalType)axisSubset.getInterval().get(0);
                    min = Integer.parseInt(interval.getMin().getValue());
                    max = Integer.parseInt(interval.getMax().getValue());
                    res = interval.getRes() != null ? Integer.parseInt(interval.getRes().getValue()) : 1;
                    bands = new int[(max - min) / res];
                    for (b = 0; b < bands.length; ++b) {
                        bands[b] = min + b * res;
                    }
                }
                if (bands != null) continue;
                throw new WcsException("Invalid values for axis " + axisSubset.getName(), WcsException.WcsExceptionCode.InvalidParameterValue, "AxisSubset");
            }
            if (!axisSubset.getName().equalsIgnoreCase("ELEVATION")) continue;
            double[] elevations = null;
            if (axisSubset.getSingleValue().size() > 0) {
                elevations = new double[axisSubset.getSingleValue().size()];
                for (int s = 0; s < axisSubset.getSingleValue().size(); ++s) {
                    elevations[s] = Double.parseDouble(((TypedLiteralType)axisSubset.getSingleValue().get(s)).getValue());
                }
                continue;
            }
            if (axisSubset.getInterval().size() <= 0) continue;
            interval = (IntervalType)axisSubset.getInterval().get(0);
            min = Integer.parseInt(interval.getMin().getValue());
            max = Integer.parseInt(interval.getMax().getValue());
            res = interval.getRes() != null ? Integer.parseInt(interval.getRes().getValue()) : 1;
            elevations = new double[(int)(Math.floor(max - min) / (double)res + 1.0)];
            for (b = 0; b < elevations.length; ++b) {
                elevations[b] = min + b * res;
            }
        }
    }
}

