/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.sld.bindings;

import javax.xml.namespace.QName;
import org.geotools.sld.CssParameter;
import org.geotools.sld.bindings.SLD;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Stroke;
import org.geotools.styling.StyleFactory;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.picocontainer.MutablePicoContainer;

public class SLDLineSymbolizerBinding
extends AbstractComplexBinding {
    StyleFactory styleFactory;

    public SLDLineSymbolizerBinding(StyleFactory styleFactory) {
        this.styleFactory = styleFactory;
    }

    public QName getTarget() {
        return SLD.LINESYMBOLIZER;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return LineSymbolizer.class;
    }

    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        LineSymbolizer ls = this.styleFactory.createLineSymbolizer();
        if (node.hasChild("Geometry")) {
            Expression geometry = (Expression)node.getChildValue("Geometry");
            if (geometry instanceof PropertyName) {
                PropertyName propertyName = (PropertyName)geometry;
                ls.setGeometryPropertyName(propertyName.getPropertyName());
            } else {
                ls.setGeometry(geometry);
            }
        }
        if (node.hasChild(Stroke.class)) {
            ls.setStroke((Stroke)node.getChildValue(Stroke.class));
        }
        for (CssParameter param : node.getChildValues(CssParameter.class)) {
            ls.getOptions().put(param.getName(), param.getExpression().evaluate(null, String.class));
        }
        return ls;
    }
}

