/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.sld.bindings;

import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.sld.bindings.SLD;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Graphic;
import org.geotools.styling.Mark;
import org.geotools.styling.StyleFactory;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.filter.expression.Expression;
import org.opengis.style.AnchorPoint;
import org.opengis.style.Displacement;
import org.picocontainer.MutablePicoContainer;

public class SLDGraphicBinding
extends AbstractComplexBinding {
    StyleFactory styleFactory;

    public SLDGraphicBinding(StyleFactory styleFactory) {
        this.styleFactory = styleFactory;
    }

    public QName getTarget() {
        return SLD.GRAPHIC;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Class getType() {
        return Graphic.class;
    }

    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        List l;
        Mark[] marks = null;
        ExternalGraphic[] graphics = null;
        if (node.getChild("Mark") != null) {
            l = node.getChildValues("Mark");
            marks = l.toArray(new Mark[l.size()]);
        } else {
            l = node.getChildValues("ExternalGraphic");
            graphics = l.toArray(new ExternalGraphic[l.size()]);
        }
        Expression opacity = (Expression)node.getChildValue("Opacity");
        Expression size = (Expression)node.getChildValue("Size");
        Expression rotation = (Expression)node.getChildValue("Rotation");
        Graphic graphic = this.styleFactory.createGraphic(graphics, marks, null, opacity, size, rotation);
        if (node.getChild("Displacement") != null) {
            graphic.setDisplacement((Displacement)node.getChildValue("Displacement"));
        }
        if (node.getChild("AnchorPoint") != null) {
            graphic.setAnchorPoint((AnchorPoint)node.getChildValue("AnchorPoint"));
        }
        return graphic;
    }
}

