/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.utils;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.linearref.LengthIndexedLine;

public class KmlCentroidBuilder {
    public Coordinate geometryCentroid(Geometry g) {
        if (g instanceof GeometryCollection) {
            g = this.selectRepresentativeGeometry((GeometryCollection)g);
        }
        if (g == null) {
            return null;
        }
        if (g instanceof Point) {
            return g.getCoordinate();
        }
        if (g instanceof LineString) {
            LineString line = (LineString)g;
            LengthIndexedLine lil = new LengthIndexedLine((Geometry)line);
            return lil.extractPoint(line.getLength() / 2.0);
        }
        return g.getCentroid().getCoordinate();
    }

    private Geometry selectRepresentativeGeometry(GeometryCollection g) {
        GeometryCollection gc = g;
        if (gc.isEmpty()) {
            return null;
        }
        Geometry first = gc.getGeometryN(0);
        if (gc.getNumGeometries() == 1 || g instanceof MultiPoint) {
            return first;
        }
        double maxAreaSoFar = first.getEnvelope().getArea();
        Geometry geometryToReturn = first;
        for (int t = 0; t < gc.getNumGeometries(); ++t) {
            Geometry curr = gc.getGeometryN(t);
            double area = curr.getEnvelope().getArea();
            if (!(area > maxAreaSoFar)) continue;
            maxAreaSoFar = area;
            geometryToReturn = curr;
        }
        return geometryToReturn;
    }
}

