/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.utils;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.kml.regionate.RegionatingStrategy;
import org.geoserver.kml.regionate.RegionatingStrategyFactory;
import org.geoserver.kml.utils.RuleFiltersCollector;
import org.geoserver.kml.utils.ScaleStyleVisitor;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.crs.ReprojectFeatureResults;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.spatial.BBOX;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class KMLFeatureAccessor {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.kml");
    private static FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);

    public SimpleFeatureCollection loadFeatureCollection(Layer layer, WMSMapContent mapContent, WMS wms, double scaleDenominator) throws Exception {
        CoordinateReferenceSystem wgs84;
        SimpleFeatureSource featureSource = (SimpleFeatureSource)layer.getFeatureSource();
        Query q = this.getFeaturesQuery(layer, mapContent, wms, scaleDenominator);
        try {
            wgs84 = CRS.decode((String)"EPSG:4326", (boolean)true);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot decode EPSG:4326, the CRS subsystem must be badly broken...", e);
        }
        SimpleFeatureCollection features = featureSource.getFeatures(q);
        SimpleFeatureType schema = (SimpleFeatureType)featureSource.getSchema();
        CoordinateReferenceSystem nativeCRS = schema.getCoordinateReferenceSystem();
        if (nativeCRS != null && !CRS.equalsIgnoreMetadata((Object)wgs84, (Object)nativeCRS)) {
            features = new ReprojectFeatureResults((FeatureCollection)features, wgs84);
        }
        return features;
    }

    public int getFeatureCount(Layer layer, WMSMapContent mapContent, WMS wms, double scaleDenominator) throws Exception {
        Query q = this.getFeaturesQuery(layer, mapContent, wms, scaleDenominator);
        SimpleFeatureSource featureSource = (SimpleFeatureSource)layer.getFeatureSource();
        int count = featureSource.getCount(q);
        if (count == -1) {
            count = featureSource.getFeatures(q).size();
        }
        return count;
    }

    private Query getFeaturesQuery(Layer layer, WMSMapContent mapContent, WMS wms, double scaleDenominator) throws TransformException, FactoryException {
        Name name;
        Catalog catalog;
        SimpleFeatureType schema = (SimpleFeatureType)((SimpleFeatureSource)layer.getFeatureSource()).getSchema();
        ReferencedEnvelope aoi = mapContent.getRenderingArea();
        Filter filter = this.createBBoxFilter(schema, aoi);
        Query q = new Query(schema.getTypeName());
        q.setFilter(filter);
        q = DataUtilities.mixQueries((Query)q, (Query)layer.getQuery(), (String)"KMLEncoder");
        RegionatingStrategy regionatingStrategy = null;
        String stratname = (String)mapContent.getRequest().getFormatOptions().get("regionateBy");
        if ("auto".equals(stratname) && ((stratname = (String)(catalog = wms.getGeoServer().getCatalog()).getFeatureTypeByName(name = layer.getFeatureSource().getName()).getMetadata().get("kml.regionateStrategy", String.class)) == null || "".equals(stratname))) {
            stratname = "best_guess";
            LOGGER.log(Level.FINE, "No default regionating strategy has been configured in " + name + "; using automatic best-guess strategy.");
        }
        IncludeFilter regionatingFilter = Filter.INCLUDE;
        if (stratname != null) {
            regionatingStrategy = this.findStrategyByName(stratname);
            if (regionatingStrategy == null) {
                throw new ServiceException("Unknown regionating strategy " + stratname);
            }
            regionatingFilter = regionatingStrategy.getFilter(mapContent, layer);
        }
        Filter ruleFilter = this.getStyleFilter(schema, layer.getStyle(), scaleDenominator);
        Filter finalFilter = this.joinFilters(new Filter[]{q.getFilter(), ruleFilter, regionatingFilter});
        if (finalFilter == Filter.EXCLUDE) {
            return null;
        }
        q.setFilter(finalFilter);
        return q;
    }

    private RegionatingStrategy findStrategyByName(String name) {
        List factories = GeoServerExtensions.extensions(RegionatingStrategyFactory.class);
        for (RegionatingStrategyFactory factory : factories) {
            if (!factory.canHandle(name)) continue;
            return factory.createStrategy();
        }
        return null;
    }

    private Filter getStyleFilter(SimpleFeatureType schema, Style style, double scaleDenominator) {
        ScaleStyleVisitor sdSimplifier = new ScaleStyleVisitor(scaleDenominator, schema);
        style.accept((StyleVisitor)sdSimplifier);
        Style simplified = sdSimplifier.getSimplifiedStyle();
        RuleFiltersCollector collector = new RuleFiltersCollector();
        simplified.accept((StyleVisitor)collector);
        return collector.getSummaryFilter();
    }

    private Filter createBBoxFilter(SimpleFeatureType schema, ReferencedEnvelope aoi) throws IllegalFilterException {
        ArrayList<ReferencedEnvelope> envelopes = new ArrayList<ReferencedEnvelope>();
        if (KmlEncodingContext.WORLD_BOUNDS_WGS84.contains((Envelope)aoi)) {
            envelopes.add(aoi);
        } else {
            ReferencedEnvelope intersection = KmlEncodingContext.WORLD_BOUNDS_WGS84.intersection((Envelope)aoi);
            if (intersection.getWidth() > 0.0) {
                envelopes.add(new ReferencedEnvelope((Envelope)intersection, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
            }
            if (aoi.getMaxX() > 180.0) {
                double maxx = aoi.getMaxX() - 360.0;
                double minx = aoi.getMinX() > 180.0 ? aoi.getMinX() - 360.0 : -180.0;
                envelopes.add(new ReferencedEnvelope(minx, maxx, aoi.getMinY(), aoi.getMaxY(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
            }
        }
        ArrayList<ReferencedEnvelope> sourceEnvelopes = new ArrayList<ReferencedEnvelope>();
        CoordinateReferenceSystem sourceCrs = schema.getCoordinateReferenceSystem();
        if (sourceCrs != null && !CRS.equalsIgnoreMetadata((Object)aoi.getCoordinateReferenceSystem(), (Object)sourceCrs)) {
            for (ReferencedEnvelope re : envelopes) {
                try {
                    ReferencedEnvelope se = re.transform(sourceCrs, true);
                    sourceEnvelopes.add(se);
                }
                catch (Exception e) {
                    return Filter.INCLUDE;
                }
            }
        } else {
            sourceEnvelopes.addAll(envelopes);
        }
        GeometryDescriptor gd = schema.getGeometryDescriptor();
        if (sourceEnvelopes.size() == 0) {
            return Filter.INCLUDE;
        }
        if (sourceEnvelopes.size() == 1) {
            ReferencedEnvelope se = (ReferencedEnvelope)sourceEnvelopes.get(0);
            return filterFactory.bbox(gd.getLocalName(), se.getMinX(), se.getMinY(), se.getMaxX(), se.getMaxY(), null);
        }
        ArrayList<BBOX> filters = new ArrayList<BBOX>();
        for (ReferencedEnvelope se : sourceEnvelopes) {
            filters.add(filterFactory.bbox(gd.getLocalName(), se.getMinX(), se.getMinY(), se.getMaxX(), se.getMaxY(), null));
        }
        return filterFactory.or(filters);
    }

    private Filter joinFilters(Filter ... filters) {
        if (filters == null || filters.length == 0) {
            return Filter.EXCLUDE;
        }
        And result = null;
        if (filters.length > 0) {
            FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
            result = ff.and(Arrays.asList(filters));
        } else if (filters.length == 1) {
            result = filters[0];
        }
        SimplifyingFilterVisitor visitor = new SimplifyingFilterVisitor();
        return (Filter)result.accept((FilterVisitor)visitor, null);
    }
}

