/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.sequence;

import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Placemark;
import java.util.List;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.kml.decorator.KmlDecoratorFactory;
import org.geoserver.kml.sequence.Sequence;
import org.geoserver.kml.sequence.SequenceFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;

public class WFSFeatureSequenceFactory
implements SequenceFactory<Feature> {
    private SimpleFeatureCollection features;
    private List<KmlDecoratorFactory.KmlDecorator> callbacks;
    private KmlEncodingContext context;

    public WFSFeatureSequenceFactory(KmlEncodingContext context) {
        this.context = context;
        this.features = context.getCurrentFeatureCollection();
        this.callbacks = context.getDecoratorsForClass(Placemark.class);
    }

    @Override
    public Sequence<Feature> newSequence() {
        return new FeatureGenerator(this.context.openIterator((FeatureCollection)this.features));
    }

    public class FeatureGenerator
    implements Sequence<Feature> {
        private FeatureIterator fi;

        public FeatureGenerator(FeatureIterator fi) {
            this.fi = fi;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Feature next() {
            if (this.fi == null) {
                return null;
            }
            if (this.fi.hasNext()) {
                boolean featureRetrieved = false;
                try {
                    SimpleFeature sf = (SimpleFeature)this.fi.next();
                    featureRetrieved = true;
                    WFSFeatureSequenceFactory.this.context.setCurrentFeature(sf);
                    Placemark pm = new Placemark();
                    pm.setId(sf.getID());
                    for (KmlDecoratorFactory.KmlDecorator callback : WFSFeatureSequenceFactory.this.callbacks) {
                        pm = (Placemark)callback.decorate((Feature)pm, WFSFeatureSequenceFactory.this.context);
                        if (pm != null) continue;
                    }
                    Placemark placemark = pm;
                    return placemark;
                }
                finally {
                    if (!featureRetrieved) {
                        WFSFeatureSequenceFactory.this.context.closeIterator(this.fi);
                    }
                }
            }
            if (!this.fi.hasNext()) {
                WFSFeatureSequenceFactory.this.context.closeIterator(this.fi);
            }
            return null;
        }
    }
}

