/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.sequence;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geoserver.kml.sequence.Sequence;
import org.geoserver.kml.sequence.SequenceFactory;

public class SequenceList<T>
extends AbstractList<T> {
    SequenceFactory<T> generatorFactory;

    public SequenceList(SequenceFactory<T> generatorFactory) {
        this.generatorFactory = generatorFactory;
    }

    @Override
    public Iterator iterator() {
        return new GeneratorIterator(this.generatorFactory.newSequence());
    }

    @Override
    public T get(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return -1;
    }

    public class GeneratorIterator
    implements Iterator<T> {
        private Sequence<T> generator;
        private T item;

        public GeneratorIterator(Sequence<T> generator) {
            this.generator = generator;
            this.item = generator.next();
        }

        @Override
        public boolean hasNext() {
            return this.item != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object next = this.item;
            this.item = this.generator.next();
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

