/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.sequence;

import com.vividsolutions.jts.geom.Envelope;
import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Folder;
import de.micromata.opengis.kml.v_2_2_0.GroundOverlay;
import de.micromata.opengis.kml.v_2_2_0.Icon;
import de.micromata.opengis.kml.v_2_2_0.LatLonBox;
import de.micromata.opengis.kml.v_2_2_0.ViewRefreshMode;
import java.io.IOException;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.kml.sequence.AbstractFolderSequenceFactory;
import org.geoserver.kml.sequence.FeatureSequenceFactory;
import org.geoserver.kml.sequence.KMLCentroidFeatureCollection;
import org.geoserver.kml.sequence.Sequence;
import org.geoserver.kml.sequence.SequenceList;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WMSRequests;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PlainFolderSequenceFactory
extends AbstractFolderSequenceFactory {
    public PlainFolderSequenceFactory(KmlEncodingContext context) {
        super(context);
    }

    @Override
    public Sequence<Feature> newSequence() {
        return new PlainFolderGenerator();
    }

    public class PlainFolderGenerator
    extends AbstractFolderSequenceFactory.AbstractFolderGenerator {
        public PlainFolderGenerator() {
            super(PlainFolderSequenceFactory.this);
        }

        @Override
        protected void encodeFolderContents(Layer layer, Folder folder) {
            if (layer instanceof FeatureLayer) {
                if (this.useVectorOutput(PlainFolderSequenceFactory.this.context)) {
                    SequenceList<Feature> features = new SequenceList<Feature>(new FeatureSequenceFactory(PlainFolderSequenceFactory.this.context, (FeatureLayer)layer));
                    PlainFolderSequenceFactory.this.context.addFeatures(folder, features);
                } else {
                    this.addGroundOverlay(folder, layer);
                    if (PlainFolderSequenceFactory.this.context.isPlacemarkForced()) {
                        this.addFeatureCentroids(layer, folder);
                    }
                }
            } else {
                this.addGroundOverlay(folder, layer);
            }
        }

        private void addFeatureCentroids(Layer layer, Folder folder) {
            try {
                SimpleFeatureSource source = (SimpleFeatureSource)((FeatureLayer)layer).getFeatureSource();
                SimpleFeatureCollection original = source.getFeatures();
                KMLCentroidFeatureCollection centroids = new KMLCentroidFeatureCollection((FeatureCollection<SimpleFeatureType, SimpleFeature>)original);
                PlainFolderSequenceFactory.this.context.setCurrentFeatureCollection((SimpleFeatureCollection)centroids);
                FeatureLayer centroidsLayer = new FeatureLayer((FeatureCollection)centroids, layer.getStyle(), layer.getTitle());
                SequenceList<Feature> features = new SequenceList<Feature>(new FeatureSequenceFactory(PlainFolderSequenceFactory.this.context, centroidsLayer));
                PlainFolderSequenceFactory.this.context.addFeatures(folder, features);
            }
            catch (IOException e) {
                throw new ServiceException("Failed to load vector data during KML generation", (Throwable)e);
            }
        }

        private void addGroundOverlay(Folder folder, Layer layer) {
            boolean reprojectBBox;
            int mapLayerOrder = PlainFolderSequenceFactory.this.context.getMapContent().layers().indexOf(layer);
            GroundOverlay go = folder.createAndAddGroundOverlay();
            go.setName(layer.getTitle());
            go.setDrawOrder(mapLayerOrder);
            Icon icon = go.createAndSetIcon();
            icon.setHref(this.getGroundOverlayHRef(layer));
            icon.setViewRefreshMode(ViewRefreshMode.NEVER);
            icon.setViewBoundScale(0.75);
            ReferencedEnvelope box = new ReferencedEnvelope(PlainFolderSequenceFactory.this.context.getMapContent().getRenderingArea());
            boolean bl = reprojectBBox = box.getCoordinateReferenceSystem() != null && !CRS.equalsIgnoreMetadata((Object)box.getCoordinateReferenceSystem(), (Object)DefaultGeographicCRS.WGS84);
            if (reprojectBBox) {
                try {
                    box = box.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
                }
                catch (Exception e) {
                    throw new ServiceException("Could not transform bbox to WGS84", (Throwable)e, "ReprojectionError", "");
                }
            }
            LatLonBox gobox = go.createAndSetLatLonBox();
            gobox.setEast(box.getMinX());
            gobox.setWest(box.getMaxX());
            gobox.setNorth(box.getMaxY());
            gobox.setSouth(box.getMinY());
        }

        String getGroundOverlayHRef(Layer layer) {
            WMSMapContent mapContent = PlainFolderSequenceFactory.this.context.getMapContent();
            if (PlainFolderSequenceFactory.this.context.isKmz()) {
                int mapLayerOrder = mapContent.layers().indexOf(layer);
                String href = "images/layers_" + mapLayerOrder + ".png";
                PlainFolderSequenceFactory.this.context.addKmzGroundOverlay(href, layer);
                return href;
            }
            return WMSRequests.getGetMapUrl((GetMapRequest)mapContent.getRequest(), (Layer)layer, (int)0, (Envelope)mapContent.getRenderingArea(), (String[])new String[]{"format", "image/png", "transparent", "true"});
        }

        boolean useVectorOutput(KmlEncodingContext context) {
            String mode = context.getMode();
            if ("refresh".equalsIgnoreCase(mode)) {
                int kmscore = context.getKmScore();
                if (kmscore == 100) {
                    return true;
                }
                if (kmscore == 0) {
                    return false;
                }
                double magic = Math.pow(10.0, kmscore / 15);
                int currentSize = context.getCurrentFeatureCollection().size();
                return !((double)currentSize > magic);
            }
            return true;
        }
    }
}

