/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.sequence;

import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Placemark;
import java.util.EmptyStackException;
import java.util.List;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.kml.decorator.KmlDecoratorFactory;
import org.geoserver.kml.sequence.Sequence;
import org.geoserver.kml.sequence.SequenceFactory;
import org.geoserver.kml.utils.ScaleStyleVisitor;
import org.geoserver.kml.utils.SymbolizerCollector;
import org.geoserver.wms.WMSMapContent;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.function.EnvFunction;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbolizer;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class FeatureSequenceFactory
implements SequenceFactory<Feature> {
    static final String OUTPUT_MODE = "kmlOutputMode";
    static final String VECTOR_MODE = "vector";
    private SimpleFeatureCollection features;
    private List<KmlDecoratorFactory.KmlDecorator> callbacks;
    private Style simplified;
    private KmlEncodingContext context;

    public FeatureSequenceFactory(KmlEncodingContext context, FeatureLayer layer) {
        this.context = context;
        this.features = context.getCurrentFeatureCollection();
        WMSMapContent mapContent = context.getMapContent();
        context.setCurrentLayer((Layer)layer);
        this.callbacks = context.getDecoratorsForClass(Placemark.class);
        this.simplified = this.getSimplifiedStyle(mapContent, (Layer)layer);
    }

    private Style getSimplifiedStyle(WMSMapContent mc, Layer layer) {
        ScaleStyleVisitor visitor = new ScaleStyleVisitor(mc.getScaleDenominator(), (SimpleFeatureType)layer.getFeatureSource().getSchema());
        try {
            layer.getStyle().accept((StyleVisitor)visitor);
            return visitor.getCopy();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    @Override
    public Sequence<Feature> newSequence() {
        return new FeatureGenerator(this.simplified != null ? this.context.openIterator((FeatureCollection)this.features) : null);
    }

    public class FeatureGenerator
    implements Sequence<Feature> {
        private FeatureIterator fi;

        public FeatureGenerator(FeatureIterator fi) {
            if (fi != null) {
                EnvFunction.setLocalValue((String)FeatureSequenceFactory.OUTPUT_MODE, (Object)FeatureSequenceFactory.VECTOR_MODE);
                this.fi = fi;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Feature next() {
            if (this.fi == null) {
                return null;
            }
            while (this.fi.hasNext()) {
                boolean featureRetrieved = false;
                try {
                    SimpleFeature sf = (SimpleFeature)this.fi.next();
                    featureRetrieved = true;
                    FeatureSequenceFactory.this.context.setCurrentFeature(sf);
                    List<Symbolizer> symbolizers = this.getSymbolizers(FeatureSequenceFactory.this.simplified, sf);
                    if (symbolizers.size() == 0) continue;
                    FeatureSequenceFactory.this.context.setCurrentSymbolizers(symbolizers);
                    Placemark pm = new Placemark();
                    pm.setId(sf.getID());
                    for (KmlDecoratorFactory.KmlDecorator callback : FeatureSequenceFactory.this.callbacks) {
                        pm = (Placemark)callback.decorate((Feature)pm, FeatureSequenceFactory.this.context);
                        if (pm != null) continue;
                    }
                    Placemark placemark = pm;
                    return placemark;
                }
                finally {
                    if (featureRetrieved) continue;
                    FeatureSequenceFactory.this.context.closeIterator(this.fi);
                    EnvFunction.setLocalValue((String)FeatureSequenceFactory.OUTPUT_MODE, null);
                }
            }
            if (!this.fi.hasNext()) {
                EnvFunction.setLocalValue((String)FeatureSequenceFactory.OUTPUT_MODE, null);
                FeatureSequenceFactory.this.context.closeIterator(this.fi);
            }
            return null;
        }

        private List<Symbolizer> getSymbolizers(Style style, SimpleFeature sf) {
            SymbolizerCollector collector = new SymbolizerCollector(sf);
            style.accept((StyleVisitor)collector);
            return collector.getSymbolizers();
        }
    }
}

