/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.sequence;

import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Folder;
import java.util.List;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.kml.decorator.KmlDecoratorFactory;
import org.geoserver.kml.sequence.Sequence;
import org.geoserver.kml.sequence.SequenceFactory;
import org.geoserver.kml.utils.KMLFeatureAccessor;
import org.geoserver.ows.HttpErrorCodeException;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.WMSMapContent;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;

public abstract class AbstractFolderSequenceFactory
implements SequenceFactory<Feature> {
    protected KmlEncodingContext context;
    protected List<KmlDecoratorFactory.KmlDecorator> decorators;

    public AbstractFolderSequenceFactory(KmlEncodingContext context) {
        this.context = context;
        this.decorators = context.getDecoratorsForClass(Folder.class);
    }

    public abstract class AbstractFolderGenerator
    implements Sequence<Feature> {
        protected int i = 0;
        protected int size;

        public AbstractFolderGenerator() {
            this.size = AbstractFolderSequenceFactory.this.context.getMapContent().layers().size();
        }

        @Override
        public Feature next() {
            if (this.i < this.size) {
                List layers = AbstractFolderSequenceFactory.this.context.getMapContent().layers();
                Layer layer = (Layer)layers.get(this.i++);
                AbstractFolderSequenceFactory.this.context.setCurrentLayer(layer);
                Folder folder = new Folder();
                folder.setName(layer.getTitle());
                if (layer instanceof FeatureLayer) {
                    try {
                        WMSMapContent mapContent = AbstractFolderSequenceFactory.this.context.getMapContent();
                        SimpleFeatureCollection fc = new KMLFeatureAccessor().loadFeatureCollection(layer, mapContent, AbstractFolderSequenceFactory.this.context.getWms(), mapContent.getScaleDenominator());
                        AbstractFolderSequenceFactory.this.context.setCurrentFeatureCollection(fc);
                    }
                    catch (Exception e) {
                        if (e instanceof ServiceException) {
                            throw (ServiceException)((Object)e);
                        }
                        if (e instanceof HttpErrorCodeException) {
                            throw (HttpErrorCodeException)((Object)e);
                        }
                        throw new ServiceException("Failed to load vector data during KML generation", (Throwable)e);
                    }
                }
                for (KmlDecoratorFactory.KmlDecorator decorator : AbstractFolderSequenceFactory.this.decorators) {
                    folder = (Folder)decorator.decorate((Feature)folder, AbstractFolderSequenceFactory.this.context);
                    if (folder != null) continue;
                }
                this.encodeFolderContents(layer, folder);
                return folder;
            }
            return null;
        }

        protected abstract void encodeFolderContents(Layer var1, Folder var2);
    }
}

