/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.regionate;

import com.vividsolutions.jts.geom.Envelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.CanonicalSet;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class Tile {
    public static final CoordinateReferenceSystem WGS84;
    public static final ReferencedEnvelope WORLD_BOUNDS;
    static final double MAX_TILE_WIDTH;
    static CanonicalSet<String> canonicalizer;
    protected long x;
    protected long y;
    protected long z;
    protected ReferencedEnvelope envelope;

    public Tile(long x, long y, long z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.envelope = this.envelope(x, y, z);
    }

    public boolean contains(double x, double y) {
        double minx = this.envelope.getMinX();
        double maxx = this.envelope.getMaxX();
        double miny = this.envelope.getMinY();
        double maxy = this.envelope.getMaxY();
        return x >= minx && x < maxx && y >= miny && y < maxy;
    }

    private ReferencedEnvelope envelope(long x, long y, long z) {
        double tileSize = MAX_TILE_WIDTH / Math.pow(2.0, z);
        double xMin = (double)x * tileSize + WORLD_BOUNDS.getMinX();
        double yMin = (double)y * tileSize + WORLD_BOUNDS.getMinY();
        return new ReferencedEnvelope(xMin, xMin + tileSize, yMin, yMin + tileSize, WGS84);
    }

    public Tile(ReferencedEnvelope wgs84Envelope) {
        this.z = Math.round(Math.log(MAX_TILE_WIDTH / wgs84Envelope.getWidth()) / Math.log(2.0));
        this.x = Math.round((wgs84Envelope.getMinimum(0) - WORLD_BOUNDS.getMinimum(0)) / MAX_TILE_WIDTH * Math.pow(2.0, this.z));
        this.y = Math.round((wgs84Envelope.getMinimum(1) - WORLD_BOUNDS.getMinimum(1)) / MAX_TILE_WIDTH * Math.pow(2.0, this.z));
        this.envelope = this.envelope(this.x, this.y, this.z);
    }

    public Tile getParent() {
        if (this.z == 0L) {
            return null;
        }
        return new Tile((long)Math.floor((double)this.x / 2.0), (long)Math.floor((double)this.y / 2.0), this.z - 1L);
    }

    public Tile[] getChildren() {
        Tile[] result = new Tile[]{new Tile(this.x * 2L, this.y * 2L, this.z + 1L), new Tile(this.x * 2L + 1L, this.y * 2L, this.z + 1L), new Tile(this.x * 2L, this.y * 2L + 1L, this.z + 1L), new Tile(this.x * 2L + 1L, this.y * 2L + 1L, this.z + 1L)};
        return result;
    }

    public ReferencedEnvelope getEnvelope() {
        return this.envelope;
    }

    public String toString() {
        return "Tile X: " + this.x + ", Y: " + this.y + ", Z: " + this.z + " (" + this.envelope + ")";
    }

    public long getX() {
        return this.x;
    }

    public long getY() {
        return this.y;
    }

    public long getZ() {
        return this.z;
    }

    static {
        canonicalizer = CanonicalSet.newInstance(String.class);
        try {
            WGS84 = CRS.decode((String)"EPSG:4326");
            WORLD_BOUNDS = new ReferencedEnvelope(new Envelope(180.0, -180.0, 90.0, -90.0), WGS84);
            MAX_TILE_WIDTH = WORLD_BOUNDS.getWidth() / 2.0;
            Class.forName("org.h2.Driver");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize the class constants", e);
        }
    }
}

