/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.regionate;

import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.config.GeoServer;
import org.geoserver.kml.regionate.RegionatingStrategy;
import org.geoserver.kml.regionate.RegionatingStrategyFactory;
import org.geoserver.platform.ServiceException;
import org.geotools.util.logging.Logging;

public class ReflectiveRegionatingStrategyFactory
implements RegionatingStrategyFactory {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.geosearch");
    String myName;
    String myClassName;
    Class myStrategyClass;
    GeoServer gs;

    public ReflectiveRegionatingStrategyFactory(String name, String className, GeoServer gs) {
        this.myName = name;
        this.myClassName = className;
        this.gs = gs;
    }

    public ReflectiveRegionatingStrategyFactory(String name, Class strategy, GeoServer gs) {
        this.myName = name;
        this.myStrategyClass = strategy;
        this.gs = gs;
    }

    @Override
    public boolean canHandle(String strategyName) {
        return this.myName != null && this.myName.equalsIgnoreCase(strategyName);
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public RegionatingStrategy createStrategy() {
        try {
            Class clazz = this.getStrategyClass();
            Constructor c = clazz.getConstructor(GeoServer.class);
            if (c != null) {
                return (RegionatingStrategy)c.newInstance(this.gs);
            }
            return (RegionatingStrategy)clazz.newInstance();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    protected Class getStrategyClass() {
        if (this.myStrategyClass != null) {
            return this.myStrategyClass;
        }
        try {
            this.myStrategyClass = Class.forName(this.myClassName);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to find class " + this.myClassName + " for ReflectiveRegionatingStrategy.", e);
        }
        return this.myStrategyClass;
    }
}

