/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.icons;

import java.util.ArrayList;
import java.util.List;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.opengis.filter.Filter;

class MiniRule {
    public final Filter filter;
    public final boolean isElseFilter;
    public final List<PointSymbolizer> symbolizers;

    public MiniRule(Filter filter, boolean isElseFilter, List<PointSymbolizer> symbolizers) {
        this.filter = filter;
        this.isElseFilter = isElseFilter;
        this.symbolizers = symbolizers;
    }

    static List<List<MiniRule>> minify(Style style) {
        ArrayList<List<MiniRule>> ftStyles = new ArrayList<List<MiniRule>>();
        for (FeatureTypeStyle ftStyle : style.featureTypeStyles()) {
            ArrayList<MiniRule> rules = new ArrayList<MiniRule>();
            for (Rule rule : ftStyle.rules()) {
                ArrayList<PointSymbolizer> pointSymbolizers = new ArrayList<PointSymbolizer>();
                for (Symbolizer symbolizer : rule.symbolizers()) {
                    if (!(symbolizer instanceof PointSymbolizer)) continue;
                    pointSymbolizers.add((PointSymbolizer)symbolizer);
                }
                if (pointSymbolizers.isEmpty()) continue;
                rules.add(new MiniRule(rule.getFilter(), rule.isElseFilter(), pointSymbolizers));
            }
            if (rules.isEmpty()) continue;
            ftStyles.add(rules);
        }
        return ftStyles;
    }

    static Style makeStyle(StyleFactory factory, List<List<MiniRule>> ftStyles) {
        Style style = factory.createStyle();
        for (List<MiniRule> rules : ftStyles) {
            FeatureTypeStyle ftStyle = factory.createFeatureTypeStyle();
            for (MiniRule miniRule : rules) {
                if (miniRule.symbolizers.isEmpty()) continue;
                Rule realRule = factory.createRule();
                for (Symbolizer symbolizer : miniRule.symbolizers) {
                    realRule.symbolizers().add(symbolizer);
                }
                ftStyle.rules().add(realRule);
            }
            style.featureTypeStyles().add(ftStyle);
        }
        return style;
    }
}

