/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.icons;

import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.geoserver.kml.icons.IconProperties;
import org.geoserver.kml.icons.Icons;
import org.geoserver.kml.icons.MiniRule;
import org.geotools.filter.visitor.IsStaticExpressionVisitor;
import org.geotools.renderer.style.ExpressionExtractor;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.style.GraphicalSymbol;

public final class IconPropertyExtractor {
    private List<List<MiniRule>> style;

    private IconPropertyExtractor(List<List<MiniRule>> style) {
        this.style = style;
    }

    private IconProperties propertiesFor(SimpleFeature feature) {
        return new FeatureProperties(feature).properties();
    }

    public static IconProperties extractProperties(Style style, SimpleFeature feature) {
        return new IconPropertyExtractor(MiniRule.minify(style)).propertiesFor(feature);
    }

    private class FeatureProperties {
        private static final String URL = ".url";
        private static final String WIDTH = ".width";
        private static final String LINEJOIN = ".linejoin";
        private static final String LINECAP = ".linecap";
        private static final String DASHOFFSET = ".dashoffset";
        private static final String GRAPHIC = ".graphic";
        private static final String COLOR = ".color";
        private static final String STROKE = ".stroke";
        private static final String FILL = ".fill";
        private static final String NAME = ".name";
        private static final String SIZE = ".size";
        private static final String ROTATION = ".rotation";
        private static final String OPACITY = ".opacity";
        private final SimpleFeature feature;

        public FeatureProperties(SimpleFeature feature) {
            this.feature = feature;
        }

        public IconProperties properties() {
            IconProperties singleExternalGraphic = this.trySingleExternalGraphic();
            if (singleExternalGraphic != null) {
                return singleExternalGraphic;
            }
            return this.embeddedIconProperties();
        }

        public IconProperties trySingleExternalGraphic() {
            MiniRule singleRule = null;
            for (List rules : IconPropertyExtractor.this.style) {
                boolean applied = false;
                for (MiniRule rule : rules) {
                    boolean applicable = rule.isElseFilter && !applied || rule.filter == null || rule.filter.evaluate((Object)this.feature);
                    if (!applicable) continue;
                    if (singleRule == null) {
                        singleRule = rule;
                        continue;
                    }
                    return null;
                }
            }
            if (singleRule == null) {
                return null;
            }
            return this.isExternalGraphic(singleRule);
        }

        public IconProperties isExternalGraphic(MiniRule rule) {
            if (rule.symbolizers.size() != 1) {
                return null;
            }
            Graphic g = rule.symbolizers.get(0).getGraphic();
            if (g == null) {
                return null;
            }
            if (g.graphicalSymbols().size() != 1) {
                return null;
            }
            GraphicalSymbol gSym = (GraphicalSymbol)g.graphicalSymbols().get(0);
            if (!(gSym instanceof ExternalGraphic)) {
                return null;
            }
            ExternalGraphic exGraphic = (ExternalGraphic)gSym;
            try {
                Double opacity = (Double)g.getOpacity().evaluate((Object)this.feature, Double.class);
                Double size = 1.0 * (double)Icons.getExternalSize(exGraphic, (Feature)this.feature).intValue();
                if (size != null) {
                    size = size / 16.0;
                }
                Double rotation = (Double)g.getRotation().evaluate((Object)this.feature, Double.class);
                Expression urlExpression = ExpressionExtractor.extractCqlExpressions((String)exGraphic.getLocation().toExternalForm());
                return IconProperties.externalReference(opacity, size, rotation, (String)urlExpression.evaluate((Object)this.feature, String.class));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        public IconProperties embeddedIconProperties() {
            TreeMap<String, String> props = new TreeMap<String, String>();
            Double size = null;
            boolean allRotated = true;
            for (int i = 0; i < IconPropertyExtractor.this.style.size(); ++i) {
                List rules = (List)IconPropertyExtractor.this.style.get(i);
                for (int j = 0; j < rules.size(); ++j) {
                    MiniRule rule = (MiniRule)rules.get(j);
                    boolean matches = rule.filter == null ? !rule.isElseFilter || props.isEmpty() : rule.filter.evaluate((Object)this.feature);
                    if (!matches) continue;
                    for (int k = 0; k < rule.symbolizers.size(); ++k) {
                        props.put(i + "." + j + "." + k, "");
                        PointSymbolizer sym = rule.symbolizers.get(k);
                        if (sym.getGraphic() == null) continue;
                        this.addGraphicProperties(i + "." + j + "." + k, sym.getGraphic(), props);
                        Double gRotation = this.graphicRotation(sym.getGraphic());
                        allRotated &= gRotation != null;
                        Double gSize = Icons.graphicSize((org.opengis.style.Graphic)sym.getGraphic(), gRotation, (Feature)this.feature);
                        if (size != null && (gSize == null || !(gSize > size))) continue;
                        size = gSize;
                    }
                }
            }
            if (size != null) {
                size = size / 16.0;
            }
            Double rotation = allRotated ? Double.valueOf(0.0) : null;
            return IconProperties.generator(null, size, rotation, props);
        }

        public boolean isStatic(Expression ex) {
            return (Boolean)ex.accept((ExpressionVisitor)IsStaticExpressionVisitor.VISITOR, null);
        }

        private Double graphicRotation(Graphic g) {
            if (g.getRotation() != null) {
                return (Double)g.getRotation().evaluate((Object)this.feature, Double.class);
            }
            return null;
        }

        public void addGraphicProperties(String prefix, Graphic g, Map<String, String> props) {
            if (g.getOpacity() != null && !this.isStatic(g.getOpacity())) {
                props.put(prefix + OPACITY, (String)g.getOpacity().evaluate((Object)this.feature, String.class));
            }
            if (g.getRotation() != null && !this.isStatic(g.getRotation())) {
                props.put(prefix + ROTATION, (String)g.getRotation().evaluate((Object)this.feature, String.class));
            }
            if (g.getSize() != null && !this.isStatic(g.getSize())) {
                props.put(prefix + SIZE, (String)g.getSize().evaluate((Object)this.feature, String.class));
            }
            if (!g.graphicalSymbols().isEmpty()) {
                if (g.graphicalSymbols().get(0) instanceof Mark) {
                    Mark mark = (Mark)g.graphicalSymbols().get(0);
                    this.addMarkProperties(prefix, mark, props);
                } else if (g.graphicalSymbols().get(0) instanceof ExternalGraphic) {
                    ExternalGraphic exGraphic = (ExternalGraphic)g.graphicalSymbols().get(0);
                    this.addExternalGraphicProperties(prefix, exGraphic, props);
                }
            }
        }

        public void addMarkProperties(String prefix, Mark mark, Map<String, String> props) {
            if (mark.getWellKnownName() != null && !this.isStatic(mark.getWellKnownName())) {
                props.put(prefix + NAME, (String)mark.getWellKnownName().evaluate((Object)this.feature, String.class));
            }
            if (mark.getFill() != null) {
                this.addFillProperties(prefix + FILL, mark.getFill(), props);
            }
            if (mark.getStroke() != null) {
                this.addStrokeProperties(prefix + STROKE, mark.getStroke(), props);
            }
        }

        public void addFillProperties(String prefix, Fill fill, Map<String, String> props) {
            if (fill.getColor() != null && !this.isStatic(fill.getColor())) {
                props.put(prefix + COLOR, (String)fill.getColor().evaluate((Object)this.feature, String.class));
            }
            if (fill.getOpacity() != null && !this.isStatic(fill.getOpacity())) {
                props.put(prefix + OPACITY, (String)fill.getOpacity().evaluate((Object)this.feature, String.class));
            }
            if (fill.getGraphicFill() != null) {
                this.addGraphicProperties(prefix + GRAPHIC, fill.getGraphicFill(), props);
            }
        }

        public void addStrokeProperties(String prefix, Stroke stroke, Map<String, String> props) {
            if (stroke.getColor() != null && !this.isStatic(stroke.getColor())) {
                props.put(prefix + COLOR, (String)stroke.getColor().evaluate((Object)this.feature, String.class));
            }
            if (stroke.getDashOffset() != null && !this.isStatic(stroke.getDashOffset())) {
                props.put(prefix + DASHOFFSET, (String)stroke.getDashOffset().evaluate((Object)this.feature, String.class));
            }
            if (stroke.getLineCap() != null && !this.isStatic(stroke.getLineCap())) {
                props.put(prefix + LINECAP, (String)stroke.getLineCap().evaluate((Object)this.feature, String.class));
            }
            if (stroke.getLineJoin() != null && !this.isStatic(stroke.getLineJoin())) {
                props.put(prefix + LINEJOIN, (String)stroke.getLineJoin().evaluate((Object)this.feature, String.class));
            }
            if (stroke.getOpacity() != null && !this.isStatic(stroke.getOpacity())) {
                props.put(prefix + OPACITY, (String)stroke.getOpacity().evaluate((Object)this.feature, String.class));
            }
            if (stroke.getWidth() != null && !this.isStatic(stroke.getWidth())) {
                props.put(prefix + WIDTH, (String)stroke.getWidth().evaluate((Object)this.feature, String.class));
            }
            if (stroke.getGraphicStroke() != null) {
                this.addGraphicProperties(prefix + GRAPHIC, stroke.getGraphicStroke(), props);
            }
            if (stroke.getGraphicFill() != null) {
                this.addGraphicProperties(prefix + GRAPHIC, stroke.getGraphicFill(), props);
            }
        }

        public void addExternalGraphicProperties(String prefix, ExternalGraphic exGraphic, Map<String, String> props) {
            try {
                Expression ex = ExpressionExtractor.extractCqlExpressions((String)exGraphic.getLocation().toExternalForm());
                if (!this.isStatic(ex)) {
                    props.put(prefix + URL, (String)ex.evaluate((Object)this.feature, String.class));
                }
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
    }
}

