/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.decorator;

import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Placemark;
import de.micromata.opengis.kml.v_2_2_0.TimeSpan;
import de.micromata.opengis.kml.v_2_2_0.TimeStamp;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.kml.decorator.KmlDecoratorFactory;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.featureinfo.FeatureTemplate;
import org.geotools.feature.type.DateUtil;
import org.geotools.util.logging.Logging;
import org.geotools.xs.bindings.XSDateTimeBinding;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class PlacemarkTimeDecoratorFactory
implements KmlDecoratorFactory {
    static final Logger LOGGER = Logging.getLogger(PlacemarkTimeDecorator.class);
    List<DateFormat> dtformats = new ArrayList<DateFormat>();
    List<DateFormat> dformats = new ArrayList<DateFormat>();
    List<DateFormat> tformats = new ArrayList<DateFormat>();

    public PlacemarkTimeDecoratorFactory() {
        this.dtformats.add(DateFormat.getDateTimeInstance());
        this.dtformats.add(new SimpleDateFormat(FeatureTemplate.DATETIME_FORMAT_PATTERN));
        this.addFormats(this.dtformats, "dd%MM%yy hh:mm:ss");
        this.addFormats(this.dtformats, "MM%dd%yy hh:mm:ss");
        this.addFormats(this.dtformats, "dd%MMM%yy hh:mm:ss");
        this.addFormats(this.dtformats, "MMM%dd%yy hh:mm:ss");
        this.addFormats(this.dtformats, "dd%MM%yy hh:mm");
        this.addFormats(this.dtformats, "MM%dd%yy hh:mm");
        this.addFormats(this.dtformats, "dd%MMM%yy hh:mm");
        this.addFormats(this.dtformats, "MMM%dd%yy hh:mm");
        this.dformats.add(DateFormat.getDateInstance());
        this.dformats.add(new SimpleDateFormat(FeatureTemplate.DATE_FORMAT_PATTERN));
        this.addFormats(this.dformats, "dd%MM%yy");
        this.addFormats(this.dformats, "MM%dd%yy");
        this.addFormats(this.dformats, "dd%MMM%yy");
        this.addFormats(this.dformats, "MMM%dd%yy");
        this.tformats.add(DateFormat.getTimeInstance());
        this.tformats.add(new SimpleDateFormat(FeatureTemplate.TIME_FORMAT_PATTERN));
    }

    void addFormats(List<DateFormat> formats, String pattern) {
        formats.add(new SimpleDateFormat(pattern.replaceAll("%", "-")));
        formats.add(new SimpleDateFormat(pattern.replaceAll("%", "/")));
        formats.add(new SimpleDateFormat(pattern.replaceAll("%", ".")));
        formats.add(new SimpleDateFormat(pattern.replaceAll("%", " ")));
        formats.add(new SimpleDateFormat(pattern.replaceAll("%", ",")));
    }

    @Override
    public KmlDecoratorFactory.KmlDecorator getDecorator(Class<? extends Feature> featureClass, KmlEncodingContext context) {
        if (!(context.getService() instanceof WMSInfo)) {
            return null;
        }
        if (Placemark.class.isAssignableFrom(featureClass) && this.hasTimeTemplate(context)) {
            return new PlacemarkTimeDecorator();
        }
        return null;
    }

    private boolean hasTimeTemplate(KmlEncodingContext context) {
        try {
            SimpleFeatureType schema = (SimpleFeatureType)context.getCurrentFeatureCollection().getSchema();
            return !context.getTemplate().isTemplateEmpty(schema, "time.ftl", FeatureTemplate.class, null);
        }
        catch (IOException e) {
            throw new ServiceException("Failed to apply time template during kml generation", (Throwable)e);
        }
    }

    class PlacemarkTimeDecorator
    implements KmlDecoratorFactory.KmlDecorator {
        PlacemarkTimeDecorator() {
        }

        @Override
        public Feature decorate(Feature feature, KmlEncodingContext context) {
            Placemark pm = (Placemark)feature;
            SimpleFeature sf = context.getCurrentFeature();
            try {
                String[] times = this.execute(context.getTemplate(), sf);
                if (times != null && times.length > 0) {
                    if (times.length == 1) {
                        TimeStamp stamp = pm.createAndSetTimeStamp();
                        stamp.setWhen(times[0]);
                    } else {
                        TimeSpan span = pm.createAndSetTimeSpan();
                        span.setBegin(times[0]);
                        span.setEnd(times[1]);
                    }
                }
            }
            catch (IOException e) {
                throw new ServiceException("Failed to apply KML time template to the current feature", (Throwable)e);
            }
            return pm;
        }

        public String[] execute(FeatureTemplate delegate, SimpleFeature feature) throws IOException {
            String output = delegate.template(feature, "time.ftl", FeatureTemplate.class);
            if (output != null) {
                output = output.trim();
            }
            if (output == null || "".equals(output)) {
                return new String[0];
            }
            String[] timespan = output.split("\\|\\|");
            if (output.endsWith("||")) {
                timespan = new String[]{timespan[0], null};
            }
            if (timespan.length > 2) {
                String msg = "Incorrect time syntax. Should be: <date>||<date>";
                throw new IllegalArgumentException(msg);
            }
            if (timespan.length > 1) {
                if (timespan[0] == null || "".equals(timespan[0].trim())) {
                    timespan[0] = null;
                }
                if (timespan[1] == null || "".equals(timespan[1].trim())) {
                    timespan[1] = null;
                }
            }
            for (int i = 0; i < timespan.length; ++i) {
                if (timespan[i] == null) continue;
                Date d = this.parseDateTime(timespan[i]);
                timespan[i] = this.encodeDateTime(d);
            }
            return timespan;
        }

        protected String encodeDateTime(Date date) {
            if (date != null) {
                Calendar c = Calendar.getInstance();
                c.setTime(date);
                return new XSDateTimeBinding().encode((Object)c, null);
            }
            return null;
        }

        protected Date parseDateTime(String date) {
            Date d = this.parseDate(PlacemarkTimeDecoratorFactory.this.dtformats, date);
            if (d == null) {
                d = this.parseDate(PlacemarkTimeDecoratorFactory.this.dformats, date);
            }
            if (d == null) {
                d = this.parseDate(PlacemarkTimeDecoratorFactory.this.tformats, date);
            }
            if (d == null) {
                try {
                    d = DateUtil.deserializeDateTime((String)date);
                }
                catch (Exception e1) {
                    try {
                        d = DateUtil.deserializeDate((String)date);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
            }
            if (d != null) {
                return d;
            }
            LOGGER.warning("Could not parse date: " + date);
            return null;
        }

        protected Date parseDate(List formats, String date) {
            for (SimpleDateFormat format : formats) {
                Date d = null;
                try {
                    d = format.parse(date);
                }
                catch (ParseException e) {
                    // empty catch block
                }
                if (d == null) continue;
                return d;
            }
            return null;
        }
    }
}

