/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.decorator;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Icon;
import de.micromata.opengis.kml.v_2_2_0.IconStyle;
import de.micromata.opengis.kml.v_2_2_0.LabelStyle;
import de.micromata.opengis.kml.v_2_2_0.LineStyle;
import de.micromata.opengis.kml.v_2_2_0.Placemark;
import de.micromata.opengis.kml.v_2_2_0.PolyStyle;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.kml.decorator.KmlDecoratorFactory;
import org.geoserver.kml.icons.IconProperties;
import org.geoserver.kml.icons.IconPropertyExtractor;
import org.geoserver.kml.icons.IconPropertyInjector;
import org.geoserver.wms.WMSInfo;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.renderer.style.ExpressionExtractor;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.style.GraphicalSymbol;

public class PlacemarkStyleDecoratorFactory
implements KmlDecoratorFactory {
    @Override
    public KmlDecoratorFactory.KmlDecorator getDecorator(Class<? extends Feature> featureClass, KmlEncodingContext context) {
        if (!(context.getService() instanceof WMSInfo)) {
            return null;
        }
        if (Placemark.class.isAssignableFrom(featureClass)) {
            return new PlacemarkStyleDecorator();
        }
        return null;
    }

    static class PlacemarkStyleDecorator
    implements KmlDecoratorFactory.KmlDecorator {
        static final Logger LOGGER = Logging.getLogger(PlacemarkStyleDecorator.class);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();

        PlacemarkStyleDecorator() {
        }

        @Override
        public Feature decorate(Feature feature, KmlEncodingContext context) {
            Placemark pm = (Placemark)feature;
            de.micromata.opengis.kml.v_2_2_0.Style style = pm.createAndAddStyle();
            List<Symbolizer> symbolizers = context.getCurrentSymbolizers();
            SimpleFeature sf = context.getCurrentFeature();
            if (symbolizers.size() > 0 && sf.getDefaultGeometry() != null) {
                List<Symbolizer> lines;
                List<Symbolizer> texts;
                Map<Class, List<Symbolizer>> classified = this.classifySymbolizers(symbolizers);
                List<Symbolizer> points = classified.get(PointSymbolizer.class);
                if (points.size() == 0) {
                    if (context.isDescriptionEnabled()) {
                        this.setDefaultIconStyle(style, sf, context);
                    }
                } else {
                    Style wholeStyle = context.getCurrentLayer().getStyle();
                    IconProperties properties = IconPropertyExtractor.extractProperties(wholeStyle, sf);
                    this.setIconStyle(style, wholeStyle, properties, context);
                }
                if ((texts = classified.get(TextSymbolizer.class)).size() == 0) {
                    if (context.isDescriptionEnabled()) {
                        this.setDefaultLabelStyle(style);
                    }
                } else {
                    TextSymbolizer lastTextSymbolizer = (TextSymbolizer)texts.get(texts.size() - 1);
                    this.setLabelStyle(style, sf, lastTextSymbolizer);
                }
                if ((lines = classified.get(LineSymbolizer.class)).size() > 0) {
                    LineSymbolizer lastLineSymbolizer = (LineSymbolizer)lines.get(lines.size() - 1);
                    this.setLineStyle(style, sf, lastLineSymbolizer.getStroke());
                }
                boolean forceOutiline = lines.size() == 0;
                List<Symbolizer> polygons = classified.get(PolygonSymbolizer.class);
                if (polygons.size() > 0) {
                    PolygonSymbolizer lastPolygonSymbolizer = (PolygonSymbolizer)polygons.get(polygons.size() - 1);
                    this.setPolygonStyle(style, sf, lastPolygonSymbolizer, forceOutiline);
                }
            }
            return feature;
        }

        private Map<Class, List<Symbolizer>> classifySymbolizers(List<Symbolizer> symbolizers) {
            HashMap<Class, List<Symbolizer>> result = new HashMap<Class, List<Symbolizer>>();
            result.put(PointSymbolizer.class, new ArrayList());
            result.put(LineSymbolizer.class, new ArrayList());
            result.put(PolygonSymbolizer.class, new ArrayList());
            result.put(TextSymbolizer.class, new ArrayList());
            for (Symbolizer s : symbolizers) {
                if (s instanceof PointSymbolizer) {
                    ((List)result.get(PointSymbolizer.class)).add(s);
                    continue;
                }
                if (s instanceof LineSymbolizer) {
                    ((List)result.get(LineSymbolizer.class)).add(s);
                    continue;
                }
                if (s instanceof PolygonSymbolizer) {
                    ((List)result.get(PolygonSymbolizer.class)).add(s);
                    continue;
                }
                if (s instanceof TextSymbolizer) {
                    ((List)result.get(TextSymbolizer.class)).add(s);
                    continue;
                }
                throw new IllegalArgumentException("Unrecognized symbolizer type: " + s);
            }
            return result;
        }

        protected void setDefaultIconStyle(de.micromata.opengis.kml.v_2_2_0.Style style, SimpleFeature feature, KmlEncodingContext context) {
            boolean poly;
            boolean line = feature.getDefaultGeometry() != null && (feature.getDefaultGeometry() instanceof LineString || feature.getDefaultGeometry() instanceof MultiLineString);
            boolean bl = poly = feature.getDefaultGeometry() != null && (feature.getDefaultGeometry() instanceof Polygon || feature.getDefaultGeometry() instanceof MultiPolygon);
            if (!line && !poly) {
                LOGGER.log(Level.FINER, "Unexpectedly entered encodeDefaultIconStyle() with something that does not have a multipoint geometry.");
                return;
            }
            IconStyle is = style.createAndSetIconStyle();
            if (context.isDescriptionEnabled()) {
                is.setColor("00ffffff");
            }
            if (line || poly) {
                is.setScale(0.4);
            }
            String imageURL = "http://icons.opengeo.org/markers/icon-" + (poly ? "poly.1" : "line.1") + ".png";
            Icon icon = is.createAndSetIcon();
            icon.setHref(imageURL);
            icon.setViewBoundScale(1.0);
        }

        protected void setIconStyle(de.micromata.opengis.kml.v_2_2_0.Style style, Style sld, IconProperties properties, KmlEncodingContext context) {
            if (context.isLiveIcons() || properties.isExternal()) {
                this.setLiveIconStyle(style, sld, properties, context);
            } else {
                this.setInlineIconStyle(style, sld, properties, context);
            }
        }

        protected void setInlineIconStyle(de.micromata.opengis.kml.v_2_2_0.Style style, Style sld, IconProperties properties, KmlEncodingContext context) {
            String name = properties.getIconName(sld);
            Map<String, Style> iconStyles = context.getIconStyles();
            if (!iconStyles.containsKey(name)) {
                Style injectedStyle = IconPropertyInjector.injectProperties(sld, properties.getProperties());
                iconStyles.put(name, injectedStyle);
            }
            Double scale = properties.getScale();
            String path = "icons/" + name + ".png";
            IconStyle is = style.createAndSetIconStyle();
            if (properties.getHeading() != null) {
                is.setHeading(0.0);
            }
            if (scale != null) {
                is.setScale(scale.doubleValue());
            }
            Icon icon = is.createAndSetIcon();
            icon.setHref(path);
        }

        protected void setLiveIconStyle(de.micromata.opengis.kml.v_2_2_0.Style style, Style sld, IconProperties properties, KmlEncodingContext context) {
            Double opacity = properties.getOpacity();
            Double scale = properties.getScale();
            Double heading = properties.getHeading();
            IconStyle is = style.createAndSetIconStyle();
            if (opacity != null) {
                is.setColor(this.colorToHex(Color.WHITE, opacity));
            }
            if (scale != null) {
                is.setScale(scale.doubleValue());
            }
            if (heading != null) {
                is.setHeading(heading.doubleValue());
            }
            WorkspaceInfo ws = context.getWms().getCatalog().getStyleByName(sld.getName()).getWorkspace();
            String wsName = null;
            if (ws != null) {
                wsName = ws.getName();
            }
            Icon icon = is.createAndSetIcon();
            icon.setHref(properties.href(context.getMapContent().getRequest().getBaseUrl(), wsName, sld.getName()));
        }

        protected void setDefaultLabelStyle(de.micromata.opengis.kml.v_2_2_0.Style style) {
            LabelStyle ls = style.createAndSetLabelStyle();
            ls.setColor("00ffffff");
        }

        protected void setLabelStyle(de.micromata.opengis.kml.v_2_2_0.Style style, SimpleFeature feature, TextSymbolizer symbolizer) {
            LabelStyle ls = style.createAndSetLabelStyle();
            double scale = 1.0;
            Font font = symbolizer.getFont();
            if (font != null && font.getSize() != null) {
                double size = (Double)font.getSize().evaluate((Object)feature, Double.class);
                scale = (double)Math.round(size / 10.0 * 100.0) / 100.0;
            }
            ls.setScale(scale);
            Fill fill = symbolizer.getFill();
            if (fill != null) {
                Double opacity = (Double)fill.getOpacity().evaluate((Object)feature, Double.class);
                if (opacity == null || Double.isNaN(opacity)) {
                    opacity = 1.0;
                }
                Color color = (Color)fill.getColor().evaluate((Object)feature, Color.class);
                ls.setColor(this.colorToHex(color, opacity));
            } else {
                ls.setColor("ffffffff");
            }
        }

        protected void setPolygonStyle(de.micromata.opengis.kml.v_2_2_0.Style style, SimpleFeature feature, PolygonSymbolizer symbolizer, boolean forceOutline) {
            if (symbolizer.getStroke() != null) {
                this.setLineStyle(style, feature, symbolizer.getStroke());
            }
            PolyStyle ps = style.createAndSetPolyStyle();
            Fill fill = symbolizer.getFill();
            if (fill != null) {
                Double opacity = (Double)fill.getOpacity().evaluate((Object)feature, Double.class);
                if (opacity == null || Double.isNaN(opacity)) {
                    opacity = 1.0;
                }
                Color color = (Color)fill.getColor().evaluate((Object)feature, Color.class);
                ps.setColor(this.colorToHex(color, opacity));
            } else {
                ps.setColor("00aaaaaa");
            }
            if (symbolizer.getStroke() != null || forceOutline) {
                ps.setOutline(Boolean.valueOf(true));
            }
        }

        protected void setLineStyle(de.micromata.opengis.kml.v_2_2_0.Style style, SimpleFeature feature, Stroke stroke) {
            LineStyle ls = style.createAndSetLineStyle();
            if (stroke != null) {
                Double opacity = (Double)stroke.getOpacity().evaluate((Object)feature, Double.class);
                if (opacity == null || Double.isNaN(opacity)) {
                    opacity = 1.0;
                }
                Color color = null;
                Expression sc = stroke.getColor();
                if (sc != null) {
                    color = (Color)sc.evaluate((Object)feature, Color.class);
                }
                if (color == null) {
                    color = Color.DARK_GRAY;
                }
                ls.setColor(this.colorToHex(color, opacity));
                Double width = null;
                Expression sw = stroke.getWidth();
                if (sw != null) {
                    width = (Double)sw.evaluate((Object)feature, Double.class);
                }
                if (width == null) {
                    width = 1.0;
                }
                ls.setWidth(width.doubleValue());
            } else {
                ls.setColor("ffaaaaaa");
                ls.setWidth(1.0);
            }
        }

        private ExternalGraphic getExternalGraphic(PointSymbolizer symbolizer) {
            for (GraphicalSymbol s : symbolizer.getGraphic().graphicalSymbols()) {
                if (!(s instanceof ExternalGraphic)) continue;
                return (ExternalGraphic)s;
            }
            return null;
        }

        protected String evaluateDynamicSymbolizer(String strLocation, SimpleFeature feature) {
            Expression location;
            if (strLocation == null) {
                return null;
            }
            try {
                location = ExpressionExtractor.extractCqlExpressions((String)strLocation);
            }
            catch (IllegalArgumentException e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "Could not parse cql expressions out of " + strLocation, e);
                }
                location = this.ff.literal((Object)strLocation);
            }
            return (String)location.evaluate((Object)feature, String.class);
        }

        String colorToHex(Color c, double opacity) {
            return new StringBuffer().append(this.intToHex(new Float(255.0 * opacity).intValue())).append(this.intToHex(c.getBlue())).append(this.intToHex(c.getGreen())).append(this.intToHex(c.getRed())).toString();
        }

        String intToHex(int i) {
            String prelim = Integer.toHexString(i);
            if (prelim.length() < 2) {
                prelim = "0" + prelim;
            }
            return prelim;
        }
    }
}

