/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.decorator;

import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Placemark;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.kml.decorator.KmlDecoratorFactory;
import org.geotools.styling.SLD;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.expression.Expression;

public class PlacemarkNameDecoratorFactory
implements KmlDecoratorFactory {
    @Override
    public KmlDecoratorFactory.KmlDecorator getDecorator(Class<? extends Feature> featureClass, KmlEncodingContext context) {
        if (Placemark.class.isAssignableFrom(featureClass) && context.isDescriptionEnabled()) {
            return new PlacemarkNameDecorator();
        }
        return null;
    }

    static class PlacemarkNameDecorator
    implements KmlDecoratorFactory.KmlDecorator {
        static final Logger LOGGER = Logging.getLogger(PlacemarkNameDecorator.class);

        PlacemarkNameDecorator() {
        }

        @Override
        public Feature decorate(Feature feature, KmlEncodingContext context) {
            Placemark pm = (Placemark)feature;
            SimpleFeature sf = context.getCurrentFeature();
            String title = null;
            try {
                title = context.getTemplate().title(sf);
            }
            catch (IOException e) {
                String msg = "Error occured processing 'title' template.";
                LOGGER.log(Level.WARNING, msg, e);
            }
            String featureId = sf.getID();
            if (title == null || "".equals(title) || featureId.equals(title)) {
                title = featureId;
                if (context.getCurrentSymbolizers() != null) {
                    StringBuffer label = new StringBuffer();
                    for (Symbolizer sym : context.getCurrentSymbolizers()) {
                        Expression e;
                        String value;
                        if (!(sym instanceof TextSymbolizer) || (value = (String)(e = SLD.textLabel((TextSymbolizer)((TextSymbolizer)sym))).evaluate((Object)sf, String.class)) == null || "".equals(value.trim())) continue;
                        label.append(value);
                    }
                    if (label.length() > 0) {
                        title = label.toString();
                    }
                }
            }
            pm.setName(title);
            return pm;
        }
    }
}

