/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.decorator;

import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.ExtendedData;
import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Placemark;
import de.micromata.opengis.kml.v_2_2_0.Schema;
import de.micromata.opengis.kml.v_2_2_0.SchemaData;
import de.micromata.opengis.kml.v_2_2_0.SimpleData;
import de.micromata.opengis.kml.v_2_2_0.SimpleField;
import java.util.Date;
import java.util.logging.Logger;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.kml.decorator.KmlDecoratorFactory;
import org.geoserver.platform.ServiceException;
import org.geotools.util.Converter;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.geotools.xml.XmlConverterFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryDescriptor;

public class ExtendedDataDecoratorFactory
implements KmlDecoratorFactory {
    @Override
    public KmlDecoratorFactory.KmlDecorator getDecorator(Class<? extends Feature> featureClass, KmlEncodingContext context) {
        if (!context.isExtendedDataEnabled()) {
            return null;
        }
        if (Placemark.class.isAssignableFrom(featureClass)) {
            return new PlacemarkDataDecorator();
        }
        if (Document.class.isAssignableFrom(featureClass)) {
            return new DocumentSchemaDecorator();
        }
        return null;
    }

    static class PlacemarkDataDecorator
    implements KmlDecoratorFactory.KmlDecorator {
        static final Logger LOGGER = Logging.getLogger(PlacemarkDataDecorator.class);
        static final Converter DATE_CONVERTER = new XmlConverterFactory().createConverter(Date.class, String.class, null);

        PlacemarkDataDecorator() {
        }

        @Override
        public Feature decorate(Feature feature, KmlEncodingContext context) {
            SimpleFeature sf = context.getCurrentFeature();
            Placemark pm = (Placemark)feature;
            ExtendedData exd = pm.createAndSetExtendedData();
            SchemaData schemaData = exd.createAndAddSchemaData();
            schemaData.setSchemaUrl("#" + context.getCurrentFeatureType().getTypeName() + "_" + context.getCurrentLayerIndex());
            for (AttributeDescriptor ad : sf.getFeatureType().getAttributeDescriptors()) {
                String kmlValue;
                Object value;
                if (ad instanceof GeometryDescriptor || (value = sf.getAttribute(ad.getLocalName())) == null) continue;
                if (value instanceof Date) {
                    try {
                        kmlValue = (String)DATE_CONVERTER.convert(value, String.class);
                    }
                    catch (Exception e) {
                        throw new ServiceException("Failed to convert date into string while generating extended data section", (Throwable)e);
                    }
                } else {
                    kmlValue = (String)Converters.convert((Object)value, String.class);
                }
                SimpleData sd = schemaData.createAndAddSimpleData(ad.getLocalName());
                sd.setValue(kmlValue);
            }
            return pm;
        }
    }

    static class DocumentSchemaDecorator
    implements KmlDecoratorFactory.KmlDecorator {
        DocumentSchemaDecorator() {
        }

        @Override
        public Feature decorate(Feature feature, KmlEncodingContext context) {
            Document doc = (Document)feature;
            int i = 1;
            for (SimpleFeatureType schema : context.getFeatureTypes()) {
                if (schema != null) {
                    String id = schema.getTypeName() + "_" + i;
                    this.addSchema(doc, id, schema);
                }
                ++i;
            }
            return doc;
        }

        private void addSchema(Document doc, String id, SimpleFeatureType featureType) {
            Schema schema = doc.createAndAddSchema();
            schema.setId(id);
            schema.setName(id);
            for (AttributeDescriptor ad : featureType.getAttributeDescriptors()) {
                if (ad instanceof GeometryDescriptor) continue;
                SimpleField field = schema.createAndAddSimpleField();
                field.setName(ad.getLocalName());
                field.setType(this.getKmlFieldType(ad));
            }
        }

        private String getKmlFieldType(AttributeDescriptor ad) {
            AttributeType at = ad.getType();
            if (Short.class.equals((Object)at.getBinding())) {
                return "short";
            }
            if (Integer.class.equals((Object)at.getBinding())) {
                return "int";
            }
            if (Float.class.equals((Object)at.getBinding())) {
                return "float";
            }
            if (Double.class.equals((Object)at.getBinding())) {
                return "double";
            }
            if (Boolean.class.equals((Object)at.getBinding())) {
                return "bool";
            }
            return "string";
        }
    }
}

