/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml.builder;

import com.vividsolutions.jts.geom.Envelope;
import de.micromata.opengis.kml.v_2_2_0.AbstractLatLonBox;
import de.micromata.opengis.kml.v_2_2_0.AbstractView;
import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Folder;
import de.micromata.opengis.kml.v_2_2_0.GroundOverlay;
import de.micromata.opengis.kml.v_2_2_0.Icon;
import de.micromata.opengis.kml.v_2_2_0.LatLonAltBox;
import de.micromata.opengis.kml.v_2_2_0.LatLonBox;
import de.micromata.opengis.kml.v_2_2_0.Link;
import de.micromata.opengis.kml.v_2_2_0.Lod;
import de.micromata.opengis.kml.v_2_2_0.LookAt;
import de.micromata.opengis.kml.v_2_2_0.NetworkLink;
import de.micromata.opengis.kml.v_2_2_0.Region;
import de.micromata.opengis.kml.v_2_2_0.ViewRefreshMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.kml.builder.AbstractNetworkLinkBuilder;
import org.geoserver.kml.decorator.LookAtDecoratorFactory;
import org.geoserver.kml.regionate.Tile;
import org.geoserver.kml.utils.KMLFeatureAccessor;
import org.geoserver.kml.utils.LookAtOptions;
import org.geoserver.ows.HttpErrorCodeException;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.CaseInsensitiveMap;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WMSRequests;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.Style;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SuperOverlayNetworkLinkBuilder
extends AbstractNetworkLinkBuilder {
    private GetMapRequest request;
    private WMSMapContent mapContent;
    private WMS wms;
    static final String VISIBLE_KEY = "kmlvisible";

    public SuperOverlayNetworkLinkBuilder(KmlEncodingContext context) {
        super(context);
        this.request = context.getRequest();
        this.mapContent = context.getMapContent();
        this.wms = context.getWms();
    }

    @Override
    void encodeDocumentContents(Document container) {
        boolean cachedMode = "cached".equals(this.context.getSuperOverlayMode());
        Tile tile = new Tile(new ReferencedEnvelope(this.request.getBbox(), Tile.WGS84));
        while (tile.getZ() > 0L && !tile.getEnvelope().contains(this.request.getBbox())) {
            tile = tile.getParent();
        }
        ReferencedEnvelope normalizedEnvelope = null;
        normalizedEnvelope = tile.getZ() >= 0L && tile.getEnvelope().contains(this.request.getBbox()) ? tile.getEnvelope() : KmlEncodingContext.WORLD_BOUNDS_WGS84;
        int zoomLevel = (int)tile.getZ();
        this.addRegion((Feature)container, (Envelope)normalizedEnvelope, Integer.MAX_VALUE, -1);
        List layers = this.request.getLayers();
        for (int i = 0; i < layers.size(); ++i) {
            MapLayerInfo layer = (MapLayerInfo)layers.get(i);
            if (cachedMode && this.isRequestGWCCompatible(this.request, i, this.wms)) {
                this.encodeGWCLink(container, this.request, layer);
                continue;
            }
            this.encodeLayerSuperOverlay(container, layer, i, (Envelope)normalizedEnvelope, zoomLevel);
        }
    }

    public void encodeGWCLink(Document container, GetMapRequest request, MapLayerInfo layer) {
        NetworkLink nl = container.createAndAddNetworkLink();
        String prefixedName = layer.getResource().prefixedName();
        nl.setName("GWC-" + prefixedName);
        Link link = nl.createAndSetLink();
        String type = layer.getType() == MapLayerInfo.TYPE_RASTER ? "png" : "kml";
        String url = ResponseUtils.buildURL((String)request.getBaseUrl(), (String)("gwc/service/kml/" + prefixedName + "." + type + ".kml"), null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
        link.setHref(url);
        link.setViewRefreshMode(ViewRefreshMode.NEVER);
    }

    private void encodeLayerSuperOverlay(Document container, MapLayerInfo layerInfo, int layerIndex, Envelope bounds, int zoomLevel) {
        Map formatOptions = this.request.getFormatOptions();
        Layer layer = (Layer)this.mapContent.layers().get(layerIndex);
        Folder folder = container.createAndAddFolder();
        folder.setName(layerInfo.getLabel());
        if (layerInfo.getDescription() != null && layerInfo.getDescription().length() > 0) {
            folder.setDescription(layerInfo.getDescription());
        }
        if (formatOptions.get(VISIBLE_KEY) != null) {
            boolean visible = Boolean.parseBoolean(formatOptions.get(VISIBLE_KEY).toString());
            folder.setVisibility(Boolean.valueOf(visible));
        } else {
            folder.setVisibility(Boolean.valueOf(true));
        }
        LookAtOptions lookAtOptions = new LookAtOptions(formatOptions);
        if (bounds != null) {
            LookAtDecoratorFactory lookAtFactory = new LookAtDecoratorFactory();
            ReferencedEnvelope layerBounds = layer.getBounds();
            CoordinateReferenceSystem layerCRS = layerBounds.getCoordinateReferenceSystem();
            if (layerCRS != null && !CRS.equalsIgnoreMetadata((Object)layerCRS, (Object)DefaultGeographicCRS.WGS84)) {
                try {
                    layerBounds = layerBounds.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
                }
                catch (Exception e) {
                    throw new ServiceException("Failed to transform the layer bounds for " + layer.getTitle() + " to WGS84", (Throwable)e);
                }
            }
            LookAt la = lookAtFactory.buildLookAt((Envelope)layerBounds, lookAtOptions, false);
            folder.setAbstractView((AbstractView)la);
        }
        this.encodeNetworkLinks(folder, layer, bounds, zoomLevel);
    }

    void encodeNetworkLinks(Folder folder, Layer layer, Envelope top, int zoomLevel) {
        if (top != KmlEncodingContext.WORLD_BOUNDS_WGS84) {
            Envelope e00 = new Envelope(top.getMinX(), top.getMinX() + top.getWidth() / 2.0, top.getMaxY() - top.getHeight() / 2.0, top.getMaxY());
            Envelope e01 = new Envelope(e00.getMaxX(), top.getMaxX(), e00.getMinY(), e00.getMaxY());
            Envelope e10 = new Envelope(e00.getMinX(), e00.getMaxX(), top.getMinY(), e00.getMinY());
            Envelope e11 = new Envelope(e01.getMinX(), e01.getMaxX(), e10.getMinY(), e10.getMaxY());
            this.addNetworkLink(folder, e00, "00", layer);
            this.addNetworkLink(folder, e01, "01", layer);
            this.addNetworkLink(folder, e10, "10", layer);
            this.addNetworkLink(folder, e11, "11", layer);
        } else {
            Envelope e0 = new Envelope(top.getMinX(), top.getMinX() + top.getWidth() / 2.0, top.getMinY(), top.getMaxY());
            Envelope e1 = new Envelope(e0.getMaxX(), top.getMaxX(), top.getMinY(), top.getMaxY());
            this.addNetworkLink(folder, e0, "0", layer);
            this.addNetworkLink(folder, e1, "1", layer);
        }
        if (top == KmlEncodingContext.WORLD_BOUNDS_WGS84) {
            this.encodeTileContents(folder, layer, "contents-0", zoomLevel, new Envelope(-180.0, 0.0, -90.0, 90.0));
            this.encodeTileContents(folder, layer, "contents-1", zoomLevel, new Envelope(0.0, 180.0, -90.0, 90.0));
        } else {
            this.encodeTileContents(folder, layer, "contents", zoomLevel, top);
        }
    }

    void addRegion(Feature container, Envelope box, int minLodPixels, int maxLodPixels) {
        Region region = container.createAndSetRegion();
        Lod lod = region.createAndSetLod();
        lod.setMinLodPixels((double)minLodPixels);
        lod.setMaxLodPixels((double)maxLodPixels);
        LatLonAltBox llaBox = region.createAndSetLatLonAltBox();
        this.setEnvelope(box, (AbstractLatLonBox)llaBox);
    }

    private void setEnvelope(Envelope box, AbstractLatLonBox llBox) {
        llBox.setNorth(box.getMaxY());
        llBox.setSouth(box.getMinY());
        llBox.setEast(box.getMaxX());
        llBox.setWest(box.getMinX());
    }

    void addNetworkLink(Folder container, Envelope box, String name, Layer layer) {
        String overlayMode = this.context.getSuperOverlayMode();
        if (!"raster".equals(overlayMode) && layer instanceof FeatureLayer && !this.shouldDrawVectorLayer(layer, box)) {
            return;
        }
        NetworkLink nl = container.createAndAddNetworkLink();
        nl.setName(name);
        this.addRegion((Feature)nl, box, 128, -1);
        Link link = nl.createAndSetLink();
        String getMap = WMSRequests.getGetMapUrl((GetMapRequest)this.request, (Layer)layer, (int)0, (Envelope)box, (String[])new String[]{"format", "application/vnd.google-earth.kml+xml", "width", "256", "height", "256", "format", "application/vnd.google-earth.kml+xml;mode=networklink"});
        link.setHref(getMap);
        LOGGER.fine("Network link " + name + ":" + getMap);
        link.setViewRefreshMode(ViewRefreshMode.ON_REGION);
    }

    void encodeTileContents(Folder container, Layer layer, String name, int drawOrder, Envelope box) {
        try {
            if (this.shouldDrawVectorLayer(layer, box)) {
                this.encodeKMLLink(container, layer, name, drawOrder, box);
            }
            if (this.shouldDrawWMSOverlay(layer, box)) {
                this.encodeGroundOverlay(container, layer, drawOrder, box);
            }
        }
        catch (HttpErrorCodeException e) {
            // empty catch block
        }
    }

    private boolean shouldDrawVectorLayer(Layer layer, Envelope box) {
        try {
            if (!this.isVectorLayer(layer)) {
                return false;
            }
            String overlayMode = this.context.getSuperOverlayMode();
            if ("raster".equals(overlayMode)) {
                return false;
            }
            if ("overview".equals(overlayMode)) {
                int featureCount = this.featuresInTile(layer, box, false);
                return featureCount <= this.getRegionateFeatureLimit(this.getFeatureTypeInfo(layer));
            }
            int featureCount = this.featuresInTile(layer, box, true);
            return featureCount > 0;
        }
        catch (HttpErrorCodeException e) {
            return false;
        }
    }

    private int getRegionateFeatureLimit(FeatureTypeInfo ft) {
        Integer regionateFeatureLimit = (Integer)ft.getMetadata().get("kml.regionateFeatureLimit", Integer.class);
        return regionateFeatureLimit != null ? regionateFeatureLimit : -1;
    }

    private boolean shouldDrawWMSOverlay(Layer layer, Envelope box) {
        if (!this.isVectorLayer(layer)) {
            return true;
        }
        String overlayMode = this.context.getSuperOverlayMode();
        if ("hybrid".equals(overlayMode) || "raster".equals(overlayMode)) {
            return true;
        }
        if ("overview".equals(overlayMode)) {
            return this.featuresInTile(layer, box, false) > this.getRegionateFeatureLimit(this.getFeatureTypeInfo(layer));
        }
        return false;
    }

    void encodeKMLLink(Folder container, Layer layer, String name, int drawOrder, Envelope box) {
        CaseInsensitiveMap fo = new CaseInsensitiveMap(new HashMap());
        fo.putAll(this.mapContent.getRequest().getFormatOptions());
        fo.remove((Object)"superoverlay");
        String overlayMode = (String)fo.get((Object)"overlayMode");
        if ("overview".equalsIgnoreCase(overlayMode)) {
            fo.remove((Object)"regionateBy");
        } else if (!fo.containsKey((Object)"regionateBy")) {
            fo.put((Object)"regionateBy", (Object)"auto");
        }
        String foEncoded = WMSRequests.encodeFormatOptions((Map)fo);
        NetworkLink nl = container.createAndAddNetworkLink();
        nl.setName(name);
        this.addRegion((Feature)nl, box, 128, -1);
        nl.setVisibility(Boolean.valueOf(true));
        Link link = nl.createAndSetLink();
        String url = WMSRequests.getGetMapUrl((GetMapRequest)this.request, (Layer)layer, (int)0, (Envelope)box, (String[])new String[]{"width", "256", "height", "256", "format_options", foEncoded, "superoverlay", "true"});
        link.setHref(url);
    }

    boolean isVectorLayer(Layer layer) {
        int index = this.mapContent.layers().indexOf(layer);
        MapLayerInfo info = (MapLayerInfo)this.mapContent.getRequest().getLayers().get(index);
        return info.getType() == MapLayerInfo.TYPE_VECTOR || info.getType() == MapLayerInfo.TYPE_REMOTE_VECTOR;
    }

    private FeatureTypeInfo getFeatureTypeInfo(Layer layer) {
        for (MapLayerInfo info : this.mapContent.getRequest().getLayers()) {
            if (!info.getName().equals(layer.getTitle())) continue;
            return info.getFeature();
        }
        return null;
    }

    private int featuresInTile(Layer layer, Envelope bounds, boolean regionate) {
        if (!this.isVectorLayer(layer)) {
            return 1;
        }
        Envelope originalBounds = this.mapContent.getRequest().getBbox();
        this.mapContent.getRequest().setBbox(bounds);
        this.mapContent.getViewport().setBounds(new ReferencedEnvelope(bounds, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        String originalRegionateBy = null;
        if (regionate && (originalRegionateBy = (String)this.mapContent.getRequest().getFormatOptions().get("regionateby")) == null) {
            this.mapContent.getRequest().getFormatOptions().put("regionateby", "auto");
        }
        int numFeatures = 0;
        try {
            numFeatures = new KMLFeatureAccessor().getFeatureCount(layer, this.mapContent, this.wms, -1.0);
        }
        catch (ServiceException e) {
            LOGGER.severe("Caught the WmsException!");
            numFeatures = -1;
        }
        catch (HttpErrorCodeException e) {
            if (e.getErrorCode() == 204) {
                throw e;
            }
            LOGGER.log(Level.WARNING, "Failure while checking whether a regionated child tile contained features!", e);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failure while checking whether a regionated child tile contained features!", e);
        }
        this.mapContent.getRequest().setBbox(originalBounds);
        this.mapContent.getViewport().setBounds(new ReferencedEnvelope(originalBounds, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        if (regionate && originalRegionateBy == null) {
            this.mapContent.getRequest().getFormatOptions().remove("regionateby");
        }
        return numFeatures;
    }

    void encodeGroundOverlay(Folder container, Layer layer, int drawOrder, Envelope box) {
        GroundOverlay go = container.createAndAddGroundOverlay();
        go.setDrawOrder(drawOrder);
        Icon icon = go.createAndSetIcon();
        String href = WMSRequests.getGetMapUrl((GetMapRequest)this.request, (Layer)layer, (int)0, (Envelope)box, (String[])new String[]{"width", "256", "height", "256", "format", "image/png", "transparent", "true"});
        icon.setHref(href);
        LOGGER.fine(href);
        this.addRegion((Feature)go, box, 128, 512);
        LatLonBox llBox = go.createAndSetLatLonBox();
        this.setEnvelope(box, (AbstractLatLonBox)llBox);
    }

    private boolean isRequestGWCCompatible(GetMapRequest request, int layerIndex, WMS wms) {
        boolean requestKmAttr = this.context.isDescriptionEnabled();
        if (requestKmAttr != wms.getKmlKmAttr()) {
            return false;
        }
        boolean requestKmplacemark = this.context.isPlacemarkForced();
        if (requestKmplacemark != wms.getKmlPlacemark()) {
            return false;
        }
        int requestKmscore = this.context.getKmScore();
        if (requestKmscore != wms.getKmScore()) {
            return false;
        }
        if (((MapLayerInfo)request.getLayers().get(layerIndex)).getType() == MapLayerInfo.TYPE_REMOTE_VECTOR) {
            return false;
        }
        Style requestedStyle = (Style)request.getStyles().get(layerIndex);
        Style defaultStyle = ((MapLayerInfo)request.getLayers().get(layerIndex)).getDefaultStyle();
        if (!defaultStyle.equals(requestedStyle)) {
            return false;
        }
        List filters = request.getFilter();
        if (filters != null && filters.size() > 0 && filters.get(layerIndex) != Filter.INCLUDE) {
            return false;
        }
        String antialias = (String)request.getFormatOptions().get("antialias");
        if (antialias != null && !"FULL".equalsIgnoreCase(antialias)) {
            return false;
        }
        if (request.getPalette() != null) {
            return false;
        }
        if (request.getStartIndex() != null && request.getStartIndex() != 0) {
            return false;
        }
        if (request.getMaxFeatures() != null) {
            return false;
        }
        return request.getViewParams() == null || request.getViewParams().size() <= 0;
    }
}

