/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.geoserver.kml.KMZMapOutputFormat;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.DefaultWebMapService;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSRequests;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.WebMapService;
import org.geotools.util.logging.Logging;

public class KMLReflector {
    private static Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.wms.responses.map.kml");
    public static final String FORMAT = "application/vnd.google-earth.kml+xml";
    private static Map<String, Map<String, Object>> MODES;
    private static int DEFAULT_OVERLAY_SIZE;
    WebMapService wms;
    WMS wmsConfiguration;

    public KMLReflector(WebMapService wms, WMS wmsConfiguration) {
        this.wms = wms;
        this.wmsConfiguration = wmsConfiguration;
    }

    public static WebMap doWms(GetMapRequest request, WebMapService wms, WMS wmsConfiguration) throws Exception {
        Boolean superoverlay;
        StringBuffer filename = new StringBuffer();
        boolean containsRasterData = false;
        boolean isRegionatingFriendly = true;
        for (int i = 0; i < request.getLayers().size(); ++i) {
            MapLayerInfo layer = (MapLayerInfo)request.getLayers().get(i);
            String name = layer.getName();
            boolean bl = containsRasterData = containsRasterData || layer.getType() == MapLayerInfo.TYPE_RASTER;
            if (layer.getType() == MapLayerInfo.TYPE_VECTOR) {
                isRegionatingFriendly = isRegionatingFriendly && layer.getFeature().getFeatureSource(null, null).getQueryCapabilities().isReliableFIDSupported();
            } else if (layer.getType() == MapLayerInfo.TYPE_REMOTE_VECTOR) {
                isRegionatingFriendly = isRegionatingFriendly && layer.getRemoteFeatureSource().getQueryCapabilities().isReliableFIDSupported();
            }
            int j = name.indexOf(58);
            if (j > -1) {
                name = name.substring(j + 1);
            }
            filename.append(name + "_");
        }
        Map rawKvp = request.getRawKvp();
        String mode = KvpUtils.caseInsensitiveParam((Map)rawKvp, (String)"mode", (String)wmsConfiguration.getKmlReflectorMode());
        if (!MODES.containsKey(mode)) {
            throw new ServiceException("Unknown KML mode: " + mode);
        }
        HashMap<String, Object> modeOptions = new HashMap<String, Object>(MODES.get(mode));
        if ("superoverlay".equals(mode)) {
            String submode = KvpUtils.caseInsensitiveParam((Map)request.getRawKvp(), (String)"superoverlay_mode", (String)wmsConfiguration.getKmlSuperoverlayMode());
            if ("raster".equalsIgnoreCase(submode)) {
                modeOptions.put("overlaymode", "raster");
            } else if ("overview".equalsIgnoreCase(submode)) {
                modeOptions.put("overlaymode", "overview");
            } else if ("hybrid".equalsIgnoreCase(submode)) {
                modeOptions.put("overlaymode", "hybrid");
            } else if ("auto".equalsIgnoreCase(submode)) {
                modeOptions.put("overlaymode", "auto");
            } else if ("cached".equalsIgnoreCase(submode)) {
                modeOptions.put("overlaymode", "cached");
            } else {
                throw new ServiceException("Unknown overlay mode: " + submode);
            }
        }
        Map fo = request.getFormatOptions();
        boolean refreshMode = mode.equals("refresh");
        if (request.getWidth() < 1) {
            request.setWidth(refreshMode || containsRasterData ? DEFAULT_OVERLAY_SIZE : 256);
            fo.put("autofit", "true");
        }
        if (request.getHeight() < 1) {
            request.setHeight(refreshMode || containsRasterData ? DEFAULT_OVERLAY_SIZE : 256);
            fo.put("autofit", "true");
        }
        request.setSRS("EPSG:4326");
        request = DefaultWebMapService.autoSetMissingProperties((GetMapRequest)request);
        KMLReflector.organizeFormatOptionsParams(request.getRawKvp(), fo);
        KMLReflector.mergeDefaults(fo, modeOptions);
        if (fo.get("kmattr") == null) {
            fo.put("kmattr", wmsConfiguration.getKmlKmAttr());
        }
        if (fo.get("kmscore") == null) {
            fo.put("kmscore", wmsConfiguration.getKmScore());
        }
        if (fo.get("kmplacemark") == null) {
            fo.put("kmplacemark", wmsConfiguration.getKmlPlacemark());
        }
        if ((superoverlay = (Boolean)fo.get("superoverlay")) == null) {
            superoverlay = Boolean.FALSE;
        }
        if (superoverlay.booleanValue() || refreshMode || containsRasterData) {
            request.setFormat("application/vnd.google-earth.kml+xml;mode=networklink");
        } else if (!Arrays.asList(KMZMapOutputFormat.OUTPUT_FORMATS).contains(request.getFormat())) {
            request.setFormat(FORMAT);
        }
        WebMap wmsResponse = wms.getMap(request);
        return wmsResponse;
    }

    private static void mergeDefaults(Map fo, Map defaults) {
        for (Map.Entry o : defaults.entrySet()) {
            Map.Entry entry = o;
            if (fo.get(entry.getKey()) != null) continue;
            fo.put(entry.getKey(), entry.getValue());
        }
    }

    public static void organizeFormatOptionsParams(Map<String, String> kvp, Map<String, Object> formatOptions) throws Exception {
        WMSRequests.mergeEntry(kvp, formatOptions, (String)"legend");
        WMSRequests.mergeEntry(kvp, formatOptions, (String)"kmscore");
        WMSRequests.mergeEntry(kvp, formatOptions, (String)"kmattr");
        WMSRequests.mergeEntry(kvp, formatOptions, (String)"kmltitle");
        WMSRequests.mergeEntry(kvp, formatOptions, (String)"kmlrefresh");
        WMSRequests.mergeEntry(kvp, formatOptions, (String)"kmlvisible");
        WMSRequests.mergeEntry(kvp, formatOptions, (String)"extendeddata");
        WMSRequests.mergeEntry(kvp, formatOptions, (String)"extrude");
        WMSRequests.mergeEntry(kvp, formatOptions, (String)"kmplacemark");
        WMSRequests.mergeEntry(kvp, formatOptions, (String)"superoverlay_mode");
        WMSRequests.mergeEntry(kvp, formatOptions, (String)"overlay_mode");
    }

    static {
        HashMap<String, Map<String, Object>> temp = new HashMap<String, Map<String, Object>>();
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("superoverlay", true);
        options.put("mode", "superoverlay");
        temp.put("superoverlay", options);
        options = new HashMap();
        options.put("superoverlay", false);
        options.put("kmscore", 100);
        options.put("mode", "download");
        temp.put("download", options);
        options = new HashMap();
        options.put("superoverlay", false);
        options.put("mode", "refresh");
        temp.put("refresh", options);
        MODES = temp;
        DEFAULT_OVERLAY_SIZE = Integer.getInteger("org.geoserver.kml.defaultOverlaySize", 2048);
    }
}

