/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.kml;

import de.micromata.opengis.kml.v_2_2_0.Kml;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.geoserver.kml.KMLMap;
import org.geoserver.kml.KmlEncodingContext;
import org.geoserver.kml.builder.StreamingKMLBuilder;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geotools.util.logging.Logging;

public class KMLMapOutputFormat
implements GetMapOutputFormat {
    protected static final Logger LOGGER = Logging.getLogger(KMLMapOutputFormat.class);
    static final MapProducerCapabilities KML_CAPABILITIES = new MapProducerCapabilities(false, false, true, true, null);
    public static final String MIME_TYPE = "application/vnd.google-earth.kml+xml";
    public static final String NL_KML_MIME_TYPE = "application/vnd.google-earth.kml+xml;mode=networklink";
    private Set<String> OUTPUT_FORMATS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("application/vnd.google-earth.kml+xml", "application/vnd.google-earth.kml", "kml", "application/vnd.google-earth.kml xml")));
    private WMS wms;
    StreamingKMLBuilder builder = new StreamingKMLBuilder();

    public KMLMapOutputFormat(WMS wms) {
        this.wms = wms;
    }

    public Set<String> getOutputFormatNames() {
        return this.OUTPUT_FORMATS;
    }

    public String getMimeType() {
        return MIME_TYPE;
    }

    public KMLMap produceMap(WMSMapContent mapContent) throws ServiceException, IOException {
        KmlEncodingContext context = new KmlEncodingContext(mapContent, this.wms, false);
        Kml kml = this.builder.buildKMLDocument(context);
        KMLMap map = new KMLMap(mapContent, context, kml, MIME_TYPE);
        map.setContentDispositionHeader(mapContent, ".kml");
        return map;
    }

    public MapProducerCapabilities getCapabilities(String format) {
        return KML_CAPABILITIES;
    }
}

