/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.service.wmts;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geowebcache.GeoWebCacheDispatcher;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.OutsideCoverageException;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.service.OWSException;
import org.geowebcache.service.Service;
import org.geowebcache.service.wmts.WMTSGetCapabilities;
import org.geowebcache.service.wmts.WMTSGetFeatureInfo;
import org.geowebcache.stats.RuntimeStats;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.util.NullURLMangler;
import org.geowebcache.util.ServletUtils;
import org.geowebcache.util.URLMangler;

public class WMTSService
extends Service {
    public static final String SERVICE_WMTS = "wmts";
    static final String SERVICE_PATH = "/service/wmts";
    private StorageBroker sb;
    private TileLayerDispatcher tld;
    private GridSetBroker gsb;
    private RuntimeStats stats;
    private URLMangler urlMangler = new NullURLMangler();
    private GeoWebCacheDispatcher controller = null;

    protected WMTSService() {
        super(SERVICE_WMTS);
    }

    public WMTSService(StorageBroker sb, TileLayerDispatcher tld, GridSetBroker gsb, RuntimeStats stats) {
        super(SERVICE_WMTS);
        this.sb = sb;
        this.tld = tld;
        this.gsb = gsb;
        this.stats = stats;
    }

    public WMTSService(StorageBroker sb, TileLayerDispatcher tld, GridSetBroker gsb, RuntimeStats stats, URLMangler urlMangler, GeoWebCacheDispatcher controller) {
        super(SERVICE_WMTS);
        this.sb = sb;
        this.tld = tld;
        this.gsb = gsb;
        this.stats = stats;
        this.urlMangler = urlMangler;
        this.controller = controller;
    }

    public Conveyor getConveyor(HttpServletRequest request, HttpServletResponse response) throws GeoWebCacheException, OWSException {
        String encoding = request.getCharacterEncoding();
        String[] keys = new String[]{"layer", "request", "style", "format", "tilematrixset", "tilematrix", "tilerow", "tilecol"};
        Map values = ServletUtils.selectedStringsFromMap((Map)request.getParameterMap(), (String)encoding, (String[])keys);
        String req = (String)values.get("request");
        if (req == null) {
            throw new OWSException(400, "MissingParameterValue", "request", "Missing Request parameter");
        }
        if ((req = req.toLowerCase()).equals("gettile")) {
            ConveyorTile tile = this.getTile(values, request, response, RequestType.TILE);
            return tile;
        }
        if (req.equals("getcapabilities")) {
            ConveyorTile tile = new ConveyorTile(this.sb, (String)values.get("layer"), request, response);
            tile.setHint(req);
            tile.setRequestHandler(Conveyor.RequestHandler.SERVICE);
            return tile;
        }
        if (req.equals("getfeatureinfo")) {
            ConveyorTile tile = this.getTile(values, request, response, RequestType.FEATUREINFO);
            tile.setHint(req);
            tile.setRequestHandler(Conveyor.RequestHandler.SERVICE);
            return tile;
        }
        throw new OWSException(501, "OperationNotSupported", "request", req + " is not implemented");
    }

    private ConveyorTile getTile(Map<String, String> values, HttpServletRequest request, HttpServletResponse response, RequestType reqType) throws OWSException {
        long[] gridCov;
        Map fullParameters;
        String encoding = request.getCharacterEncoding();
        String layer = values.get("layer");
        if (layer == null) {
            throw new OWSException(400, "MissingParameterValue", "LAYER", "Missing LAYER parameter");
        }
        TileLayer tileLayer = null;
        try {
            tileLayer = this.tld.getTileLayer(layer);
        }
        catch (GeoWebCacheException e) {
            throw new OWSException(400, "InvalidParameterValue", "LAYER", "LAYER " + layer + " is not known.");
        }
        try {
            HashMap rawParameters = new HashMap(request.getParameterMap());
            for (Map.Entry e : rawParameters.entrySet()) {
                if (!((String)e.getKey()).equalsIgnoreCase("STYLE")) continue;
                rawParameters.put("STYLES", e.getValue());
                break;
            }
            fullParameters = tileLayer.getModifiableParameters(rawParameters, encoding);
        }
        catch (GeoWebCacheException e) {
            throw new OWSException(500, "NoApplicableCode", "", e.getMessage() + " while fetching modifiable parameters for LAYER " + layer);
        }
        MimeType mimeType = null;
        if (reqType == RequestType.TILE) {
            String format = values.get("format");
            if (format == null) {
                throw new OWSException(400, "MissingParameterValue", "FORMAT", "Unable to determine requested FORMAT, " + format);
            }
            try {
                mimeType = MimeType.createFromFormat((String)format);
            }
            catch (MimeException me) {
                throw new OWSException(400, "InvalidParameterValue", "FORMAT", "Unable to determine requested FORMAT, " + format);
            }
        }
        String infoFormat = ServletUtils.stringFromMap((Map)request.getParameterMap(), (String)request.getCharacterEncoding(), (String)"infoformat");
        if (infoFormat == null) {
            throw new OWSException(400, "MissingParameterValue", "INFOFORMAT", "Parameter INFOFORMAT was not provided");
        }
        try {
            mimeType = MimeType.createFromFormat((String)infoFormat);
        }
        catch (MimeException me) {
            throw new OWSException(400, "InvalidParameterValue", "INFOFORMAT", "Unable to determine requested INFOFORMAT, " + infoFormat);
        }
        String tilematrixset = values.get("tilematrixset");
        if (tilematrixset == null) {
            throw new OWSException(400, "MissingParameterValue", "TILEMATRIXSET", "No TILEMATRIXSET specified");
        }
        GridSubset gridSubset = tileLayer.getGridSubset(tilematrixset);
        if (gridSubset == null) {
            throw new OWSException(400, "InvalidParameterValue", "TILEMATRIXSET", "Unable to match requested TILEMATRIXSET " + tilematrixset + " to those supported by layer");
        }
        String tileMatrix = values.get("tilematrix");
        if (tileMatrix == null) {
            throw new OWSException(400, "MissingParameterValue", "TILEMATRIX", "No TILEMATRIX specified");
        }
        long z = gridSubset.getGridIndex(tileMatrix);
        if (z < 0L) {
            throw new OWSException(400, "InvalidParameterValue", "TILEMATRIX", "Unknown TILEMATRIX " + tileMatrix);
        }
        String tileRow = values.get("tilerow");
        if (tileRow == null) {
            throw new OWSException(400, "MissingParameterValue", "TILEROW", "No TILEROW specified");
        }
        long tilesHigh = gridSubset.getNumTilesHigh((int)z);
        long y = tilesHigh - Long.parseLong(tileRow) - 1L;
        String tileCol = values.get("tilecol");
        if (tileCol == null) {
            throw new OWSException(400, "MissingParameterValue", "TILECOLUMN", "No TILECOLUMN specified");
        }
        long x = Long.parseLong(tileCol);
        if (x < (gridCov = gridSubset.getCoverage((int)z))[0] || x > gridCov[2]) {
            throw new OWSException(400, "TileOutOfRange", "TILECOLUMN", "Column " + x + " is out of range, min: " + gridCov[0] + " max:" + gridCov[2]);
        }
        if (y < gridCov[1] || y > gridCov[3]) {
            long minRow = tilesHigh - gridCov[3] - 1L;
            long maxRow = tilesHigh - gridCov[1] - 1L;
            throw new OWSException(400, "TileOutOfRange", "TILEROW", "Row " + tileRow + " is out of range, min: " + minRow + " max:" + maxRow);
        }
        long[] tileIndex = new long[]{x, y, z};
        try {
            gridSubset.checkCoverage(tileIndex);
        }
        catch (OutsideCoverageException outsideCoverageException) {
            // empty catch block
        }
        ConveyorTile convTile = new ConveyorTile(this.sb, layer, gridSubset.getName(), tileIndex, mimeType, fullParameters, request, response);
        convTile.setTileLayer(tileLayer);
        return convTile;
    }

    public void handleRequest(Conveyor conv) throws OWSException {
        ConveyorTile tile = (ConveyorTile)conv;
        String servletPrefix = null;
        if (this.controller != null) {
            servletPrefix = this.controller.getServletPrefix();
        }
        String servletBase = ServletUtils.getServletBaseURL((HttpServletRequest)conv.servletReq, (String)servletPrefix);
        String context = ServletUtils.getServletContextPath((HttpServletRequest)conv.servletReq, (String)SERVICE_PATH, (String)servletPrefix);
        if (tile.getHint() != null) {
            if (tile.getHint().equals("getcapabilities")) {
                WMTSGetCapabilities wmsGC = new WMTSGetCapabilities(this.tld, this.gsb, tile.servletReq, servletBase, context, this.urlMangler);
                wmsGC.writeResponse(tile.servletResp, this.stats);
            } else if (tile.getHint().equals("getfeatureinfo")) {
                ConveyorTile convTile = (ConveyorTile)conv;
                WMTSGetFeatureInfo wmsGFI = new WMTSGetFeatureInfo(convTile);
                wmsGFI.writeResponse(this.stats);
            }
        }
    }

    static enum RequestType {
        TILE,
        CAPABILITIES,
        FEATUREINFO;

    }
}

