/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.wcs20;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Section implements Enumerator
{
    COVERAGEDESCRIPTIONS(0, "CoverageDescriptions", "CoverageDescriptions"),
    DATASETSERIESDESCRIPTIONS(1, "DatasetSeriesDescriptions", "DatasetSeriesDescriptions"),
    ALL(2, "All", "All");

    public static final int COVERAGEDESCRIPTIONS_VALUE = 0;
    public static final int DATASETSERIESDESCRIPTIONS_VALUE = 1;
    public static final int ALL_VALUE = 2;
    private static final Section[] VALUES_ARRAY;
    public static final List<Section> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static Section get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Section result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static Section getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Section result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static Section get(int value) {
        switch (value) {
            case 0: {
                return COVERAGEDESCRIPTIONS;
            }
            case 1: {
                return DATASETSERIESDESCRIPTIONS;
            }
            case 2: {
                return ALL;
            }
        }
        return null;
    }

    private Section(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new Section[]{COVERAGEDESCRIPTIONS, DATASETSERIESDESCRIPTIONS, ALL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

