/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.wcs20;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ContainmentType implements Enumerator
{
    OVERLAPS(0, "OVERLAPS", "OVERLAPS"),
    CONTAINS(1, "CONTAINS", "CONTAINS");

    public static final int OVERLAPS_VALUE = 0;
    public static final int CONTAINS_VALUE = 1;
    private static final ContainmentType[] VALUES_ARRAY;
    public static final List<ContainmentType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static ContainmentType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ContainmentType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ContainmentType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ContainmentType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ContainmentType get(int value) {
        switch (value) {
            case 0: {
                return OVERLAPS;
            }
            case 1: {
                return CONTAINS;
            }
        }
        return null;
    }

    private ContainmentType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new ContainmentType[]{OVERLAPS, CONTAINS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

