/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.wms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.geoserver.ExtendedCapabilitiesProvider;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.gwc.GWC;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.wms.ExtendedCapabilitiesProvider;
import org.geoserver.wms.GetCapabilitiesRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geotools.util.NumberRange;
import org.geotools.util.Version;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.mime.MimeType;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class CachingExtendedCapabilitiesProvider
implements ExtendedCapabilitiesProvider {
    private final GWC gwc;

    public CachingExtendedCapabilitiesProvider(GWC gwc) {
        this.gwc = gwc;
    }

    public String[] getSchemaLocations(String schemaBaseURL) {
        return new String[0];
    }

    public List<String> getVendorSpecificCapabilitiesRoots(GetCapabilitiesRequest request) {
        if (this.gwc.getConfig().isDirectWMSIntegrationEnabled() && this.isTiled(request)) {
            return Collections.singletonList("TileSet*");
        }
        return Collections.emptyList();
    }

    private boolean isTiled(GetCapabilitiesRequest request) {
        return Boolean.valueOf((String)request.getRawKvp().get("TILED"));
    }

    public List<String> getVendorSpecificCapabilitiesChildDecls(GetCapabilitiesRequest request) {
        if (this.gwc.getConfig().isDirectWMSIntegrationEnabled() && this.isTiled(request)) {
            ArrayList<String> wmscElements = new ArrayList<String>();
            wmscElements.add("<!ELEMENT TileSet (SRS, BoundingBox?, Resolutions, Width, Height, Format, Layers*, Styles*) >");
            wmscElements.add("<!ELEMENT Resolutions (#PCDATA) >");
            wmscElements.add("<!ELEMENT Width (#PCDATA) >");
            wmscElements.add("<!ELEMENT Height (#PCDATA) >");
            wmscElements.add("<!ELEMENT Layers (#PCDATA) >");
            wmscElements.add("<!ELEMENT Styles (#PCDATA) >");
            return wmscElements;
        }
        return Collections.emptyList();
    }

    public void registerNamespaces(NamespaceSupport namespaces) {
    }

    public void encode(ExtendedCapabilitiesProvider.Translator tx, WMSInfo wms, GetCapabilitiesRequest request) throws IOException {
        if (!this.gwc.getConfig().isDirectWMSIntegrationEnabled()) {
            return;
        }
        Version version = WMS.version((String)request.getVersion(), (boolean)true);
        if (!WMS.VERSION_1_1_1.equals((Object)version) || !this.isTiled(request)) {
            return;
        }
        String namespacePrefixFilter = request.getNamespace();
        Iterable<? extends TileLayer> tileLayers = this.gwc.getTileLayersByNamespacePrefix(namespacePrefixFilter);
        WorkspaceInfo localWorkspace = LocalWorkspace.get();
        String nsPrefix = localWorkspace == null ? null : localWorkspace.getName() + ":";
        for (TileLayer tileLayer : tileLayers) {
            String advertisedName = tileLayer.getName();
            if (nsPrefix != null) {
                if (!advertisedName.startsWith(nsPrefix)) continue;
                advertisedName = advertisedName.substring(nsPrefix.length());
            }
            for (String gridSetId : tileLayer.getGridSubsets()) {
                GridSubset grid = tileLayer.getGridSubset(gridSetId);
                for (MimeType mime : tileLayer.getMimeTypes()) {
                    this.vendorSpecificTileset(tx, tileLayer, advertisedName, grid, mime.getFormat());
                }
            }
        }
    }

    private void vendorSpecificTileset(ExtendedCapabilitiesProvider.Translator tx, TileLayer layer, String advertisedLayerName, GridSubset grid, String format) {
        String srsStr = grid.getSRS().toString();
        StringBuilder resolutionsStr = new StringBuilder();
        double[] res = grid.getResolutions();
        for (int i = 0; i < res.length; ++i) {
            resolutionsStr.append(Double.toString(res[i]) + " ");
        }
        String[] bs = this.boundsPrep(grid.getCoverageBestFitBounds());
        tx.start("TileSet");
        tx.start("SRS");
        tx.chars(srsStr);
        tx.end("SRS");
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "SRS", "SRS", "", srsStr);
        atts.addAttribute("", "minx", "minx", "", bs[0]);
        atts.addAttribute("", "miny", "miny", "", bs[1]);
        atts.addAttribute("", "maxx", "maxx", "", bs[2]);
        atts.addAttribute("", "maxy", "maxy", "", bs[3]);
        tx.start("BoundingBox", (Attributes)atts);
        tx.end("BoundingBox");
        tx.start("Resolutions");
        tx.chars(resolutionsStr.toString());
        tx.end("Resolutions");
        tx.start("Width");
        tx.chars(String.valueOf(grid.getTileWidth()));
        tx.end("Width");
        tx.start("Height");
        tx.chars(String.valueOf(grid.getTileHeight()));
        tx.end("Height");
        tx.start("Format");
        tx.chars(format);
        tx.end("Format");
        tx.start("Layers");
        tx.chars(advertisedLayerName);
        tx.end("Layers");
        tx.start("Styles");
        tx.end("Styles");
        tx.end("TileSet");
    }

    String[] boundsPrep(BoundingBox bbox) {
        String[] bs = new String[]{Double.toString(bbox.getMinX()), Double.toString(bbox.getMinY()), Double.toString(bbox.getMaxX()), Double.toString(bbox.getMaxY())};
        return bs;
    }

    public void customizeRootCrsList(Set<String> srs) {
    }

    public NumberRange<Double> overrideScaleDenominators(LayerInfo layer, NumberRange<Double> scaleDenominators) {
        return scaleDenominators;
    }
}

