/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.GeoServerTileLayerInfoImpl;
import org.geoserver.gwc.layer.LegacyTileLayerInfoLoader;
import org.geoserver.gwc.layer.StyleParameterFilter;
import org.geowebcache.config.XMLGridSubset;
import org.geowebcache.filter.parameters.FloatParameterFilter;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.parameters.RegexParameterFilter;
import org.geowebcache.filter.parameters.StringParameterFilter;

public class TileLayerInfoUtil {
    public static GeoServerTileLayerInfo loadOrCreate(CatalogInfo info, GWCConfig defaults) {
        if (info instanceof LayerInfo) {
            return TileLayerInfoUtil.loadOrCreate((LayerInfo)info, defaults);
        }
        if (info instanceof LayerGroupInfo) {
            return TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)info, defaults);
        }
        throw new IllegalArgumentException();
    }

    public static GeoServerTileLayerInfoImpl loadOrCreate(LayerGroupInfo groupInfo, GWCConfig defaults) {
        GeoServerTileLayerInfoImpl info = LegacyTileLayerInfoLoader.load(groupInfo);
        if (info == null) {
            info = TileLayerInfoUtil.create(defaults);
            TileLayerInfoUtil.checkAutomaticStyles(groupInfo, (GeoServerTileLayerInfo)info);
        }
        info.setName(GWC.tileLayerName(groupInfo));
        info.setId(groupInfo.getId());
        return info;
    }

    public static GeoServerTileLayerInfoImpl loadOrCreate(LayerInfo layerInfo, GWCConfig defaults) {
        GeoServerTileLayerInfoImpl info = LegacyTileLayerInfoLoader.load(layerInfo);
        if (info == null) {
            info = TileLayerInfoUtil.create(defaults);
            ResourceInfo resource = layerInfo.getResource();
            if (resource instanceof FeatureTypeInfo) {
                info.getMimeFormats().clear();
                info.getMimeFormats().addAll(defaults.getDefaultVectorCacheFormats());
            } else if (resource instanceof CoverageInfo) {
                info.getMimeFormats().clear();
                info.getMimeFormats().addAll(defaults.getDefaultCoverageCacheFormats());
            }
            TileLayerInfoUtil.checkAutomaticStyles(layerInfo, (GeoServerTileLayerInfo)info);
        }
        info.setName(GWC.tileLayerName(layerInfo));
        info.setId(layerInfo.getId());
        return info;
    }

    public static GeoServerTileLayerInfoImpl create(GWCConfig defaults) {
        GeoServerTileLayerInfoImpl info = new GeoServerTileLayerInfoImpl();
        info.setEnabled(defaults.isCacheLayersByDefault());
        info.setAutoCacheStyles(defaults.isCacheNonDefaultStyles());
        for (String gsetId : defaults.getDefaultCachingGridSetIds()) {
            XMLGridSubset subset = new XMLGridSubset();
            subset.setGridSetName(gsetId);
            info.getGridSubsets().add(subset);
        }
        info.getMimeFormats().addAll(defaults.getDefaultOtherCacheFormats());
        info.setGutter(defaults.getGutter());
        info.setMetaTilingX(defaults.getMetaTilingX());
        info.setMetaTilingY(defaults.getMetaTilingY());
        info.setInMemoryCached(true);
        return info;
    }

    public static void addAutoStyleParameterFilter(LayerInfo layer, GeoServerTileLayerInfo layerInfo) {
        StyleParameterFilter filter = new StyleParameterFilter();
        filter.setLayer(layer);
        layerInfo.removeParameterFilter("STYLES");
        layerInfo.getParameterFilters().add(filter);
    }

    public static void checkAutomaticStyles(PublishedInfo published, GeoServerTileLayerInfo layerInfo) {
        if (published instanceof LayerInfo) {
            TileLayerInfoUtil.checkAutomaticStyles((LayerInfo)published, layerInfo);
        } else if (published instanceof LayerGroupInfo) {
            TileLayerInfoUtil.checkAutomaticStyles((LayerGroupInfo)published, layerInfo);
        } else {
            throw new IllegalArgumentException("Do not know how to handle this kind of PublishedInfo: " + published);
        }
    }

    public static void checkAutomaticStyles(LayerInfo layer, GeoServerTileLayerInfo layerInfo) {
        ParameterFilter filter = layerInfo.getParameterFilter("STYLES");
        if (filter != null && filter instanceof StyleParameterFilter) {
            ((StyleParameterFilter)filter).setLayer(layer);
        }
    }

    public static void checkAutomaticStyles(LayerGroupInfo layer, GeoServerTileLayerInfo layerInfo) {
        ParameterFilter filter = layerInfo.getParameterFilter("STYLES");
        if (filter != null && filter instanceof StyleParameterFilter) {
            layerInfo.removeParameterFilter("STYLES");
        }
    }

    public static ParameterFilter findParameterFilter(String paramName, Set<ParameterFilter> parameterFilters) {
        if (parameterFilters == null || parameterFilters.size() == 0) {
            return null;
        }
        for (ParameterFilter pf : parameterFilters) {
            if (!paramName.equalsIgnoreCase(pf.getKey())) continue;
            return pf;
        }
        return null;
    }

    public static void setCachedStyles(GeoServerTileLayerInfo info, String defaultStyle, Set<String> cachedStyles) {
        StyleParameterFilter filter = (StyleParameterFilter)info.getParameterFilter("STYLES");
        if (filter == null) {
            filter = new StyleParameterFilter();
        }
        filter.setDefaultValue(defaultStyle);
        filter.setStyles(cachedStyles);
        info.addParameterFilter(filter);
    }

    public static void updateStringParameterFilter(GeoServerTileLayerInfo tileLayerInfo, String paramKey, boolean createParam, String defaultValue, String ... allowedValues) {
        HashSet<String> validValues = new HashSet<String>();
        if (allowedValues != null) {
            validValues.addAll(Arrays.asList(allowedValues));
        }
        TileLayerInfoUtil.updateStringParameterFilter(tileLayerInfo, paramKey, createParam, defaultValue, validValues);
    }

    public static void updateStringParameterFilter(GeoServerTileLayerInfo tileLayerInfo, String paramKey, boolean createParam, String defaultValue, Set<String> allowedValues) {
        if ((createParam |= tileLayerInfo.removeParameterFilter(paramKey)) && allowedValues != null && allowedValues.size() > 0) {
            TreeSet<String> values = new TreeSet<String>(allowedValues);
            StringParameterFilter stringListFilter = new StringParameterFilter();
            stringListFilter.setKey(paramKey);
            stringListFilter.setDefaultValue(defaultValue == null ? "" : defaultValue);
            values.addAll(stringListFilter.getValues());
            stringListFilter.setValues(new ArrayList<String>(values));
            tileLayerInfo.addParameterFilter((ParameterFilter)stringListFilter);
        }
    }

    public static boolean removeParameterFilter(GeoServerTileLayerInfo tileLayerInfo, String paramKey) {
        return tileLayerInfo.removeParameterFilter(paramKey);
    }

    public static void updateAcceptAllRegExParameterFilter(GeoServerTileLayerInfo tileLayerInfo, String paramKey, boolean createParam) {
        if (createParam |= tileLayerInfo.removeParameterFilter(paramKey)) {
            RegexParameterFilter filter = new RegexParameterFilter();
            filter.setKey(paramKey);
            filter.setDefaultValue("");
            filter.setRegex(".*");
            tileLayerInfo.addParameterFilter((ParameterFilter)filter);
        }
    }

    public static void updateAcceptAllFloatParameterFilter(GeoServerTileLayerInfo tileLayerInfo, String paramKey, boolean createParam) {
        if (createParam |= tileLayerInfo.removeParameterFilter(paramKey)) {
            FloatParameterFilter filter = new FloatParameterFilter();
            filter.setKey(paramKey);
            filter.setDefaultValue("");
            tileLayerInfo.addParameterFilter((ParameterFilter)filter);
        }
    }
}

