/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.gwc.layer.GeoServerTileLayerInfoImpl;
import org.geotools.util.logging.Logging;
import org.geowebcache.filter.parameters.ParameterException;
import org.geowebcache.filter.parameters.ParameterFilter;

@XStreamAlias(value="styleParameterFilter")
public class StyleParameterFilter
extends ParameterFilter {
    private static final Logger LOGGER = Logging.getLogger(GeoServerTileLayerInfoImpl.class);
    private Set<String> allowedStyles;
    private Set<String> availableStyles;
    private String defaultStyle;
    private static final long serialVersionUID = 1L;

    protected void checkInitialized() {
        Preconditions.checkState((this.availableStyles != null ? 1 : 0) != 0, (Object)"Current styles of layer not available.");
    }

    public StyleParameterFilter() {
        super("STYLES");
    }

    public String getDefaultValue() {
        this.checkInitialized();
        String name = super.getDefaultValue();
        if (name.isEmpty()) {
            if (this.defaultStyle == null) {
                return "";
            }
            return this.defaultStyle;
        }
        return name;
    }

    public boolean applies(String parameterValue) {
        this.checkInitialized();
        return parameterValue == null || this.getLegalValues().contains(parameterValue);
    }

    public String apply(String str) throws ParameterException {
        this.checkInitialized();
        if (str == null || str.isEmpty()) {
            return this.getDefaultValue();
        }
        for (String value : this.getLegalValues()) {
            if (!value.equalsIgnoreCase(str)) continue;
            return value;
        }
        throw new ParameterException(str);
    }

    public void setKey(String key) {
        Preconditions.checkArgument((boolean)key.equalsIgnoreCase("STYLES"));
    }

    public void setDefaultValue(String defaultValue) {
        if (defaultValue == null) {
            defaultValue = "";
        }
        if (!defaultValue.isEmpty() && this.availableStyles != null && !this.availableStyles.contains(defaultValue)) {
            LOGGER.log(Level.WARNING, "Selected default style " + defaultValue + " is not in the available styles " + this.availableStyles + ".");
        }
        super.setDefaultValue(defaultValue);
    }

    public String getRealDefault() {
        return super.getDefaultValue();
    }

    public void setRealDefault(String s) {
        this.setDefaultValue(s);
    }

    public StyleParameterFilter clone() {
        StyleParameterFilter clone = new StyleParameterFilter();
        clone.setDefaultValue(super.getDefaultValue());
        clone.setKey(this.getKey());
        clone.allowedStyles = this.getStyles();
        clone.availableStyles = this.availableStyles;
        clone.defaultStyle = this.defaultStyle;
        return clone;
    }

    public Set<String> getLayerStyles() {
        this.checkInitialized();
        return this.availableStyles;
    }

    public List<String> getLegalValues() {
        this.checkInitialized();
        Set<String> layerStyles = this.getLayerStyles();
        if (this.allowedStyles == null) {
            return new ArrayList<String>(layerStyles);
        }
        return new ArrayList<String>((Collection<String>)Sets.intersection(layerStyles, this.allowedStyles));
    }

    public void setLayer(LayerInfo layer) {
        this.availableStyles = new TreeSet<String>();
        for (StyleInfo style : layer.getStyles()) {
            this.availableStyles.add(style.prefixedName());
        }
        this.defaultStyle = layer.getDefaultStyle() != null ? layer.getDefaultStyle().prefixedName() : null;
    }

    @Nullable
    public Set<String> getStyles() {
        if (this.allowedStyles == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.allowedStyles);
    }

    public void setStyles(@Nullable Set<String> styles) {
        this.allowedStyles = styles == null ? null : new TreeSet<String>(styles);
    }

    protected ParameterFilter readResolve() {
        super.readResolve();
        Preconditions.checkState((boolean)this.getKey().equalsIgnoreCase("STYLES"), (Object)"StyleParameterFilter must have a key of \"STYLES\"");
        return this;
    }
}

