/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.dispatch;

import com.google.common.collect.ImmutableList;
import com.vividsolutions.jts.geom.Envelope;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.impl.ServiceInfoImpl;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.dispatch.GwcOperationProxy;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.ows.util.KvpMap;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.kvp.BBoxKvpParser;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.Version;
import org.geowebcache.GeoWebCacheDispatcher;
import org.geowebcache.GeoWebCacheExtensions;

public class GwcServiceProxy {
    private final ServiceInfoImpl serviceInfo = new ServiceInfoImpl();
    private final GeoWebCacheDispatcher gwcDispatcher;

    public GwcServiceProxy() {
        this.serviceInfo.setId("gwc");
        this.serviceInfo.setName("gwc");
        this.serviceInfo.setEnabled(true);
        this.serviceInfo.setVersions((List)ImmutableList.of((Object)new Version("1.0.0")));
        this.gwcDispatcher = (GeoWebCacheDispatcher)GeoWebCacheExtensions.bean(GeoWebCacheDispatcher.class);
    }

    public ServiceInfo getServiceInfo() {
        return this.serviceInfo;
    }

    public GwcOperationProxy dispatch(HttpServletRequest rawRequest, HttpServletResponse rawRespose) throws Exception {
        ResponseWrapper responseWrapper = new ResponseWrapper(rawRespose);
        if (GWC.get().getConfig().isSecurityEnabled()) {
            this.verifyAccess(rawRequest);
        }
        this.gwcDispatcher.handleRequest(rawRequest, (HttpServletResponse)responseWrapper);
        String contentType = responseWrapper.getContentType();
        Map<String, String> headers = responseWrapper.getHeaders();
        byte[] bytes = responseWrapper.out.getBytes();
        return new GwcOperationProxy(contentType, headers, bytes);
    }

    public void verifyAccess(HttpServletRequest rawRequest) throws org.geotools.ows.ServiceException {
        block16: {
            String layerstr;
            KvpMap parameters;
            block17: {
                block15: {
                    String[] layers;
                    parameters = KvpUtils.normalize((Map)rawRequest.getParameterMap());
                    if (!rawRequest.getPathInfo().toLowerCase().startsWith("/service/wms")) break block15;
                    ((Request)Dispatcher.REQUEST.get()).setService("wms");
                    ((Request)Dispatcher.REQUEST.get()).setRequest((String)parameters.get("REQUEST"));
                    String layerstr2 = (String)parameters.get("LAYERS");
                    String bboxstr = (String)parameters.get("BBOX");
                    String srs = (String)parameters.get("SRS");
                    if (layerstr2 == null) break block16;
                    ReferencedEnvelope bbox = null;
                    try {
                        bbox = (ReferencedEnvelope)new BBoxKvpParser().parse(bboxstr);
                    }
                    catch (Exception e) {
                        throw new ServiceException("Invalid bbox: " + bboxstr, (Throwable)e, "MissingOrInvalidParameter");
                    }
                    if (srs != null) {
                        try {
                            bbox = new ReferencedEnvelope((Envelope)bbox, CRS.decode((String)srs));
                        }
                        catch (Exception e) {
                            throw new ServiceException("Invalid srs: " + srs, (Throwable)e, "MissingOrInvalidParameter");
                        }
                    }
                    for (String layerName : layers = layerstr2.split(",")) {
                        layerName = layerName.trim();
                        GWC.get().verifyAccessLayer(layerName, bbox);
                    }
                    break block16;
                }
                if (!rawRequest.getPathInfo().toLowerCase().startsWith("/service/wmts")) break block17;
                String layer = (String)parameters.get("LAYER");
                if (layer == null) break block16;
                GWC.get().verifyAccessLayer(layer, null);
                break block16;
            }
            if (rawRequest.getPathInfo().toLowerCase().startsWith("/service/tms/1.0.0/")) {
                String layer = rawRequest.getPathInfo().toLowerCase().substring("/service/tms/1.0.0/".length());
                if (layer.indexOf(47) >= 0) {
                    layer = layer.substring(0, layer.indexOf(47));
                }
                if (layer.indexOf(64) >= 0) {
                    layer = layer.substring(0, layer.indexOf(64));
                }
                GWC.get().verifyAccessLayer(layer, null);
            } else if (rawRequest.getPathInfo().toLowerCase().startsWith("/service/kml/")) {
                String layer = rawRequest.getPathInfo().toLowerCase().substring("/service/kml/".length());
                if (layer.indexOf(46) >= 0) {
                    layer = layer.substring(0, layer.indexOf(46));
                }
                GWC.get().verifyAccessLayer(layer, null);
            } else if ((rawRequest.getPathInfo().toLowerCase().startsWith("/service/gmaps") || rawRequest.getPathInfo().toLowerCase().startsWith("/service/ve")) && (layerstr = (String)parameters.get("LAYERS")) != null) {
                String[] layers;
                for (String layerName : layers = layerstr.split(",")) {
                    layerName = layerName.trim();
                    GWC.get().verifyAccessLayer(layerName, null);
                }
            }
        }
    }

    private static class BufferedServletOutputStream
    extends ServletOutputStream {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(4096);

        private BufferedServletOutputStream() {
        }

        public void write(int b) throws IOException {
            this.outputStream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.outputStream.write(b, off, len);
        }

        public byte[] getBytes() {
            return this.outputStream.toByteArray();
        }
    }

    private final class ResponseWrapper
    extends HttpServletResponseWrapper {
        final BufferedServletOutputStream out;
        Map<String, String> headers;

        private ResponseWrapper(HttpServletResponse response) {
            super(response);
            this.out = new BufferedServletOutputStream();
            this.headers = new LinkedHashMap<String, String>();
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return this.out;
        }

        public void setHeader(String name, String value) {
            this.headers.put(name, value);
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }
    }
}

