/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.password.ConfigurationPasswordEncryptionHelper;
import org.geotools.util.logging.Logging;
import org.geowebcache.diskquota.jdbc.JDBCConfiguration;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;

class JDBCPasswordEncryptionHelper {
    static final Logger LOGGER = Logging.getLogger(JDBCPasswordEncryptionHelper.class);
    private ConfigurationPasswordEncryptionHelper passwords;

    public JDBCPasswordEncryptionHelper(GeoServerSecurityManager securityManager) {
        this.passwords = securityManager.getConfigPasswordEncryptionHelper();
    }

    public JDBCConfiguration unencryptPassword(JDBCConfiguration configuration) {
        if (configuration.getConnectionPool() != null && configuration.getConnectionPool().getPassword() != null) {
            String password = configuration.getConnectionPool().getPassword();
            try {
                String decoded = this.passwords.decode(password);
                configuration = this.cloneAndSetPassword(configuration, decoded);
            }
            catch (EncryptionOperationNotPossibleException e) {
                LOGGER.log(Level.FINE, "Unencrypting the password failed, assuming it is a plain text one", e);
            }
        }
        return configuration;
    }

    public JDBCConfiguration encryptPassword(JDBCConfiguration configuration) {
        JDBCConfiguration.ConnectionPoolConfiguration pool = configuration.getConnectionPool();
        if (pool != null && pool.getPassword() != null) {
            String password = pool.getPassword();
            String encoded = this.passwords.encode(password);
            configuration = this.cloneAndSetPassword(configuration, encoded);
        }
        return configuration;
    }

    private JDBCConfiguration cloneAndSetPassword(JDBCConfiguration configuration, String encoded) {
        JDBCConfiguration.ConnectionPoolConfiguration original = configuration.getConnectionPool();
        JDBCConfiguration.ConnectionPoolConfiguration clone = new JDBCConfiguration.ConnectionPoolConfiguration();
        clone.setConnectionTimeout(original.getConnectionTimeout());
        clone.setDriver(original.getDriver());
        clone.setMaxConnections(original.getMaxConnections());
        clone.setMaxOpenPreparedStatements(original.getMaxOpenPreparedStatements());
        clone.setMinConnections(original.getMinConnections());
        clone.setPassword(encoded);
        clone.setUrl(original.getUrl());
        clone.setUsername(original.getUsername());
        clone.setValidationQuery(original.getValidationQuery());
        JDBCConfiguration result = new JDBCConfiguration();
        result.setConnectionPool(clone);
        result.setDialect(configuration.getDialect());
        result.setJNDISource(configuration.getJNDISource());
        return result;
    }
}

