/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.gwc.JDBCPasswordEncryptionHelper;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.SecurityManagerListener;
import org.geotools.util.logging.Logging;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.diskquota.DiskQuotaConfig;
import org.geowebcache.diskquota.QuotaStore;
import org.geowebcache.diskquota.jdbc.JDBCConfiguration;
import org.geowebcache.diskquota.jdbc.JDBCQuotaStoreFactory;
import org.geowebcache.storage.DefaultStorageFinder;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

class JDBCConfigurationStorage
implements ApplicationContextAware,
SecurityManagerListener {
    static final Logger LOGGER = Logging.getLogger(JDBCConfigurationStorage.class);
    private JDBCPasswordEncryptionHelper passwordHelper;
    private DefaultStorageFinder storageFinder;
    private ApplicationContext applicationContext;

    public JDBCConfigurationStorage(DefaultStorageFinder storageFinder, GeoServerSecurityManager securityManager) {
        this.storageFinder = storageFinder;
        this.passwordHelper = new JDBCPasswordEncryptionHelper(securityManager);
        securityManager.addListener((SecurityManagerListener)this);
    }

    public synchronized void saveDiskQuotaConfig(DiskQuotaConfig config, JDBCConfiguration jdbcConfig) throws ConfigurationException, IOException, InterruptedException {
        File configFile = new File(this.storageFinder.getDefaultPath(), "geowebcache-diskquota-jdbc.xml");
        if ("JDBC".equals(config.getQuotaStore())) {
            JDBCConfiguration encrypted = this.passwordHelper.encryptPassword(jdbcConfig);
            JDBCConfiguration.store((JDBCConfiguration)encrypted, (File)configFile);
        } else if (configFile.exists() && !configFile.delete()) {
            LOGGER.log(Level.SEVERE, "Failed to delete " + configFile + ", this might cause misbehavior on GeoServer restart");
        }
    }

    public synchronized JDBCConfiguration getJDBCDiskQuotaConfig() throws IOException, ConfigurationException {
        File configFile = new File(this.storageFinder.getDefaultPath(), "geowebcache-diskquota-jdbc.xml");
        if (!configFile.exists()) {
            return null;
        }
        try {
            JDBCConfiguration configuration = JDBCConfiguration.load((File)configFile);
            return this.passwordHelper.unencryptPassword(configuration);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to load geowebcache-diskquota-jdbc.xml", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQuotaConfiguration(JDBCConfiguration jdbcConfiguration) throws ConfigurationException, IOException {
        JDBCQuotaStoreFactory factory = (JDBCQuotaStoreFactory)GeoServerExtensions.bean(JDBCQuotaStoreFactory.class);
        QuotaStore qs = null;
        try {
            qs = factory.getJDBCStore(this.applicationContext, jdbcConfiguration);
        }
        finally {
            if (qs != null) {
                try {
                    qs.close();
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "Failed to dispose test quota store", e);
                }
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void handlePostChanged(GeoServerSecurityManager securityManager) {
        try {
            JDBCConfiguration config = this.getJDBCDiskQuotaConfig();
            if (config != null) {
                File configFile = new File(this.storageFinder.getDefaultPath(), "geowebcache-diskquota-jdbc.xml");
                if (!configFile.exists()) {
                    return;
                }
                JDBCConfiguration c1 = JDBCConfiguration.load((File)configFile);
                if (c1 == null || c1.getConnectionPool() == null) {
                    return;
                }
                String originalEncrypted = c1.getConnectionPool().getPassword();
                if (originalEncrypted == null) {
                    return;
                }
                JDBCConfiguration c2 = this.passwordHelper.unencryptPassword(c1);
                JDBCConfiguration c3 = this.passwordHelper.encryptPassword(c2);
                String newEncrypted = c3.getConnectionPool().getPassword();
                if (!originalEncrypted.equals(newEncrypted)) {
                    JDBCConfiguration.store((JDBCConfiguration)c3, (File)configFile);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

