/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.vividsolutions.jts.densify.Densifier;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupHelper;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.gwc.ConfigurableLockProvider;
import org.geoserver.gwc.ConfigurableQuotaStoreProvider;
import org.geoserver.gwc.FakeHttpServletRequest;
import org.geoserver.gwc.FakeHttpServletResponse;
import org.geoserver.gwc.JDBCConfigurationStorage;
import org.geoserver.gwc.JDBCPasswordEncryptionHelper;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.config.GWCConfigPersister;
import org.geoserver.gwc.layer.CatalogConfiguration;
import org.geoserver.gwc.layer.CatalogLayerEventListener;
import org.geoserver.gwc.layer.CatalogStyleChangeListener;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Response;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CoverageAccessLimits;
import org.geoserver.security.DataAccessLimits;
import org.geoserver.security.WMSAccessLimits;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.SecuredLayerInfo;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.map.RenderedImageMap;
import org.geotools.filter.visitor.ExtractBoundsFilterVisitor;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.ows.ServiceException;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.config.BlobStoreConfig;
import org.geowebcache.config.Configuration;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.config.XMLGridSet;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.diskquota.DiskQuotaConfig;
import org.geowebcache.diskquota.DiskQuotaMonitor;
import org.geowebcache.diskquota.QuotaStore;
import org.geowebcache.diskquota.jdbc.JDBCConfiguration;
import org.geowebcache.diskquota.storage.LayerQuota;
import org.geowebcache.diskquota.storage.Quota;
import org.geowebcache.diskquota.storage.TileSet;
import org.geowebcache.diskquota.storage.TileSetVisitor;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.grid.GridSubsetFactory;
import org.geowebcache.grid.GridUtil;
import org.geowebcache.grid.SRS;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.locks.LockProvider;
import org.geowebcache.locks.MemoryLockProvider;
import org.geowebcache.mime.MimeException;
import org.geowebcache.mime.MimeType;
import org.geowebcache.seed.GWCTask;
import org.geowebcache.seed.SeedRequest;
import org.geowebcache.seed.TileBreeder;
import org.geowebcache.storage.CompositeBlobStore;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileRange;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class GWC
implements DisposableBean,
InitializingBean,
ApplicationContextAware {
    private static final String GLOBAL_LOCK_KEY = "global";
    public static final String WORKSPACE_PARAM = "WORKSPACE";
    private static GWC INSTANCE;
    static final Logger log;
    private static Map<String, Response> cachedTileEncoders;
    private final TileLayerDispatcher tld;
    private final StorageBroker storageBroker;
    private final TileBreeder tileBreeder;
    private final GWCConfigPersister gwcConfigPersister;
    private final Dispatcher owsDispatcher;
    private final GridSetBroker gridSetBroker;
    private DiskQuotaMonitor monitor;
    private CatalogLayerEventListener catalogLayerEventListener;
    private CatalogStyleChangeListener catalogStyleChangeListener;
    private final Catalog rawCatalog;
    private ConfigurableLockProvider lockProvider;
    private DefaultStorageFinder storageFinder;
    private ApplicationContext applicationContext;
    private JDBCPasswordEncryptionHelper passwordHelper;
    private JDBCConfigurationStorage jdbcConfigurationStorage;

    public GWC(GWCConfigPersister gwcConfigPersister, StorageBroker sb, TileLayerDispatcher tld, GridSetBroker gridSetBroker, TileBreeder tileBreeder, DiskQuotaMonitor monitor, Dispatcher owsDispatcher, Catalog rawCatalog, DefaultStorageFinder storageFinder, JDBCConfigurationStorage jdbcConfigurationStorage) {
        this.gwcConfigPersister = gwcConfigPersister;
        this.tld = tld;
        this.storageBroker = sb;
        this.gridSetBroker = gridSetBroker;
        this.tileBreeder = tileBreeder;
        this.monitor = monitor;
        this.owsDispatcher = owsDispatcher;
        this.rawCatalog = rawCatalog;
        this.storageFinder = storageFinder;
        this.catalogLayerEventListener = new CatalogLayerEventListener(this, rawCatalog);
        this.catalogStyleChangeListener = new CatalogStyleChangeListener(this, rawCatalog);
        this.rawCatalog.addListener((CatalogListener)this.catalogLayerEventListener);
        this.rawCatalog.addListener((CatalogListener)this.catalogStyleChangeListener);
        this.lockProvider = new ConfigurableLockProvider();
        this.updateLockProvider(this.getConfig().getLockProviderName());
        this.jdbcConfigurationStorage = jdbcConfigurationStorage;
    }

    private void updateLockProvider(String lockProviderName) {
        MemoryLockProvider delegate = null;
        if (lockProviderName == null) {
            delegate = new MemoryLockProvider();
        } else {
            Object provider = GeoWebCacheExtensions.bean((String)lockProviderName);
            if (provider == null) {
                throw new RuntimeException("Could not find lock provider " + this.lockProvider + " in the spring application context");
            }
            if (!(provider instanceof LockProvider)) {
                throw new RuntimeException("Found bean " + this.lockProvider + " in the spring application context, but it was not a LockProvider");
            }
            delegate = (LockProvider)provider;
        }
        this.lockProvider.setDelegate((LockProvider)delegate);
    }

    public static synchronized GWC get() {
        if (INSTANCE == null && (INSTANCE = (GWC)GeoServerExtensions.bean(GWC.class)) == null) {
            throw new IllegalStateException("No bean of type " + GWC.class.getName() + " found by GeoServerExtensions");
        }
        return INSTANCE;
    }

    public static void set(GWC instance) {
        INSTANCE = instance;
    }

    public void afterPropertiesSet() throws Exception {
        GWC.set(this);
    }

    public void destroy() throws Exception {
        Catalog catalog = this.getCatalog();
        if (this.catalogLayerEventListener != null) {
            catalog.removeListener((CatalogListener)this.catalogLayerEventListener);
        }
        if (this.catalogStyleChangeListener != null) {
            catalog.removeListener((CatalogListener)this.catalogStyleChangeListener);
        }
        GWC.set(null);
    }

    public Catalog getCatalog() {
        return this.rawCatalog;
    }

    public GWCConfig getConfig() {
        return this.gwcConfigPersister.getConfig();
    }

    public void truncate(String layerName) {
        TileLayer layer;
        Preconditions.checkNotNull((Object)layerName, (Object)"layerName is null");
        try {
            layer = this.tld.getTileLayer(layerName);
        }
        catch (GeoWebCacheException e) {
            log.log(Level.INFO, e.getMessage(), e);
            return;
        }
        Set gridSubsets = layer.getGridSubsets();
        for (String gridSetId : gridSubsets) {
            this.deleteCacheByGridSetId(layerName, gridSetId);
        }
    }

    public void truncateByLayerAndStyle(String layerName, String styleName) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Truncate for layer/style called. Checking if style '" + styleName + "' is cached for layer '" + layerName + "'");
        }
        if (!this.isStyleCached(layerName, styleName)) {
            log.fine("Style '" + styleName + "' is not cached for layer " + layerName + "'. No need to truncate.");
            return;
        }
        log.fine("truncating '" + layerName + "' for style '" + styleName + "'");
        String gridSetId = null;
        BoundingBox bounds = null;
        String format = null;
        this.truncate(layerName, styleName, gridSetId, bounds, format);
    }

    public void truncate(String layerName, ReferencedEnvelope bounds) throws GeoWebCacheException {
        TileLayer tileLayer = this.tld.getTileLayer(layerName);
        Set gridSubSets = tileLayer.getGridSubsets();
        for (String gridSetId : gridSubSets) {
            GridSubset layerGrid = tileLayer.getGridSubset(gridSetId);
            BoundingBox intersectingBounds = this.getIntersectingBounds(layerName, layerGrid, bounds);
            if (intersectingBounds == null) continue;
            String styleName = null;
            String format = null;
            this.truncate(layerName, styleName, gridSetId, intersectingBounds, format);
        }
    }

    private BoundingBox getIntersectingBounds(String layerName, GridSubset layerGrid, ReferencedEnvelope bounds) {
        ReferencedEnvelope truncateBoundsInGridsetCrs;
        CoordinateReferenceSystem gridSetCrs;
        GridSet gridSet = layerGrid.getGridSet();
        String gridSetId = gridSet.getName();
        SRS srs = gridSet.getSrs();
        try {
            gridSetCrs = CRS.decode((String)("EPSG:" + srs.getNumber()), (boolean)true);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't decode SRS for layer '" + layerName + "': ESPG:" + srs.getNumber());
        }
        try {
            truncateBoundsInGridsetCrs = bounds.transform(gridSetCrs, true);
        }
        catch (Exception e) {
            log.warning("Can't truncate layer " + layerName + ": error transforming requested bounds to layer gridset " + gridSetId + ": " + e.getMessage());
            return null;
        }
        double minx = truncateBoundsInGridsetCrs.getMinX();
        double miny = truncateBoundsInGridsetCrs.getMinY();
        double maxx = truncateBoundsInGridsetCrs.getMaxX();
        double maxy = truncateBoundsInGridsetCrs.getMaxY();
        BoundingBox reqBounds = new BoundingBox(minx, miny, maxx, maxy);
        BoundingBox layerBounds = layerGrid.getOriginalExtent();
        if (!layerBounds.intersects(reqBounds)) {
            log.fine("Requested truncation bounds do not intersect cached layer bounds, ignoring truncate request");
            return null;
        }
        BoundingBox intersectingBounds = BoundingBox.intersection((BoundingBox)layerBounds, (BoundingBox)reqBounds);
        return intersectingBounds;
    }

    public void truncate(String layerName, String styleName, String gridSetName, BoundingBox bounds, String format) {
        List<MimeType> mimeTypes;
        Set<String> styleNames;
        Preconditions.checkNotNull((Object)layerName, (Object)"layerName can't be null");
        TileLayer layer = this.getTileLayerByName(layerName);
        if (styleName == null) {
            styleNames = this.getCachedStyles(layerName);
            if (styleNames.size() == 0) {
                styleNames.add("");
            }
        } else {
            styleNames = Collections.singleton(styleName);
        }
        Set<String> gridSetIds = gridSetName == null ? layer.getGridSubsets() : Collections.singleton(gridSetName);
        if (format == null) {
            mimeTypes = layer.getMimeTypes();
        } else {
            try {
                mimeTypes = Collections.singletonList(MimeType.createFromFormat((String)format));
            }
            catch (MimeException e) {
                throw new RuntimeException();
            }
        }
        String defaultStyle = layer.getStyles();
        for (String gridSetId : gridSetIds) {
            GridSubset gridSubset = layer.getGridSubset(gridSetId);
            if (gridSubset == null) {
                GridSet gridSet = this.gridSetBroker.get(gridSetId);
                gridSubset = GridSubsetFactory.createGridSubSet((GridSet)gridSet);
            }
            for (String style : styleNames) {
                Map<String, String> parameters;
                if (style.length() == 0 || style.equals(defaultStyle)) {
                    log.finer("'" + style + "' is the layer's default style, " + "not adding a parameter filter");
                    parameters = null;
                } else {
                    parameters = Collections.singletonMap("STYLES", style);
                }
                for (MimeType mime : mimeTypes) {
                    String formatName = mime.getFormat();
                    this.truncate(layer, bounds, gridSubset, formatName, parameters);
                }
            }
        }
    }

    private void truncate(TileLayer layer, BoundingBox bounds, GridSubset gridSubset, String formatName, Map<String, String> parameters) {
        GWCTask[] tasks;
        boolean threadCount = true;
        int zoomStart = gridSubset.getZoomStart();
        int zoomStop = gridSubset.getZoomStop();
        GWCTask.TYPE taskType = GWCTask.TYPE.TRUNCATE;
        SeedRequest req = new SeedRequest(layer.getName(), bounds, gridSubset.getName(), 1, zoomStart, zoomStop, formatName, taskType, parameters);
        try {
            TileRange tr = TileBreeder.createTileRange((SeedRequest)req, (TileLayer)layer);
            boolean filterUpdate = false;
            tasks = this.tileBreeder.createTasks(tr, taskType, 1, filterUpdate);
        }
        catch (GeoWebCacheException e) {
            throw new RuntimeException(e);
        }
        this.tileBreeder.dispatchTasks(tasks);
    }

    private boolean isStyleCached(String layerName, String styleName) {
        Set<String> cachedStyles = this.getCachedStyles(layerName);
        boolean styleIsCached = cachedStyles.contains(styleName);
        return styleIsCached;
    }

    private Set<String> getCachedStyles(String layerName) {
        List parameterFilters;
        TileLayer l = this.getTileLayerByName(layerName);
        HashSet<String> cachedStyles = new HashSet<String>();
        String defaultStyle = l.getStyles();
        if (defaultStyle != null) {
            cachedStyles.add(defaultStyle);
        }
        if ((parameterFilters = l.getParameterFilters()) != null) {
            for (ParameterFilter pf : parameterFilters) {
                if (!"STYLES".equalsIgnoreCase(pf.getKey())) continue;
                cachedStyles.add(pf.getDefaultValue());
                cachedStyles.addAll(pf.getLegalValues());
                break;
            }
        }
        return cachedStyles;
    }

    public synchronized boolean layerRemoved(String prefixedName) {
        try {
            return this.storageBroker.delete(prefixedName);
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }

    public static void tryReload() {
        GWC instance = INSTANCE;
        if (instance != null) {
            instance.reload();
        }
    }

    void reload() {
        HashSet<String> currLayerNames = new HashSet<String>(this.getTileLayerNames());
        try {
            this.tld.reInit();
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, "Unable to reinit TileLayerDispatcher", e);
            throw e;
        }
        Set<String> newLayerNames = this.getTileLayerNames();
        Sets.SetView removedExternally = Sets.difference(currLayerNames, newLayerNames);
        for (String removedLayerName : removedExternally) {
            log.info("Notifying of TileLayer '" + removedLayerName + "' removed externally");
            this.layerRemoved(removedLayerName);
        }
        try {
            DiskQuotaMonitor monitor = this.getDiskQuotaMonitor();
            monitor.reloadConfig();
            ConfigurableQuotaStoreProvider provider = (ConfigurableQuotaStoreProvider)monitor.getQuotaStoreProvider();
            provider.reloadQuotaStore();
            monitor.shutDown(1);
            monitor.startUp();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to reload the disk quoa configuration", e);
        }
    }

    public final ConveyorTile dispatch(GetMapRequest request, StringBuilder requestMistmatchTarget) {
        TileLayer tileLayer;
        String layerName = (String)request.getRawKvp().get("LAYERS");
        if (layerName.indexOf(44) != -1) {
            requestMistmatchTarget.append("more than one layer requested");
            return null;
        }
        if (!this.tld.layerExists(layerName)) {
            requestMistmatchTarget.append("not a tile layer");
            return null;
        }
        try {
            tileLayer = this.tld.getTileLayer(layerName);
        }
        catch (GeoWebCacheException e) {
            throw new RuntimeException(e);
        }
        if (!tileLayer.isEnabled()) {
            requestMistmatchTarget.append("tile layer disabled");
            return null;
        }
        ConveyorTile tileReq = this.prepareRequest(tileLayer, request, requestMistmatchTarget);
        if (null == tileReq) {
            return null;
        }
        ConveyorTile tileResp = null;
        try {
            tileResp = tileLayer.getTile(tileReq);
        }
        catch (Exception e) {
            log.log(Level.INFO, "Error dispatching tile request to GeoServer", e);
        }
        return tileResp;
    }

    ConveyorTile prepareRequest(TileLayer tileLayer, GetMapRequest request, StringBuilder requestMistmatchTarget) {
        Map fullParameters;
        long[] tileIndex;
        GridSubset gridSubset;
        MimeType mimeType;
        if (!this.isCachingPossible(tileLayer, request, requestMistmatchTarget)) {
            return null;
        }
        try {
            mimeType = MimeType.createFromFormat((String)request.getFormat());
            List tileLayerFormats = tileLayer.getMimeTypes();
            if (!tileLayerFormats.contains(mimeType)) {
                requestMistmatchTarget.append("no tile cache for requested format");
                return null;
            }
        }
        catch (MimeException me) {
            requestMistmatchTarget.append("not a GWC supported format: ").append(me.getMessage());
            return null;
        }
        try {
            boolean axisFlip = false;
            CoordinateReferenceSystem crs = request.getCrs();
            if (CRS.getAxisOrder((CoordinateReferenceSystem)crs) == CRS.AxisOrder.NORTH_EAST) {
                axisFlip = true;
            }
            String srs = request.getSRS();
            int epsgId = Integer.parseInt(srs.substring(srs.lastIndexOf(58) + 1));
            SRS srs2 = SRS.getSRS((int)epsgId);
            List crsMatchingGridSubsets = tileLayer.getGridSubsetsForSRS(srs2);
            Envelope bbox = request.getBbox();
            BoundingBox tileBounds = axisFlip ? new BoundingBox(bbox.getMinY(), bbox.getMinX(), bbox.getMaxY(), bbox.getMaxX()) : new BoundingBox(bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY());
            if (crsMatchingGridSubsets.isEmpty()) {
                requestMistmatchTarget.append("no cache exists for requested CRS");
                return null;
            }
            long[] matchingTileIndex = new long[3];
            int reqW = request.getWidth();
            int reqH = request.getHeight();
            gridSubset = GridUtil.findBestMatchingGrid((BoundingBox)tileBounds, (List)crsMatchingGridSubsets, (Integer)reqW, (Integer)reqH, (long[])matchingTileIndex);
            if (gridSubset == null) {
                requestMistmatchTarget.append("request does not align to grid(s) ");
                for (GridSubset gs : crsMatchingGridSubsets) {
                    requestMistmatchTarget.append('\'').append(gs.getName()).append("' ");
                }
                return null;
            }
            tileIndex = matchingTileIndex;
            Map requestParameterMap = request.getRawKvp();
            fullParameters = tileLayer.getModifiableParameters(requestParameterMap, "UTF-8");
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINE)) {
                e.printStackTrace();
                log.log(Level.FINE, "Exception caught checking gwc dispatch preconditions", e);
            }
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            requestMistmatchTarget.append("exception occurred: ").append(rootCause.getClass().getSimpleName()).append(": ").append(e.getMessage());
            return null;
        }
        String gridSetId = gridSubset.getName();
        HttpServletRequest servletReq = null;
        HttpServletResponse servletResp = null;
        String layerName = tileLayer.getName();
        ConveyorTile tileReq = new ConveyorTile(this.storageBroker, layerName, gridSetId, tileIndex, mimeType, fullParameters, servletReq, servletResp);
        return tileReq;
    }

    boolean isCachingPossible(TileLayer layer, GetMapRequest request, StringBuilder requestMistmatchTarget) {
        boolean sameFilters;
        Map<String, ParameterFilter> filters;
        if (null != request.getRemoteOwsType() || null != request.getRemoteOwsURL()) {
            requestMistmatchTarget.append("request uses remote OWS");
            return false;
        }
        List parameterFilters = layer.getParameterFilters();
        if (null != parameterFilters && parameterFilters.size() > 0) {
            filters = new HashMap();
            for (ParameterFilter pf : parameterFilters) {
                filters.put(pf.getKey().toUpperCase(), pf);
            }
        } else {
            filters = Collections.emptyMap();
        }
        if (request.getEnv() != null && !request.getEnv().isEmpty() && !this.filterApplies(filters, request, "ENV", requestMistmatchTarget)) {
            return false;
        }
        if (request.getFormatOptions() != null && !request.getFormatOptions().isEmpty() && !this.filterApplies(filters, request, "FORMAT_OPTIONS", requestMistmatchTarget)) {
            return false;
        }
        if (0.0 != request.getAngle() && !this.filterApplies(filters, request, "ANGLE", requestMistmatchTarget)) {
            return false;
        }
        if (null != request.getRawKvp().get("BGCOLOR") && !this.filterApplies(filters, request, "BGCOLOR", requestMistmatchTarget)) {
            return false;
        }
        if (0 != request.getBuffer() && !this.filterApplies(filters, request, "BUFFER", requestMistmatchTarget)) {
            return false;
        }
        if (null != request.getCQLFilter() && !request.getCQLFilter().isEmpty() && !this.filterApplies(filters, request, "CQL_FILTER", requestMistmatchTarget)) {
            return false;
        }
        if (request.getElevation() != null && !request.getElevation().isEmpty() && null != request.getElevation().get(0) && !this.filterApplies(filters, request, "ELEVATION", requestMistmatchTarget)) {
            return false;
        }
        if (null != request.getFeatureId() && !request.getFeatureId().isEmpty() && !this.filterApplies(filters, request, "FEATUREID", requestMistmatchTarget)) {
            return false;
        }
        if (!(null == request.getFilter() || request.getFilter().isEmpty() || (sameFilters = this.checkFilter(request.getFilter(), request.getCQLFilter(), filters)) || this.filterApplies(filters, request, "FILTER", requestMistmatchTarget))) {
            return false;
        }
        if (null != request.getPalette() && !this.filterApplies(filters, request, "PALETTE", requestMistmatchTarget)) {
            return false;
        }
        if (null != request.getStartIndex() && !this.filterApplies(filters, request, "STARTINDEX", requestMistmatchTarget)) {
            return false;
        }
        if (null != request.getMaxFeatures() && !this.filterApplies(filters, request, "MAXFEATURES", requestMistmatchTarget)) {
            return false;
        }
        if (null != request.getTime() && !request.getTime().isEmpty() && null != request.getTime().get(0) && !this.filterApplies(filters, request, "TIME", requestMistmatchTarget)) {
            return false;
        }
        if (null != request.getViewParams() && !request.getViewParams().isEmpty() && !this.filterApplies(filters, request, "VIEWPARAMS", requestMistmatchTarget)) {
            return false;
        }
        return null == request.getFeatureVersion() || this.filterApplies(filters, request, "FEATUREVERSION", requestMistmatchTarget);
    }

    private boolean checkFilter(List filter, List cqlFilter, Map<String, ParameterFilter> filters) {
        if (!filters.containsKey("FILTER")) {
            int size;
            boolean hasCQLFilter;
            boolean hasFilter = filter != null && !filter.isEmpty();
            boolean bl = hasCQLFilter = cqlFilter != null && !cqlFilter.isEmpty();
            if (hasCQLFilter && hasFilter && (size = filter.size()) == cqlFilter.size()) {
                boolean equals = true;
                for (int i = 0; i < size; ++i) {
                    equals &= filter.get(i).equals(cqlFilter.get(i));
                }
                return equals;
            }
        }
        return false;
    }

    private boolean filterApplies(Map<String, ParameterFilter> filters, GetMapRequest request, String key, StringBuilder requestMistmatchTarget) {
        ParameterFilter parameterFilter = filters.get(key);
        if (parameterFilter == null) {
            requestMistmatchTarget.append("no parameter filter exists for ").append(key);
            return false;
        }
        String parameter = (String)request.getRawKvp().get(key);
        boolean applies = parameterFilter.applies(parameter);
        if (!applies) {
            requestMistmatchTarget.append(key).append(" does not apply to parameter filter of the same name");
        }
        return applies;
    }

    public TileLayer getTileLayerByName(String layerName) throws IllegalArgumentException {
        TileLayer tileLayer;
        try {
            tileLayer = this.tld.getTileLayer(layerName);
        }
        catch (GeoWebCacheException e) {
            throw new IllegalArgumentException(e.getMessage(), Throwables.getRootCause((Throwable)e));
        }
        return tileLayer;
    }

    public Set<String> getTileLayerNames() {
        return this.tld.getLayerNames();
    }

    public Iterable<TileLayer> getTileLayers() {
        return this.tld.getLayerList();
    }

    public Iterable<? extends TileLayer> getTileLayersByNamespacePrefix(String nsPrefix) {
        if (nsPrefix == null) {
            return this.getTileLayers();
        }
        final Catalog catalog = this.getCatalog();
        final NamespaceInfo namespaceFilter = catalog.getNamespaceByPrefix(nsPrefix);
        if (namespaceFilter == null) {
            Iterable<TileLayer> tileLayers = this.getTileLayers();
            return tileLayers;
        }
        Iterable<GeoServerTileLayer> geoServerTileLayers = this.getGeoServerTileLayers();
        return Iterables.filter(geoServerTileLayers, (Predicate)new Predicate<GeoServerTileLayer>(){

            public boolean apply(GeoServerTileLayer tileLayer) {
                NamespaceInfo layerNamespace;
                String layerName = tileLayer.getName();
                if (-1 == layerName.indexOf(58)) {
                    return false;
                }
                LayerInfo layerInfo = catalog.getLayerByName(layerName);
                return layerInfo != null && namespaceFilter.equals((Object)(layerNamespace = layerInfo.getResource().getNamespace()));
            }
        });
    }

    public Set<String> getLayerNamesForGridSets(Set<String> gridSetIds) {
        TreeSet<String> layerNames = new TreeSet<String>();
        for (TileLayer layer : this.getTileLayers()) {
            Set layerGrids = layer.getGridSubsets();
            if (Sets.intersection(gridSetIds, (Set)layerGrids).isEmpty()) continue;
            layerNames.add(layer.getName());
        }
        return layerNames;
    }

    public boolean isDiskQuotaAvailable() {
        DiskQuotaMonitor diskQuotaMonitor = this.getDiskQuotaMonitor();
        return diskQuotaMonitor.isEnabled();
    }

    public boolean isDiskQuotaEnabled() {
        DiskQuotaMonitor diskQuotaMonitor = this.getDiskQuotaMonitor();
        return diskQuotaMonitor.getConfig().isEnabled();
    }

    public DiskQuotaConfig getDiskQuotaConfig() {
        if (!this.isDiskQuotaAvailable()) {
            return null;
        }
        DiskQuotaMonitor monitor = this.getDiskQuotaMonitor();
        return monitor.getConfig();
    }

    private DiskQuotaMonitor getDiskQuotaMonitor() {
        return this.monitor;
    }

    public void saveConfig(GWCConfig gwcConfig) throws IOException {
        this.gwcConfigPersister.save(gwcConfig);
        this.updateLockProvider(gwcConfig.getLockProviderName());
    }

    public void saveDiskQuotaConfig(DiskQuotaConfig config, JDBCConfiguration jdbcConfig) throws ConfigurationException, IOException, InterruptedException {
        Preconditions.checkArgument((boolean)this.isDiskQuotaAvailable(), (Object)"DiskQuota is not enabled");
        DiskQuotaMonitor monitor = this.getDiskQuotaMonitor();
        monitor.saveConfig(config);
        this.jdbcConfigurationStorage.saveDiskQuotaConfig(config, jdbcConfig);
        ConfigurableQuotaStoreProvider provider = (ConfigurableQuotaStoreProvider)monitor.getQuotaStoreProvider();
        provider.reloadQuotaStore();
        monitor.shutDown(1);
        monitor.startUp();
    }

    public Quota getGlobalQuota() {
        if (!this.isDiskQuotaAvailable()) {
            return null;
        }
        return this.getDiskQuotaConfig().getGlobalQuota();
    }

    public Quota getGlobalUsedQuota() {
        if (!this.isDiskQuotaAvailable()) {
            return null;
        }
        try {
            return this.monitor.getGloballyUsedQuota();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public Quota getUsedQuotaByGridSet(final String gridSetName) {
        Preconditions.checkNotNull((Object)gridSetName, (Object)"GridSet name is null");
        if (!this.isDiskQuotaAvailable()) {
            return null;
        }
        final Quota quota = new Quota();
        TileSetVisitor visitor = new TileSetVisitor(){

            public void visit(TileSet tileSet, QuotaStore store) {
                if (!gridSetName.equals(tileSet.getGridsetId())) {
                    return;
                }
                String tileSetId = tileSet.getId();
                try {
                    Quota used = store.getUsedQuotaByTileSetId(tileSetId);
                    quota.add(used);
                }
                catch (InterruptedException e) {
                    log.fine(e.getMessage());
                    return;
                }
            }
        };
        this.monitor.getQuotaStore().accept(visitor);
        return quota;
    }

    public Quota getQuotaLimit(String layerName) {
        if (!this.isDiskQuotaAvailable()) {
            return null;
        }
        DiskQuotaConfig disQuotaConfig = this.getDiskQuotaConfig();
        List layerQuotas = disQuotaConfig.getLayerQuotas();
        if (layerQuotas == null) {
            return null;
        }
        for (LayerQuota lq : layerQuotas) {
            if (!layerName.equals(lq.getLayer())) continue;
            return new Quota(lq.getQuota());
        }
        return null;
    }

    public Quota getUsedQuota(String layerName) {
        if (!this.isDiskQuotaAvailable()) {
            return null;
        }
        try {
            Quota usedQuotaByLayerName = this.monitor.getUsedQuotaByLayerName(layerName);
            return usedQuotaByLayerName;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Resource dispatchOwsRequest(Map<String, String> params, Cookie[] cookies) throws Exception {
        String workspace = params.remove(WORKSPACE_PARAM);
        FakeHttpServletRequest req = new FakeHttpServletRequest(params, cookies, workspace);
        FakeHttpServletResponse resp = new FakeHttpServletResponse();
        this.owsDispatcher.handleRequest((HttpServletRequest)req, (HttpServletResponse)resp);
        return new ByteArrayResource(resp.getBytes());
    }

    public void proxyOwsRequest(ConveyorTile tile) throws Exception {
        HttpServletRequest actualRequest = tile.servletReq;
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        Map params = actualRequest.getParameterMap();
        boolean hasService = false;
        for (Map.Entry param : params.entrySet()) {
            String key = (String)param.getKey();
            String value = ((String[])param.getValue())[0];
            parameterMap.put(key, value);
            if (!"service".equalsIgnoreCase(key) || value != null && !value.isEmpty() && "WMS".equalsIgnoreCase(value)) continue;
            throw new GeoWebCacheException("Failed to cascade request, service should be WMS but it was: '" + value + "'");
        }
        if (!hasService) {
            parameterMap.put("service", "WMS");
        }
        Cookie[] cookies = actualRequest.getCookies();
        FakeHttpServletRequest request = new FakeHttpServletRequest(parameterMap, cookies);
        this.owsDispatcher.handleRequest((HttpServletRequest)request, tile.servletResp);
    }

    public GridSetBroker getGridSetBroker() {
        return this.gridSetBroker;
    }

    public List<LayerInfo> getLayerInfos() {
        return this.getCatalog().getLayers();
    }

    public List<LayerGroupInfo> getLayerGroups() {
        return this.getCatalog().getLayerGroups();
    }

    public LayerInfo getLayerInfoById(String layerId) {
        return this.getCatalog().getLayer(layerId);
    }

    public LayerInfo getLayerInfoByName(String layerName) {
        return this.getCatalog().getLayerByName(layerName);
    }

    public LayerGroupInfo getLayerGroupByName(String layerName) {
        return this.getCatalog().getLayerGroupByName(layerName);
    }

    public LayerGroupInfo getLayerGroupById(String id) {
        return this.getCatalog().getLayerGroup(id);
    }

    public void add(GeoServerTileLayer tileLayer) {
        Configuration config = this.tld.addLayer((TileLayer)tileLayer);
        try {
            config.save();
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)Throwables.getRootCause((Throwable)e));
        }
    }

    public void layerAdded(String layerName) {
        if (this.isDiskQuotaAvailable()) {
            try {
                this.monitor.getQuotaStore().createLayer(layerName);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void layerRenamed(String oldLayerName, String newLayerName) {
        try {
            log.info("Renaming GWC TileLayer '" + oldLayerName + "' as '" + newLayerName + "'");
            this.storageBroker.rename(oldLayerName, newLayerName);
        }
        catch (StorageException e) {
            log.log(Level.WARNING, e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public boolean isServiceEnabled(org.geowebcache.service.Service service) {
        return this.getConfig().isEnabled(service.getPathName());
    }

    public boolean tileLayerExists(String layerName) {
        return this.tld.layerExists(layerName);
    }

    public Set<String> getTileLayersByFeatureType(String namespaceURI, String typeName) {
        String tileLayerName;
        NamespaceInfo namespace = namespaceURI == null || "".equals(namespaceURI) ? this.getCatalog().getDefaultNamespace() : this.getCatalog().getNamespaceByURI(namespaceURI);
        FeatureTypeInfo typeInfo = this.getCatalog().getFeatureTypeByName(namespace, typeName);
        List layers = this.getCatalog().getLayers((ResourceInfo)typeInfo);
        HashSet<String> affectedLayers = new HashSet<String>();
        for (LayerInfo layer : layers) {
            tileLayerName = GWC.tileLayerName(layer);
            if (!this.tileLayerExists(tileLayerName)) continue;
            affectedLayers.add(tileLayerName);
        }
        for (LayerGroupInfo lgi : this.getLayerGroups()) {
            tileLayerName = GWC.tileLayerName(lgi);
            if (!this.tileLayerExists(tileLayerName)) continue;
            for (LayerInfo li : lgi.layers()) {
                ResourceInfo resource = li.getResource();
                if (!typeInfo.equals(resource)) continue;
                affectedLayers.add(tileLayerName);
            }
        }
        return affectedLayers;
    }

    public synchronized void addGridSet(GridSet gridSet) throws IllegalArgumentException, IOException {
        Preconditions.checkNotNull((Object)gridSet);
        this.tld.addGridSet(gridSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void modifyGridSet(String oldGridSetName, GridSet newGridSet) throws IllegalArgumentException, IOException, GeoWebCacheException {
        Preconditions.checkNotNull((Object)oldGridSetName);
        Preconditions.checkNotNull((Object)newGridSet);
        GridSet oldGridSet = this.gridSetBroker.get(oldGridSetName);
        if (null == oldGridSet) {
            throw new IllegalArgumentException("GridSet " + oldGridSetName + " does not exist");
        }
        boolean needsTruncate = oldGridSet.shouldTruncateIfChanged(newGridSet);
        if (needsTruncate) {
            log.warning("### Changes in gridset force truncation of affected Tile layers");
            log.info("### Old gridset: " + oldGridSet);
            log.info("### New gridset: " + newGridSet);
        }
        HashMap<TileLayer, GridSubset> affectedLayers = new HashMap<TileLayer, GridSubset>();
        LockProvider.Lock lock = null;
        try {
            lock = this.lockProvider.getLock(GLOBAL_LOCK_KEY);
            for (TileLayer layer : this.getTileLayers()) {
                GridSubset gridSubet = layer.getGridSubset(oldGridSetName);
                if (null == gridSubet) continue;
                affectedLayers.put(layer, gridSubet);
                layer.removeGridSubset(oldGridSetName);
                if (!needsTruncate) continue;
                this.deleteCacheByGridSetId(layer.getName(), oldGridSetName);
            }
            XMLConfiguration mainConfig = this.getXmlConfiguration();
            mainConfig.removeGridset(oldGridSetName);
            mainConfig.addOrReplaceGridSet(new XMLGridSet(newGridSet));
            mainConfig.save();
            this.getGridSetBroker().remove(oldGridSetName);
            this.getGridSetBroker().put(newGridSet);
            boolean sameSRS = oldGridSet.getSrs().equals((Object)newGridSet.getSrs());
            int maxZoomLevel = newGridSet.getNumLevels() - 1;
            HashSet<Configuration> saveConfigurations = new HashSet<Configuration>();
            for (Map.Entry entry : affectedLayers.entrySet()) {
                TileLayer layer = (TileLayer)entry.getKey();
                GridSubset gsubset = (GridSubset)entry.getValue();
                BoundingBox gridSetExtent = gsubset.getOriginalExtent();
                if (null != gridSetExtent && sameSRS) {
                    gridSetExtent = newGridSet.getOriginalExtent().intersection(gridSetExtent);
                }
                int zoomStart = gsubset.getZoomStart();
                int zoomStop = gsubset.getZoomStop();
                if (zoomStart > maxZoomLevel) {
                    zoomStart = maxZoomLevel;
                }
                if (zoomStop > maxZoomLevel || zoomStop < zoomStart) {
                    zoomStop = maxZoomLevel;
                }
                GridSubset newGridSubset = GridSubsetFactory.createGridSubSet((GridSet)newGridSet, (BoundingBox)gridSetExtent, (Integer)zoomStart, (Integer)zoomStop);
                layer.removeGridSubset(oldGridSetName);
                layer.addGridSubset(newGridSubset);
                Configuration config = this.tld.getConfiguration(layer);
                config.modifyLayer(layer);
                saveConfigurations.add(config);
            }
            for (Configuration config : saveConfigurations) {
                config.save();
            }
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
    }

    XMLConfiguration getXmlConfiguration() {
        XMLConfiguration mainConfig = (XMLConfiguration)GeoWebCacheExtensions.bean(XMLConfiguration.class);
        return mainConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getResponseEncoder(MimeType responseFormat, RenderedImageMap metaTileMap) {
        String format = responseFormat.getFormat();
        String mimeType = responseFormat.getMimeType();
        Response response = cachedTileEncoders.get(format);
        if (response == null) {
            GetMapRequest getMap = new GetMapRequest();
            getMap.setFormat(mimeType);
            Object[] parameters = new Object[]{getMap};
            Service service = (Service)GeoServerExtensions.bean((String)"wms-1_1_1-ServiceDescriptor");
            if (service == null) {
                throw new IllegalStateException("Didn't find service descriptor 'wms-1_1_1-ServiceDescriptor'");
            }
            Operation operation = new Operation("GetMap", service, (Method)null, parameters);
            List extensions = GeoServerExtensions.extensions(Response.class);
            Class<?> webMapClass = metaTileMap.getClass();
            for (Response r : extensions) {
                if (!r.getBinding().isAssignableFrom(webMapClass) || !r.canHandle(operation)) continue;
                Map<String, Response> map = cachedTileEncoders;
                synchronized (map) {
                    cachedTileEncoders.put(mimeType, r);
                    response = r;
                    break;
                }
            }
            if (response == null) {
                throw new IllegalStateException("Didn't find a " + Response.class.getName() + " to handle " + mimeType);
            }
        }
        return response;
    }

    public boolean isQueryable(GeoServerTileLayer geoServerTileLayer) {
        WMS wmsMediator = WMS.get();
        LayerInfo layerInfo = geoServerTileLayer.getLayerInfo();
        if (layerInfo != null) {
            return wmsMediator.isQueryable(layerInfo);
        }
        LayerGroupInfo lgi = geoServerTileLayer.getLayerGroupInfo();
        return wmsMediator.isQueryable(lgi);
    }

    public Iterable<GeoServerTileLayer> getGeoServerTileLayers() {
        Iterable<TileLayer> tileLayers = this.getTileLayers();
        Iterable filtered = Iterables.filter(tileLayers, GeoServerTileLayer.class);
        return filtered;
    }

    public void save(TileLayer layer) {
        Preconditions.checkNotNull((Object)layer);
        log.info("Saving GeoSeverTileLayer " + layer.getName());
        Configuration modifiedConfig = this.tld.modify(layer);
        try {
            modifiedConfig.save();
        }
        catch (IOException e) {
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            throw Throwables.propagate((Throwable)rootCause);
        }
    }

    public List<GeoServerTileLayer> getTileLayersForStyle(String styleName) {
        Iterable<GeoServerTileLayer> tileLayers = this.getGeoServerTileLayers();
        ArrayList<GeoServerTileLayer> affected = new ArrayList<GeoServerTileLayer>();
        for (GeoServerTileLayer tl : tileLayers) {
            try {
                GeoServerTileLayerInfo info = tl.getInfo();
                String defaultStyle = tl.getStyles();
                ImmutableSet<String> cachedStyles = info.cachedStyles();
                if (!styleName.equals(defaultStyle) && !cachedStyles.contains(styleName)) continue;
                affected.add(tl);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to retrieve style info for layer" + tl.getName(), e);
            }
        }
        return affected;
    }

    public Iterable<LayerInfo> getLayerInfosFor(StyleInfo style) {
        String styleName = style.prefixedName();
        ArrayList<LayerInfo> result = new ArrayList<LayerInfo>();
        for (LayerInfo layer : this.getLayerInfos()) {
            try {
                String name = layer.getDefaultStyle().prefixedName();
                if (styleName.equals(name)) {
                    result.add(layer);
                    continue;
                }
                for (StyleInfo alternateStyle : layer.getStyles()) {
                    name = alternateStyle.prefixedName();
                    if (!styleName.equals(name)) continue;
                    result.add(layer);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to retrieve style info for layer" + layer.getName(), e);
            }
        }
        return result;
    }

    public Iterable<LayerGroupInfo> getLayerGroupsFor(StyleInfo style) {
        ArrayList<LayerGroupInfo> layerGroups = new ArrayList<LayerGroupInfo>();
        block0: for (LayerGroupInfo layerGroup : this.getLayerGroups()) {
            LayerGroupHelper helper = new LayerGroupHelper(layerGroup);
            Iterator groupLayers = helper.allLayers().iterator();
            Iterator explicitLayerGroupStyles = helper.allStyles().iterator();
            while (groupLayers.hasNext()) {
                LayerInfo childLayer = (LayerInfo)groupLayers.next();
                StyleInfo assignedLayerStyle = (StyleInfo)explicitLayerGroupStyles.next();
                if (assignedLayerStyle == null) {
                    assignedLayerStyle = childLayer.getDefaultStyle();
                }
                if (!style.equals(assignedLayerStyle)) continue;
                layerGroups.add(layerGroup);
                continue block0;
            }
        }
        return layerGroups;
    }

    public ReferencedEnvelope getAreaOfValidity(CoordinateReferenceSystem coordSys) {
        Geometry aovGeom = GWC.getAreaOfValidityAsGeometry(coordSys, this.gridSetBroker);
        if (aovGeom == null) {
            return null;
        }
        Envelope envelope = aovGeom.getEnvelopeInternal();
        double x1 = envelope.getMinX();
        double x2 = envelope.getMaxX();
        double y1 = envelope.getMinY();
        double y2 = envelope.getMaxY();
        ReferencedEnvelope aov = new ReferencedEnvelope(coordSys);
        aov.init(x1, x2, y1, y2);
        return aov;
    }

    public static Geometry getAreaOfValidityAsGeometry(CoordinateReferenceSystem targetCrs, GridSetBroker gridSetBroker) {
        Polygon aovGeom;
        String[] variants = new String[]{"EPSG:900913", "EPSG:3857", "EPSG:3785"};
        boolean is900913Compatible = false;
        for (String variantCode : variants) {
            CoordinateReferenceSystem variant = GWC.variant(variantCode);
            boolean bl = is900913Compatible = variant != null && CRS.equalsIgnoreMetadata((Object)targetCrs, (Object)variant);
            if (is900913Compatible) break;
        }
        if (is900913Compatible) {
            BoundingBox prescribedBounds = gridSetBroker.WORLD_EPSG3857.getBounds();
            return JTS.toGeometry((Envelope)new Envelope(prescribedBounds.getMinX(), prescribedBounds.getMaxX(), prescribedBounds.getMinY(), prescribedBounds.getMaxY()));
        }
        org.opengis.geometry.Envelope envelope = CRS.getEnvelope((CoordinateReferenceSystem)targetCrs);
        if (envelope == null) {
            return null;
        }
        double tolerance = 1.0E-6;
        if (envelope.getSpan(0) < 1.0E-6 || envelope.getSpan(1) < 1.0E-6) {
            GeographicBoundingBox latLonBBox = CRS.getGeographicBoundingBox((CoordinateReferenceSystem)targetCrs);
            ReferencedEnvelope bbox = new ReferencedEnvelope((org.opengis.geometry.Envelope)new GeneralEnvelope(latLonBBox));
            Polygon geometry = JTS.toGeometry((ReferencedEnvelope)bbox);
            double distanceTolerance = Math.max(bbox.getSpan(0), bbox.getSpan(1)) / 200000.0;
            Geometry densifiedGeom = Densifier.densify((Geometry)geometry, (double)distanceTolerance);
            try {
                CoordinateReferenceSystem sourceCRS = bbox.getCoordinateReferenceSystem();
                MathTransform mathTransform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCrs);
                aovGeom = JTS.transform((Geometry)densifiedGeom, (MathTransform)mathTransform);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            aovGeom = JTS.toGeometry((Envelope)new Envelope(envelope.getMinimum(0), envelope.getMaximum(0), envelope.getMinimum(1), envelope.getMaximum(1)));
        }
        aovGeom.setUserData((Object)targetCrs);
        return aovGeom;
    }

    private static CoordinateReferenceSystem variant(String code) {
        CoordinateReferenceSystem variant;
        try {
            variant = CRS.decode((String)code);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.getMessage(), e);
            return null;
        }
        return variant;
    }

    public boolean isInternalGridSet(String gridSetId) {
        boolean internal = this.gridSetBroker.getEmbeddedNames().contains(gridSetId);
        return internal;
    }

    public void deleteCacheByGridSetId(String layerName, String gridSetId) {
        try {
            this.storageBroker.deleteByGridSetId(layerName, gridSetId);
        }
        catch (StorageException e) {
            throw Throwables.propagate((Throwable)Throwables.getRootCause((Throwable)e));
        }
    }

    public void removeTileLayers(List<String> tileLayerNames) {
        Preconditions.checkNotNull(tileLayerNames);
        HashSet<Configuration> confsToSave = new HashSet<Configuration>();
        for (String tileLayerName : tileLayerNames) {
            Configuration configuration = this.tld.removeLayer(tileLayerName);
            if (configuration == null) continue;
            confsToSave.add(configuration);
        }
        for (Configuration conf : confsToSave) {
            try {
                conf.save();
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Error saving GWC Configuration " + conf.getIdentifier(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeGridSets(Set<String> gridsetIds) throws IOException, GeoWebCacheException {
        Preconditions.checkNotNull(gridsetIds);
        Set<String> affectedLayers = this.getLayerNamesForGridSets(gridsetIds);
        HashSet<Configuration> changedConfigs = new HashSet<Configuration>();
        for (String layerName : affectedLayers) {
            TileLayer tileLayer = this.getTileLayerByName(layerName);
            LockProvider.Lock lock = null;
            try {
                lock = this.lockProvider.getLock("gwc_lock_layer_" + layerName);
                for (String gridSetId : gridsetIds) {
                    if (!tileLayer.getGridSubsets().contains(gridSetId)) continue;
                    tileLayer.removeGridSubset(gridSetId);
                    this.deleteCacheByGridSetId(layerName, gridSetId);
                }
                if (tileLayer.getGridSubsets().isEmpty()) {
                    tileLayer.setEnabled(false);
                }
                try {
                    Configuration configuration = this.tld.modify(tileLayer);
                    changedConfigs.add(configuration);
                }
                catch (IllegalArgumentException ignore) {
                    // empty catch block
                }
            }
            finally {
                if (lock == null) continue;
                lock.release();
            }
        }
        for (String gridSetId : gridsetIds) {
            Configuration configuration = this.tld.removeGridset(gridSetId);
            changedConfigs.add(configuration);
        }
        for (Configuration config : changedConfigs) {
            config.save();
        }
    }

    public void autoConfigureLayers(List<String> catalogLayerNames, GWCConfig saneConfig) {
        Preconditions.checkArgument((boolean)saneConfig.isSane());
        Catalog catalog = this.getCatalog();
        for (String name : catalogLayerNames) {
            Preconditions.checkArgument((!this.tileLayerExists(name) ? 1 : 0) != 0, (String)"Can't auto configure Layer, a tile layer named '", (Object[])new Object[]{name, "' already exists."});
            GeoServerTileLayer tileLayer = null;
            LayerInfo layer = catalog.getLayerByName(name);
            if (layer != null) {
                tileLayer = new GeoServerTileLayer((PublishedInfo)layer, saneConfig, this.gridSetBroker);
            } else {
                LayerGroupInfo layerGroup = catalog.getLayerGroupByName(name);
                if (layerGroup != null) {
                    tileLayer = new GeoServerTileLayer((PublishedInfo)layerGroup, saneConfig, this.gridSetBroker);
                }
            }
            if (tileLayer != null) {
                this.add(tileLayer);
                continue;
            }
            log.warning("Requested layer " + name + " does not exist. Won't create TileLayer");
        }
    }

    public boolean hasTileLayer(CatalogInfo source) {
        Configuration configuration;
        String tileLayerId;
        if (source instanceof ResourceInfo) {
            LayerInfo layerInfo = this.getCatalog().getLayerByName(((ResourceInfo)source).prefixedName());
            if (layerInfo == null) {
                return false;
            }
            tileLayerId = layerInfo.getId();
        } else if (source instanceof LayerInfo) {
            tileLayerId = ((LayerInfo)source).getId();
        } else if (source instanceof LayerGroupInfo) {
            tileLayerId = ((LayerGroupInfo)source).getId();
        } else {
            return false;
        }
        try {
            configuration = this.tld.getConfiguration(tileLayerId);
        }
        catch (IllegalArgumentException notFound) {
            return false;
        }
        return configuration instanceof CatalogConfiguration;
    }

    public GeoServerTileLayer getTileLayer(CatalogInfo source) {
        TileLayer tileLayer;
        String name;
        if (source instanceof ResourceInfo) {
            name = ((ResourceInfo)source).prefixedName();
        } else if (source instanceof LayerInfo) {
            name = GWC.tileLayerName((LayerInfo)source);
        } else if (source instanceof LayerGroupInfo) {
            name = GWC.tileLayerName((LayerGroupInfo)source);
        } else {
            return null;
        }
        try {
            tileLayer = this.tld.getTileLayer(name);
        }
        catch (GeoWebCacheException notFound) {
            return null;
        }
        if (tileLayer instanceof GeoServerTileLayer) {
            return (GeoServerTileLayer)tileLayer;
        }
        return null;
    }

    public void verifyAccessLayer(String layerName, ReferencedEnvelope boundingBox) throws ServiceException {
        SecuredLayerInfo securedLayerInfo;
        WrapperPolicy policy;
        AccessLimits limits;
        LayerInfo layerInfo = this.getLayerInfoByName(layerName);
        if (layerInfo == null) {
            throw new ServiceException("Could not find layer " + layerName, "LayerNotDefined");
        }
        if (layerInfo instanceof SecuredLayerInfo && boundingBox != null && (limits = (policy = (securedLayerInfo = (SecuredLayerInfo)layerInfo).getWrapperPolicy()).getLimits()) instanceof DataAccessLimits) {
            Envelope box;
            CoordinateReferenceSystem dataCrs = layerInfo.getResource().getCRS();
            if (boundingBox.getCoordinateReferenceSystem() != null && !CRS.equalsIgnoreMetadata((Object)dataCrs, (Object)boundingBox.getCoordinateReferenceSystem())) {
                try {
                    boundingBox = boundingBox.transform(dataCrs, true);
                }
                catch (Exception e) {
                    boundingBox = null;
                }
            }
            ReferencedEnvelope limitBox = new ReferencedEnvelope((Envelope)ReferencedEnvelope.EVERYTHING, dataCrs);
            Filter filter = ((DataAccessLimits)limits).getReadFilter();
            if (filter != null && (box = (Envelope)filter.accept((FilterVisitor)ExtractBoundsFilterVisitor.BOUNDS_VISITOR, null)) != null) {
                limitBox = new ReferencedEnvelope(limitBox.intersection(box), dataCrs);
            }
            if (limits instanceof CoverageAccessLimits && ((CoverageAccessLimits)limits).getRasterFilter() != null && (box = ((CoverageAccessLimits)limits).getRasterFilter().getEnvelopeInternal()) != null) {
                limitBox = new ReferencedEnvelope(limitBox.intersection(box), dataCrs);
            }
            if (limits instanceof WMSAccessLimits && ((WMSAccessLimits)limits).getRasterFilter() != null && (box = ((WMSAccessLimits)limits).getRasterFilter().getEnvelopeInternal()) != null) {
                limitBox = new ReferencedEnvelope(limitBox.intersection(box), dataCrs);
            }
            if (!(limitBox.covers((Envelope)ReferencedEnvelope.EVERYTHING) || boundingBox != null && limitBox.contains((Envelope)boundingBox))) {
                throw new ServiceException("Access denied to bounding box on layer " + layerName, "AccessDenied");
            }
        }
    }

    public CoordinateReferenceSystem getDeclaredCrs(String geoServerTileLayerName) {
        GeoServerTileLayer layer = (GeoServerTileLayer)this.getTileLayerByName(geoServerTileLayerName);
        LayerInfo layerInfo = layer.getLayerInfo();
        if (layerInfo != null) {
            return layerInfo.getResource().getCRS();
        }
        LayerGroupInfo layerGroupInfo = layer.getLayerGroupInfo();
        ReferencedEnvelope bounds = layerGroupInfo.getBounds();
        return bounds.getCoordinateReferenceSystem();
    }

    public static String tileLayerName(LayerInfo li) {
        return li.getResource().prefixedName();
    }

    public static String tileLayerName(LayerGroupInfo lgi) {
        return lgi.prefixedName();
    }

    public static void tryReset() {
        GWC instance = INSTANCE;
        if (instance != null) {
            INSTANCE.reset();
        }
    }

    void reset() {
        CatalogConfiguration c = (CatalogConfiguration)GeoServerExtensions.bean(CatalogConfiguration.class);
        if (c != null) {
            c.reset();
        }
    }

    public LockProvider getLockProvider() {
        return this.lockProvider;
    }

    public JDBCConfiguration getJDBCDiskQuotaConfig() throws IOException, ConfigurationException {
        return this.jdbcConfigurationStorage.getJDBCDiskQuotaConfig();
    }

    public void testQuotaConfiguration(JDBCConfiguration jdbcConfiguration) throws ConfigurationException, IOException {
        this.jdbcConfigurationStorage.testQuotaConfiguration(jdbcConfiguration);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public static Set<String> getAdvertisedCachedFormats(PublishedType type) {
        String resourceName = "org/geoserver/gwc/advertised_formats.properties";
        try {
            ClassLoader classLoader = GWC.class.getClassLoader();
            ArrayList urls = Lists.newArrayList((Iterator)Iterators.forEnumeration(classLoader.getResources("org/geoserver/gwc/advertised_formats.properties")));
            return GWC.getAdvertisedCachedFormats(type, urls);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static Set<String> getAdvertisedCachedFormats(PublishedType type, Iterable<URL> urls) throws IOException {
        String formatsKey;
        switch (type) {
            case VECTOR: 
            case REMOTE: {
                formatsKey = "formats.vector";
                break;
            }
            case RASTER: 
            case WMS: {
                formatsKey = "formats.raster";
                break;
            }
            case GROUP: {
                formatsKey = "formats.layergroup";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown published type: " + type);
            }
        }
        TreeSet<String> formats = new TreeSet<String>();
        for (URL url : urls) {
            Properties props = new Properties();
            props.load(url.openStream());
            String commaSeparatedFormats = props.getProperty(formatsKey);
            if (commaSeparatedFormats == null) continue;
            List splitToList = Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)commaSeparatedFormats);
            formats.addAll(splitToList);
        }
        return formats;
    }

    public List<BlobStoreConfig> getBlobStores() {
        XMLConfiguration xmlConfig = this.getXmlConfiguration();
        return new ArrayList<BlobStoreConfig>(xmlConfig.getBlobStores());
    }

    public BlobStoreConfig getDefaultBlobStore() {
        XMLConfiguration xmlConfig = this.getXmlConfiguration();
        for (BlobStoreConfig config : xmlConfig.getBlobStores()) {
            if (!config.isDefault()) continue;
            return config;
        }
        return null;
    }

    public void addBlobStore(BlobStoreConfig config) throws ConfigurationException {
        Preconditions.checkNotNull((Object)config);
        ArrayList<BlobStoreConfig> stores = new ArrayList<BlobStoreConfig>(this.getXmlConfiguration().getBlobStores());
        if (config.isDefault()) {
            for (BlobStoreConfig c : stores) {
                c.setDefault(false);
            }
        }
        stores.add(config);
        this.setBlobStores(stores);
    }

    public void modifyBlobStore(String oldId, BlobStoreConfig config) throws ConfigurationException {
        Preconditions.checkNotNull((Object)oldId);
        Preconditions.checkNotNull((Object)config);
        ArrayList<BlobStoreConfig> stores = new ArrayList<BlobStoreConfig>(this.getXmlConfiguration().getBlobStores());
        int index = -1;
        for (int i = 0; i < stores.size(); ++i) {
            BlobStoreConfig c = (BlobStoreConfig)stores.get(i);
            if (!oldId.equals(c.getId())) continue;
            index = i;
            break;
        }
        if (index > -1) {
            stores.set(index, config);
            this.setBlobStores(stores);
        }
    }

    public void removeBlobStores(Iterable<String> blobStoreIds) throws ConfigurationException {
        Preconditions.checkNotNull(blobStoreIds);
        ImmutableMap stores = Maps.uniqueIndex(new ArrayList(this.getXmlConfiguration().getBlobStores()), (Function)new Function<BlobStoreConfig, String>(){

            public String apply(BlobStoreConfig c) {
                return c.getId();
            }
        });
        Map filtered = Maps.filterKeys((Map)stores, (Predicate)Predicates.not((Predicate)Predicates.in((Collection)ImmutableList.copyOf(blobStoreIds))));
        if (!filtered.equals(stores)) {
            this.setBlobStores(new ArrayList<BlobStoreConfig>(filtered.values()));
        }
    }

    void setBlobStores(List<BlobStoreConfig> stores) throws ConfigurationException {
        Preconditions.checkNotNull(stores, (Object)"stores is null");
        XMLConfiguration xmlConfig = this.getXmlConfiguration();
        CompositeBlobStore compositeBlobStore = this.getCompositeBlobStore();
        ArrayList oldStores = new ArrayList(xmlConfig.getBlobStores());
        try {
            compositeBlobStore.setBlobStores(stores);
        }
        catch (ConfigurationException ce) {
            throw ce;
        }
        catch (StorageException se) {
            throw new ConfigurationException("Error connecting to BlobStore: " + se.getMessage(), (Throwable)se);
        }
        xmlConfig.getBlobStores().clear();
        xmlConfig.getBlobStores().addAll(stores);
        try {
            xmlConfig.save();
        }
        catch (IOException e) {
            xmlConfig.getBlobStores().clear();
            xmlConfig.getBlobStores().addAll(oldStores);
            try {
                compositeBlobStore.setBlobStores(oldStores);
            }
            catch (StorageException e1) {
                // empty catch block
            }
            throw new ConfigurationException("Error saving configuration", (Throwable)e);
        }
    }

    CompositeBlobStore getCompositeBlobStore() {
        CompositeBlobStore compositeBlobStore = (CompositeBlobStore)GeoWebCacheExtensions.bean(CompositeBlobStore.class);
        Preconditions.checkNotNull((Object)compositeBlobStore);
        return compositeBlobStore;
    }

    static {
        log = Logging.getLogger(GWC.class);
        cachedTileEncoders = new HashMap<String, Response>();
    }
}

