/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.diskquota.QuotaStore;
import org.geowebcache.diskquota.storage.PageStats;
import org.geowebcache.diskquota.storage.PageStatsPayload;
import org.geowebcache.diskquota.storage.Quota;
import org.geowebcache.diskquota.storage.TilePage;
import org.geowebcache.diskquota.storage.TilePageCalculator;
import org.geowebcache.diskquota.storage.TileSet;
import org.geowebcache.diskquota.storage.TileSetVisitor;

public class ConfigurableQuotaStore
implements QuotaStore {
    static final Logger LOGGER = Logging.getLogger(ConfigurableQuotaStore.class);
    private QuotaStore delegate;

    public void setStore(QuotaStore delegate) {
        this.delegate = delegate;
    }

    public QuotaStore getStore() {
        return this.delegate;
    }

    public ConfigurableQuotaStore(QuotaStore delegate) {
        this.delegate = delegate;
    }

    public TilePageCalculator getTilePageCalculator() {
        return this.delegate.getTilePageCalculator();
    }

    public void createLayer(String layerName) throws InterruptedException {
        this.delegate.createLayer(layerName);
    }

    public Quota getGloballyUsedQuota() throws InterruptedException {
        return this.delegate.getGloballyUsedQuota();
    }

    public Quota getUsedQuotaByTileSetId(String tileSetId) throws InterruptedException {
        return this.delegate.getUsedQuotaByTileSetId(tileSetId);
    }

    public void deleteLayer(String layerName) {
        this.delegate.deleteLayer(layerName);
    }

    public void renameLayer(String oldLayerName, String newLayerName) throws InterruptedException {
        this.delegate.renameLayer(oldLayerName, newLayerName);
    }

    public Quota getUsedQuotaByLayerName(String layerName) throws InterruptedException {
        return this.delegate.getUsedQuotaByLayerName(layerName);
    }

    public long[][] getTilesForPage(TilePage page) throws InterruptedException {
        return this.delegate.getTilesForPage(page);
    }

    public Set<TileSet> getTileSets() {
        return this.delegate.getTileSets();
    }

    public TileSet getTileSetById(String tileSetId) throws InterruptedException {
        return this.delegate.getTileSetById(tileSetId);
    }

    public void accept(TileSetVisitor visitor) {
        this.delegate.accept(visitor);
    }

    public void addToQuotaAndTileCounts(TileSet tileSet, Quota quotaDiff, Collection<PageStatsPayload> tileCountDiffs) throws InterruptedException {
        this.delegate.addToQuotaAndTileCounts(tileSet, quotaDiff, tileCountDiffs);
    }

    public Future<List<PageStats>> addHitsAndSetAccesTime(Collection<PageStatsPayload> statsUpdates) {
        return this.delegate.addHitsAndSetAccesTime(statsUpdates);
    }

    public TilePage getLeastFrequentlyUsedPage(Set<String> layerNames) throws InterruptedException {
        return this.delegate.getLeastFrequentlyUsedPage(layerNames);
    }

    public TilePage getLeastRecentlyUsedPage(Set<String> layerNames) throws InterruptedException {
        return this.delegate.getLeastRecentlyUsedPage(layerNames);
    }

    public PageStats setTruncated(TilePage tilePage) throws InterruptedException {
        return this.delegate.setTruncated(tilePage);
    }

    public void deleteGridSubset(String layerName, String gridSetId) {
        this.delegate.deleteGridSubset(layerName, gridSetId);
    }

    public void close() throws Exception {
        this.delegate.close();
    }
}

