/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.util.logging.Logging;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.BlobStoreListener;
import org.geowebcache.storage.BlobStoreListenerList;
import org.geowebcache.storage.StorageException;
import org.geowebcache.storage.TileObject;
import org.geowebcache.storage.TileRange;
import org.geowebcache.storage.blobstore.memory.CacheConfiguration;
import org.geowebcache.storage.blobstore.memory.CacheProvider;
import org.geowebcache.storage.blobstore.memory.CacheStatistics;
import org.geowebcache.storage.blobstore.memory.MemoryBlobStore;
import org.geowebcache.storage.blobstore.memory.NullBlobStore;
import org.geowebcache.storage.blobstore.memory.guava.GuavaCacheProvider;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class ConfigurableBlobStore
extends MemoryBlobStore
implements BlobStore {
    private static final Logger LOGGER = Logging.getLogger(ConfigurableBlobStore.class);
    private BlobStore delegate;
    private MemoryBlobStore memoryStore;
    private CacheProvider cache;
    private NullBlobStore nullStore;
    private BlobStore defaultStore;
    private AtomicLong actualOperations;
    private AtomicBoolean configured;
    private Map<String, CacheConfiguration> internalCacheConfigs;
    private Map<String, String> cacheProvidersNames;
    private Map<String, CacheProvider> cacheProviders;
    private BlobStoreListenerList listeners = new BlobStoreListenerList();

    public ConfigurableBlobStore(BlobStore defaultStore, MemoryBlobStore memoryStore, NullBlobStore nullStore) {
        this.configured = new AtomicBoolean(false);
        this.actualOperations = new AtomicLong(0L);
        this.delegate = defaultStore;
        this.defaultStore = defaultStore;
        this.memoryStore = memoryStore;
        this.nullStore = nullStore;
        HashMap<String, CacheProvider> cacheProviders = new HashMap<String, CacheProvider>();
        HashMap<String, String> cacheProvidersNames = new HashMap<String, String>();
        List extensions = GeoServerExtensions.extensions(CacheProvider.class);
        for (CacheProvider provider : extensions) {
            if (!provider.isAvailable()) continue;
            cacheProviders.put(provider.getClass().toString(), provider);
            cacheProvidersNames.put(provider.getClass().toString(), provider.getName());
        }
        this.cacheProviders = Collections.unmodifiableMap(cacheProviders);
        this.cacheProvidersNames = Collections.unmodifiableMap(cacheProvidersNames);
        this.internalCacheConfigs = new HashMap<String, CacheConfiguration>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String layerName) throws StorageException {
        if (this.configured.get()) {
            this.actualOperations.incrementAndGet();
            try {
                boolean bl = this.delegate.delete(layerName);
                return bl;
            }
            finally {
                this.actualOperations.decrementAndGet();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteByGridsetId(String layerName, String gridSetId) throws StorageException {
        if (this.configured.get()) {
            this.actualOperations.incrementAndGet();
            try {
                boolean bl = this.delegate.deleteByGridsetId(layerName, gridSetId);
                return bl;
            }
            finally {
                this.actualOperations.decrementAndGet();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(TileObject obj) throws StorageException {
        if (this.configured.get()) {
            this.actualOperations.incrementAndGet();
            try {
                boolean bl = this.delegate.delete(obj);
                return bl;
            }
            finally {
                this.actualOperations.decrementAndGet();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(TileRange obj) throws StorageException {
        if (this.configured.get()) {
            this.actualOperations.incrementAndGet();
            try {
                boolean bl = this.delegate.delete(obj);
                return bl;
            }
            finally {
                this.actualOperations.decrementAndGet();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean get(TileObject obj) throws StorageException {
        if (this.configured.get()) {
            this.actualOperations.incrementAndGet();
            try {
                boolean bl = this.delegate.get(obj);
                return bl;
            }
            finally {
                this.actualOperations.decrementAndGet();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(TileObject obj) throws StorageException {
        if (this.configured.get()) {
            this.actualOperations.incrementAndGet();
            try {
                this.delegate.put(obj);
            }
            finally {
                this.actualOperations.decrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws StorageException {
        if (this.configured.get()) {
            this.actualOperations.incrementAndGet();
            try {
                this.delegate.clear();
            }
            finally {
                this.actualOperations.decrementAndGet();
            }
        }
    }

    public synchronized void destroy() {
        if (this.configured.getAndSet(false)) {
            this.actualOperations.incrementAndGet();
            this.actualOperations.decrementAndGet();
            while (this.actualOperations.get() > 0L) {
            }
            super.destroy();
            this.delegate.destroy();
            this.cache.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(BlobStoreListener listener) {
        this.listeners.addListener(listener);
        if (this.configured.get()) {
            this.actualOperations.incrementAndGet();
            try {
                this.delegate.addListener(listener);
            }
            finally {
                this.actualOperations.decrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(BlobStoreListener listener) {
        this.listeners.removeListener(listener);
        if (this.configured.get()) {
            this.actualOperations.incrementAndGet();
            try {
                boolean bl = this.delegate.removeListener(listener);
                return bl;
            }
            finally {
                this.actualOperations.decrementAndGet();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rename(String oldLayerName, String newLayerName) throws StorageException {
        if (this.configured.get()) {
            this.actualOperations.incrementAndGet();
            try {
                boolean bl = this.delegate.rename(oldLayerName, newLayerName);
                return bl;
            }
            finally {
                this.actualOperations.decrementAndGet();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLayerMetadata(String layerName, String key) {
        if (this.configured.get()) {
            this.actualOperations.incrementAndGet();
            try {
                String string = this.delegate.getLayerMetadata(layerName, key);
                return string;
            }
            finally {
                this.actualOperations.decrementAndGet();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putLayerMetadata(String layerName, String key, String value) {
        if (this.configured.get()) {
            this.actualOperations.incrementAndGet();
            try {
                this.delegate.putLayerMetadata(layerName, key, value);
            }
            finally {
                this.actualOperations.decrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheStatistics getCacheStatistics() {
        if (this.configured.get()) {
            this.actualOperations.incrementAndGet();
            try {
                CacheStatistics cacheStatistics = this.cache.getStatistics();
                return cacheStatistics;
            }
            finally {
                this.actualOperations.decrementAndGet();
            }
        }
        return new CacheStatistics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        if (this.configured.get()) {
            this.actualOperations.incrementAndGet();
            try {
                this.cache.clear();
            }
            finally {
                this.actualOperations.decrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheProvider getCache() {
        if (this.configured.get()) {
            this.actualOperations.incrementAndGet();
            try {
                CacheProvider cacheProvider = this.cache;
                return cacheProvider;
            }
            finally {
                this.actualOperations.decrementAndGet();
            }
        }
        return null;
    }

    public Map<String, CacheProvider> getCacheProviders() {
        return this.cacheProviders;
    }

    public Map<String, String> getCacheProvidersNames() {
        return this.cacheProvidersNames;
    }

    public synchronized void setChanged(GWCConfig gwcConfig, boolean initialization) {
        this.configureBlobStore(gwcConfig, initialization);
    }

    private void configureBlobStore(GWCConfig gwcConfig, boolean initialization) {
        String cacheProvider;
        block21: {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Configuring BlobStore");
            }
            this.configured.getAndSet(false);
            this.actualOperations.incrementAndGet();
            this.actualOperations.decrementAndGet();
            while (this.actualOperations.get() > 0L) {
            }
            cacheProvider = gwcConfig.getCacheProviderClass();
            if (!this.getCacheProviders().containsKey(cacheProvider)) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("Wrong CacheProvider defined, using default one");
                }
                cacheProvider = GuavaCacheProvider.class.toString();
                if (!initialization) {
                    gwcConfig.setCacheProviderClass(cacheProvider);
                    try {
                        GWC.get().saveConfig(gwcConfig);
                    }
                    catch (IOException e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break block21;
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
        }
        CacheConfiguration cacheConfiguration = gwcConfig.getCacheConfigurations().get(cacheProvider);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Configuring cache");
        }
        this.cache = this.getCacheProviders().get(cacheProvider);
        if (!this.cache.isImmutable()) {
            CacheConfiguration internalCacheConfig = this.internalCacheConfigs.get(cacheProvider);
            if (internalCacheConfig == null) {
                internalCacheConfig = new CacheConfiguration();
                internalCacheConfig.setConcurrencyLevel(cacheConfiguration.getConcurrencyLevel());
                internalCacheConfig.setEvictionTime(cacheConfiguration.getEvictionTime());
                internalCacheConfig.setHardMemoryLimit(cacheConfiguration.getHardMemoryLimit());
                internalCacheConfig.setPolicy(cacheConfiguration.getPolicy());
                this.cache.configure(cacheConfiguration);
                this.internalCacheConfigs.put(cacheProvider, internalCacheConfig);
            } else if (!internalCacheConfig.equals((Object)cacheConfiguration)) {
                internalCacheConfig.setConcurrencyLevel(cacheConfiguration.getConcurrencyLevel());
                internalCacheConfig.setEvictionTime(cacheConfiguration.getEvictionTime());
                internalCacheConfig.setHardMemoryLimit(cacheConfiguration.getHardMemoryLimit());
                internalCacheConfig.setPolicy(cacheConfiguration.getPolicy());
                this.cache.configure(internalCacheConfig);
            }
            if (!initialization) {
                Iterable<GeoServerTileLayer> geoServerTileLayers = GWC.get().getGeoServerTileLayers();
                for (GeoServerTileLayer layer : geoServerTileLayers) {
                    if (!layer.getInfo().isEnabled() || layer.getInfo().isInMemoryCached()) continue;
                    this.cache.addUncachedLayer(layer.getName());
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Configuring BlobStore delegate");
        }
        for (BlobStoreListener listener : this.listeners.getListeners()) {
            this.delegate.removeListener(listener);
        }
        if (gwcConfig.isInnerCachingEnabled()) {
            this.memoryStore.setCacheProvider(this.cache);
            if (!gwcConfig.isPersistenceEnabled()) {
                this.memoryStore.setStore((BlobStore)this.nullStore);
            } else {
                this.memoryStore.setStore(this.defaultStore);
            }
            this.delegate = this.memoryStore;
        } else {
            this.delegate = this.defaultStore;
        }
        for (BlobStoreListener listener : this.listeners.getListeners()) {
            this.delegate.addListener(listener);
        }
        this.configured.getAndSet(true);
    }

    BlobStore getDelegate() {
        return this.delegate;
    }

    void setCache(CacheProvider cache) {
        HashMap<String, CacheProvider> provs = new HashMap<String, CacheProvider>(this.cacheProviders);
        provs.put(cache.getClass().toString(), cache);
        this.cacheProviders = provs;
        this.cache = cache;
        this.memoryStore.setCacheProvider(cache);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
    }

    public void setCacheProvider(CacheProvider cache) {
        throw new UnsupportedOperationException("Operation not supported");
    }
}

