/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.IModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.catalog.util.CloseableIteratorAdapter;
import org.geoserver.web.data.style.StyleDetachableModel;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;

public class StyleProvider
extends GeoServerDataProvider<StyleInfo> {
    public static GeoServerDataProvider.Property<StyleInfo> NAME = new GeoServerDataProvider.BeanProperty("name", "name");
    public static GeoServerDataProvider.Property<StyleInfo> WORKSPACE = new GeoServerDataProvider.BeanProperty("workspace", "workspace.name");
    static List PROPERTIES = Arrays.asList(NAME, WORKSPACE);

    public StyleProvider() {
        this.setSort(NAME.getName(), true);
    }

    protected List<StyleInfo> getItems() {
        throw new UnsupportedOperationException("This method should not be being called! We use the catalog streaming API");
    }

    protected List<GeoServerDataProvider.Property<StyleInfo>> getProperties() {
        return PROPERTIES;
    }

    public IModel newModel(Object object) {
        return new StyleDetachableModel((StyleInfo)object);
    }

    public int size() {
        Filter filter = this.getFilter();
        int count = this.getCatalog().count(StyleInfo.class, filter);
        return count;
    }

    public int fullSize() {
        Filter filter = Predicates.acceptAll();
        int count = this.getCatalog().count(StyleInfo.class, filter);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<StyleInfo> iterator(int first, int count) {
        Iterator<StyleInfo> iterator = this.filteredItems(first, count);
        if (iterator instanceof CloseableIterator) {
            try {
                Iterator<StyleInfo> iterator2 = Lists.newArrayList(iterator).iterator();
                return iterator2;
            }
            finally {
                CloseableIteratorAdapter.close(iterator);
            }
        }
        return iterator;
    }

    private Iterator<StyleInfo> filteredItems(Integer first, Integer count) {
        Catalog catalog = this.getCatalog();
        SortParam sort = this.getSort();
        GeoServerDataProvider.Property property = this.getProperty(sort);
        SortBy sortOrder = null;
        if (sort != null && property instanceof GeoServerDataProvider.BeanProperty) {
            String sortProperty = ((GeoServerDataProvider.BeanProperty)property).getPropertyPath();
            sortOrder = Predicates.sortBy((String)sortProperty, (boolean)sort.isAscending());
        }
        Filter filter = this.getFilter();
        CloseableIterator items = catalog.list(StyleInfo.class, filter, first, count, sortOrder);
        return items;
    }
}

