/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Resource;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxCallDecorator;
import org.apache.wicket.ajax.calldecorator.AjaxPreprocessingCallDecorator;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.DynamicWebResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.lang.Bytes;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StyleGenerator;
import org.geoserver.catalog.StyleHandler;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.StyleType;
import org.geoserver.catalog.Styles;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.web.ComponentAuthorizer;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.style.StyleDetachableModel;
import org.geoserver.web.data.workspace.WorkspaceChoiceRenderer;
import org.geoserver.web.data.workspace.WorkspacesModel;
import org.geoserver.web.wicket.CodeMirrorEditor;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.legendgraphic.BufferedImageLegendGraphicBuilder;
import org.geoserver.wms.web.data.StyleFormatsModel;
import org.geoserver.wms.web.data.StylePage;
import org.geoserver.wms.web.publish.StyleChoiceRenderer;
import org.geoserver.wms.web.publish.StyleTypeChoiceRenderer;
import org.geoserver.wms.web.publish.StyleTypeModel;
import org.geoserver.wms.web.publish.StylesModel;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.Style;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.UserLayer;
import org.springframework.context.ApplicationContext;
import org.xml.sax.SAXParseException;

public abstract class AbstractStylePage
extends GeoServerSecuredPage {
    protected String format;
    protected TextField nameTextField;
    protected FileUploadField fileUploadField;
    protected DropDownChoice templates;
    protected AjaxSubmitLink generateLink;
    protected DropDownChoice styles;
    protected AjaxSubmitLink copyLink;
    protected Form uploadForm;
    protected Form generateForm;
    protected Form styleForm;
    protected CodeMirrorEditor editor;
    protected MarkupContainer formatReadOnlyMessage;
    String rawStyle;
    private Image legend;
    String lastStyle;
    private WebMarkupContainer legendContainer;
    private DropDownChoice<WorkspaceInfo> wsChoice;
    DropDownChoice<String> formatChoice;

    public AbstractStylePage() {
    }

    public AbstractStylePage(StyleInfo style) {
        this.initUI(style);
    }

    protected void initUI(StyleInfo style) {
        CompoundPropertyModel styleModel = new CompoundPropertyModel(style != null ? new StyleDetachableModel(style) : this.getCatalog().getFactory().createStyle());
        this.format = style != null ? style.getFormat() : this.getCatalog().getFactory().createStyle().getFormat();
        this.styleForm = new Form("form", (IModel)styleModel){

            protected void onSubmit() {
                super.onSubmit();
                AbstractStylePage.this.onStyleFormSubmit();
            }
        };
        this.styleForm.setMarkupId("mainForm");
        this.add(new Component[]{this.styleForm});
        Component[] componentArray = new Component[1];
        this.nameTextField = new TextField("name");
        componentArray[0] = this.nameTextField;
        this.styleForm.add(componentArray);
        this.nameTextField.setRequired(true);
        this.wsChoice = new DropDownChoice("workspace", (IModel)new WorkspacesModel(), (IChoiceRenderer)new WorkspaceChoiceRenderer());
        this.wsChoice.setNullValid(true);
        if (!this.isAuthenticatedAsAdmin()) {
            this.wsChoice.setNullValid(false);
            this.wsChoice.setRequired(true);
        }
        this.styleForm.add(new Component[]{this.wsChoice});
        this.formatChoice = new DropDownChoice("format", (IModel)new PropertyModel((Object)this, "format"), (IModel)new StyleFormatsModel(), (IChoiceRenderer)new ChoiceRenderer<String>(){

            public String getIdValue(String object, int index) {
                return object;
            }

            public Object getDisplayValue(String object) {
                return Styles.handler((String)object).getName();
            }
        });
        this.formatChoice.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                target.appendJavascript(String.format("if (document.gsEditors) { document.gsEditors.editor.setOption('mode', '%s'); }", AbstractStylePage.this.styleHandler().getCodeMirrorEditMode()));
            }
        }});
        this.styleForm.add(new Component[]{this.formatChoice});
        this.formatReadOnlyMessage = new WebMarkupContainer("formatReadOnly", (IModel)new Model());
        this.formatReadOnlyMessage.setVisible(false);
        this.styleForm.add(new Component[]{this.formatReadOnlyMessage});
        Component[] componentArray2 = new Component[1];
        this.editor = new CodeMirrorEditor("styleEditor", this.styleHandler().getCodeMirrorEditMode(), (IModel)new PropertyModel((Object)this, "rawStyle"));
        componentArray2[0] = this.editor;
        this.styleForm.add(componentArray2);
        this.editor.setTextAreaMarkupId("editor");
        this.editor.setOutputMarkupId(true);
        this.editor.setRequired(true);
        this.styleForm.add(new Component[]{this.editor});
        if (style != null) {
            try {
                this.setRawStyle(this.readFile(style));
            }
            catch (IOException e) {
                Session.get().error(new ParamResourceModel("styleNotFound", (Component)this, new Object[]{style.getFilename()}).getString());
            }
        }
        this.templates = new DropDownChoice("templates", (IModel)new Model(), (IModel)new StyleTypeModel(), (IChoiceRenderer)new StyleTypeChoiceRenderer());
        this.templates.setOutputMarkupId(true);
        this.templates.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                AbstractStylePage.this.templates.validate();
                AbstractStylePage.this.generateLink.setEnabled(AbstractStylePage.this.templates.getConvertedInput() != null);
                target.addComponent((Component)AbstractStylePage.this.generateLink);
            }
        }});
        this.styleForm.add(new Component[]{this.templates});
        this.generateLink = this.generateLink();
        this.generateLink.setEnabled(false);
        this.styleForm.add(new Component[]{this.generateLink});
        this.styles = new DropDownChoice("existingStyles", (IModel)new Model(), (IModel)new StylesModel(), (IChoiceRenderer)new StyleChoiceRenderer());
        this.styles.setOutputMarkupId(true);
        this.styles.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                AbstractStylePage.this.styles.validate();
                AbstractStylePage.this.copyLink.setEnabled(AbstractStylePage.this.styles.getConvertedInput() != null);
                target.addComponent((Component)AbstractStylePage.this.copyLink);
            }
        }});
        this.styleForm.add(new Component[]{this.styles});
        this.copyLink = this.copyLink();
        this.copyLink.setEnabled(false);
        this.styleForm.add(new Component[]{this.copyLink});
        this.uploadForm = this.uploadForm(this.styleForm);
        this.uploadForm.setMultiPart(true);
        this.uploadForm.setMaxSize(Bytes.megabytes((long)1L));
        this.uploadForm.setMarkupId("uploadForm");
        this.add(new Component[]{this.uploadForm});
        Component[] componentArray3 = new Component[1];
        this.fileUploadField = new FileUploadField("filename");
        componentArray3[0] = this.fileUploadField;
        this.uploadForm.add(componentArray3);
        this.add(new Component[]{this.validateLink()});
        this.add(new Component[]{this.previewLink()});
        Link cancelLink = new Link("cancel"){

            public void onClick() {
                AbstractStylePage.this.doReturn(StylePage.class);
            }
        };
        this.add(new Component[]{cancelLink});
        this.legendContainer = new WebMarkupContainer("legendContainer");
        this.legendContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.legendContainer});
        this.legend = new Image("legend");
        this.legendContainer.add(new Component[]{this.legend});
        this.legend.setVisible(false);
        this.legend.setOutputMarkupId(true);
        this.legend.setImageResource((Resource)new DynamicWebResource(){

            protected DynamicWebResource.ResourceState getResourceState() {
                return new DynamicWebResource.ResourceState(){

                    public byte[] getData() {
                        GeoServerDataDirectory dd = (GeoServerDataDirectory)GeoServerExtensions.bean(GeoServerDataDirectory.class, (ApplicationContext)AbstractStylePage.this.getGeoServerApplication().getApplicationContext());
                        StyleInfoImpl si = new StyleInfoImpl(AbstractStylePage.this.getCatalog());
                        String styleName = "tmp" + UUID.randomUUID().toString();
                        String styleFileName = styleName + ".sld";
                        si.setFilename(styleFileName);
                        si.setName(styleName);
                        si.setWorkspace((WorkspaceInfo)AbstractStylePage.this.wsChoice.getModel().getObject());
                        File styleFile = null;
                        try {
                            styleFile = dd.findOrCreateStyleSldFile((StyleInfo)si);
                            FileUtils.writeStringToFile((File)styleFile, (String)AbstractStylePage.this.lastStyle);
                            StyledLayerDescriptor sld = AbstractStylePage.this.styleHandler().parse((Object)styleFile, null, null, null);
                            if (sld != null && sld.getStyledLayers().length > 0) {
                                Style style = null;
                                StyledLayer sl = sld.getStyledLayers()[0];
                                style = sl instanceof UserLayer ? ((UserLayer)sl).getUserStyles()[0] : ((NamedLayer)sl).getStyles()[0];
                                GetLegendGraphicRequest request = new GetLegendGraphicRequest();
                                request.setStyle(style);
                                request.setLayer(null);
                                request.setStrict(false);
                                HashMap<String, String> legendOptions = new HashMap<String, String>();
                                legendOptions.put("forceLabels", "on");
                                legendOptions.put("fontAntiAliasing", "true");
                                request.setLegendOptions(legendOptions);
                                BufferedImageLegendGraphicBuilder builder = new BufferedImageLegendGraphicBuilder();
                                BufferedImage image = builder.buildLegendGraphic(request);
                                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                                ImageIO.write((RenderedImage)image, "PNG", bos);
                                byte[] byArray = bos.toByteArray();
                                return byArray;
                            }
                            AbstractStylePage.this.error((Serializable)((Object)"Failed to build legend preview"));
                            byte[] byArray = null;
                            return byArray;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        finally {
                            FileUtils.deleteQuietly((File)styleFile);
                        }
                    }

                    public String getContentType() {
                        return "image/png";
                    }
                };
            }
        });
    }

    StyleHandler styleHandler() {
        return Styles.handler((String)((String)this.formatChoice.getModelObject()));
    }

    Form uploadForm(final Form form) {
        return new Form("uploadForm"){

            protected void onSubmit() {
                FileUpload upload = AbstractStylePage.this.fileUploadField.getFileUpload();
                if (upload == null) {
                    this.warn("No file selected.");
                    return;
                }
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                try {
                    IOUtils.copy((InputStream)upload.getInputStream(), (OutputStream)bout);
                    AbstractStylePage.this.setRawStyle(new InputStreamReader((InputStream)new ByteArrayInputStream(bout.toByteArray()), "UTF-8"));
                    AbstractStylePage.this.editor.setModelObject((Object)AbstractStylePage.this.rawStyle);
                }
                catch (IOException e) {
                    throw new WicketRuntimeException((Throwable)e);
                }
                StyleInfo s = (StyleInfo)form.getModelObject();
                if (s.getName() == null || "".equals(s.getName().trim())) {
                    AbstractStylePage.this.nameTextField.setModelValue(ResponseUtils.stripExtension((String)upload.getClientFileName()));
                    AbstractStylePage.this.nameTextField.modelChanged();
                }
            }
        };
    }

    Component validateLink() {
        return new GeoServerAjaxFormLink("validate", this.styleForm){

            protected void onClick(AjaxRequestTarget target, Form form) {
                AbstractStylePage.this.editor.processInput();
                List<Exception> errors = AbstractStylePage.this.validateSLD();
                if (errors.isEmpty()) {
                    form.info("No validation errors.");
                } else {
                    for (Exception e : errors) {
                        form.error((Serializable)((Object)AbstractStylePage.this.sldErrorWithLineNo(e)));
                    }
                }
            }

            protected IAjaxCallDecorator getAjaxCallDecorator() {
                return AbstractStylePage.this.editor.getSaveDecorator();
            }
        };
    }

    Component previewLink() {
        return new GeoServerAjaxFormLink("preview", this.styleForm){

            protected void onClick(AjaxRequestTarget target, Form form) {
                AbstractStylePage.this.editor.processInput();
                AbstractStylePage.this.wsChoice.processInput();
                AbstractStylePage.this.lastStyle = AbstractStylePage.this.editor.getInput();
                AbstractStylePage.this.legend.setVisible(true);
                target.addComponent((Component)AbstractStylePage.this.legendContainer);
            }

            protected IAjaxCallDecorator getAjaxCallDecorator() {
                return AbstractStylePage.this.editor.getSaveDecorator();
            }
        };
    }

    private String sldErrorWithLineNo(Exception e) {
        if (e instanceof SAXParseException) {
            SAXParseException se = (SAXParseException)e;
            return "line " + se.getLineNumber() + ": " + e.getLocalizedMessage();
        }
        String message = e.getLocalizedMessage();
        if (message != null) {
            return message;
        }
        return new ParamResourceModel("genericError", (Component)this, new Object[0]).getString();
    }

    List<Exception> validateSLD() {
        try {
            String sld = this.editor.getInput();
            ByteArrayInputStream input = new ByteArrayInputStream(sld.getBytes());
            List validationErrors = this.styleHandler().validate((Object)input, null, null);
            return validationErrors;
        }
        catch (Exception e) {
            return Arrays.asList(e);
        }
    }

    AjaxSubmitLink generateLink() {
        return new AjaxSubmitLink("generate"){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                AbstractStylePage.this.templates.processInput();
                StyleType template = (StyleType)AbstractStylePage.this.templates.getConvertedInput();
                StyleGenerator styleGen = new StyleGenerator(AbstractStylePage.this.getCatalog());
                styleGen.setWorkspace((WorkspaceInfo)AbstractStylePage.this.wsChoice.getModel().getObject());
                if (template != null) {
                    try {
                        AbstractStylePage.this.editor.reset();
                        AbstractStylePage.this.setRawStyle(new StringReader(styleGen.generateStyle(AbstractStylePage.this.styleHandler(), template, AbstractStylePage.this.nameTextField.getInput())));
                        target.appendJavascript(String.format("if (document.gsEditors) { document.gsEditors.editor.setOption('mode', '%s'); }", AbstractStylePage.this.styleHandler().getCodeMirrorEditMode()));
                    }
                    catch (Exception e) {
                        this.error((Serializable)((Object)"Errors occurred generating the style"));
                    }
                    target.addComponent((Component)AbstractStylePage.this.styleForm);
                }
            }

            protected IAjaxCallDecorator getAjaxCallDecorator() {
                return new AjaxPreprocessingCallDecorator(super.getAjaxCallDecorator()){

                    public CharSequence preDecorateScript(CharSequence script) {
                        return "var val = event.view.document.gsEditors ? event.view.document.gsEditors." + AbstractStylePage.this.editor.getTextAreaMarkupId() + ".getValue() : " + "event.view.document.getElementById(\"" + AbstractStylePage.this.editor.getTextAreaMarkupId() + "\").value; " + "if(val != '' &&" + "!confirm('" + new ParamResourceModel("confirmOverwrite", (Component)AbstractStylePage.this, new Object[0]).getString() + "')) return false;" + script;
                    }
                };
            }

            public boolean getDefaultFormProcessing() {
                return false;
            }
        };
    }

    AjaxSubmitLink copyLink() {
        return new AjaxSubmitLink("copy"){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                AbstractStylePage.this.styles.processInput();
                StyleInfo style = (StyleInfo)AbstractStylePage.this.styles.getConvertedInput();
                if (style != null) {
                    try {
                        AbstractStylePage.this.editor.reset();
                        AbstractStylePage.this.setRawStyle(AbstractStylePage.this.readFile(style));
                        AbstractStylePage.this.formatChoice.setModelObject((Object)style.getFormat());
                        target.appendJavascript(String.format("if (document.gsEditors) { document.gsEditors.editor.setOption('mode', '%s'); }", AbstractStylePage.this.styleHandler().getCodeMirrorEditMode()));
                    }
                    catch (Exception e) {
                        this.error((Serializable)((Object)("Errors occurred loading the '" + style.getName() + "' style")));
                    }
                    target.addComponent((Component)AbstractStylePage.this.styleForm);
                }
            }

            protected IAjaxCallDecorator getAjaxCallDecorator() {
                return new AjaxPreprocessingCallDecorator(super.getAjaxCallDecorator()){

                    public CharSequence preDecorateScript(CharSequence script) {
                        return "var val = event.view.document.gsEditors ? event.view.document.gsEditors." + AbstractStylePage.this.editor.getTextAreaMarkupId() + ".getValue() : " + "event.view.document.getElementById(\"" + AbstractStylePage.this.editor.getTextAreaMarkupId() + "\").value; " + "if(val != '' &&" + "!confirm('" + new ParamResourceModel("confirmOverwrite", (Component)AbstractStylePage.this, new Object[0]).getString() + "')) return false;" + script;
                    }
                };
            }

            public boolean getDefaultFormProcessing() {
                return false;
            }
        };
    }

    Reader readFile(StyleInfo style) throws IOException {
        ResourcePool pool = this.getCatalog().getResourcePool();
        return pool.readStyle(style);
    }

    public void setRawStyle(Reader in) throws IOException {
        BufferedReader bin = null;
        bin = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
        StringBuilder builder = new StringBuilder();
        String line = null;
        while ((line = bin.readLine()) != null) {
            builder.append(line).append("\n");
        }
        this.rawStyle = builder.toString();
        this.editor.setModelObject((Object)this.rawStyle);
        in.close();
    }

    protected abstract void onStyleFormSubmit();

    protected ComponentAuthorizer getPageAuthorizer() {
        return ComponentAuthorizer.WORKSPACE_ADMIN;
    }
}

