/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.extensions.markup.html.form.palette.component.Recorder;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.web.wicket.SimpleChoiceRenderer;

public class MimeTypesFormComponent
extends FormComponentPanel {
    protected Palette<String> palette;
    protected AjaxCheckBox allMimeTypesCheckBox;
    List<IBehavior> toAdd = new ArrayList<IBehavior>();

    public MimeTypesFormComponent(String id, IModel<List<String>> model, IModel<Collection<String>> choicesModel, boolean isMimeTypeCheckingEnabled) {
        super(id, (IModel)new Model());
        this.add(new Component[]{new AjaxCheckBox("mimeTypeCheckingEnabled", (IModel)new Model((Serializable)Boolean.valueOf(isMimeTypeCheckingEnabled))){

            protected void onUpdate(AjaxRequestTarget target) {
                MimeTypesFormComponent.this.toggleVisibility((Boolean)this.getModelObject());
                target.addComponent(MimeTypesFormComponent.this.palette);
            }
        }});
        Component[] componentArray = new Component[1];
        this.palette = new Palette<String>("palette", model, choicesModel, (IChoiceRenderer)new SimpleChoiceRenderer(), 10, false){
            private static final long serialVersionUID = 1L;

            protected Recorder<String> newRecorderComponent() {
                Recorder rec = super.newRecorderComponent();
                rec.add(MimeTypesFormComponent.this.toAdd.toArray(new IBehavior[MimeTypesFormComponent.this.toAdd.size()]));
                MimeTypesFormComponent.this.toAdd.clear();
                return rec;
            }

            public Component newSelectedHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel(MimeTypesFormComponent.this.getSelectedHeaderPropertyKey()));
            }

            public Component newAvailableHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel(MimeTypesFormComponent.this.getAvaliableHeaderPropertyKey()));
            }
        };
        componentArray[0] = this.palette;
        this.add(componentArray);
        this.palette.setOutputMarkupPlaceholderTag(true);
        this.toggleVisibility(isMimeTypeCheckingEnabled);
    }

    void toggleVisibility(boolean visible) {
        this.palette.setVisible(visible);
        if (!visible) {
            this.palette.getModelCollection().clear();
        }
    }

    public void setMimeTypeCheckingEnabled(boolean enabled) {
        this.get("mimeTypeCheckingEnabled").setDefaultModelObject((Object)enabled);
        this.toggleVisibility(enabled);
    }

    public boolean isMimeTypeCheckingEnabled() {
        return (Boolean)this.get("mimeTypeCheckingEnabled").getDefaultModelObject();
    }

    protected String getSelectedHeaderPropertyKey() {
        return "MimeTypesFormComponent.selectedHeader";
    }

    protected String getAvaliableHeaderPropertyKey() {
        return "MimeTypesFormComponent.availableHeader";
    }

    public Component add(IBehavior ... behaviors) {
        if (this.palette.getRecorderComponent() == null) {
            this.toAdd.addAll(Arrays.asList(behaviors));
        } else {
            this.palette.getRecorderComponent().add(behaviors);
        }
        return this;
    }

    public Palette<String> getPalette() {
        return this.palette;
    }

    public IModel<List<String>> getPaletteModel() {
        return this.palette.getDefaultModel();
    }

    public void updateModel() {
        super.updateModel();
        if (this.palette.getRecorderComponent() != null) {
            this.palette.getRecorderComponent().updateModel();
        }
    }
}

