/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.jdbc;

import java.util.Arrays;
import java.util.List;
import org.geowebcache.diskquota.jdbc.SQLDialect;

public class OracleDialect
extends SQLDialect {
    public OracleDialect() {
        this.TABLE_CREATION_MAP.put("TILESET", Arrays.asList("CREATE TABLE ${schema}TILESET (\n  KEY VARCHAR(320) PRIMARY KEY,\n  LAYER_NAME VARCHAR(128),\n  GRIDSET_ID VARCHAR(32),\n  BLOB_FORMAT VARCHAR(64),\n  PARAMETERS_ID VARCHAR(41),\n  BYTES NUMBER(21) DEFAULT 0 NOT NULL\n) ORGANIZATION INDEX", "CREATE INDEX TILESET_LAYER ON TILESET(LAYER_NAME)"));
        this.TABLE_CREATION_MAP.put("TILEPAGE", Arrays.asList("CREATE TABLE ${schema}TILEPAGE (\n KEY VARCHAR(320) PRIMARY KEY,\n TILESET_ID VARCHAR(320) REFERENCES ${schema}TILESET(KEY) ON DELETE CASCADE,\n PAGE_Z SMALLINT,\n PAGE_X INTEGER,\n PAGE_Y INTEGER,\n CREATION_TIME_MINUTES INTEGER,\n FREQUENCY_OF_USE FLOAT,\n LAST_ACCESS_TIME_MINUTES INTEGER,\n FILL_FACTOR FLOAT,\n NUM_HITS NUMBER(64)\n) ORGANIZATION INDEX", "CREATE INDEX TILEPAGE_TILESET ON TILEPAGE(TILESET_ID)", "CREATE INDEX TILEPAGE_FILL_FACTOR ON TILEPAGE(FILL_FACTOR)", "CREATE INDEX TILEPAGE_FREQUENCY ON TILEPAGE(FREQUENCY_OF_USE DESC)", "CREATE INDEX TILEPAGE_LAST_ACCESS ON TILEPAGE(LAST_ACCESS_TIME_MINUTES DESC)"));
    }

    @Override
    protected void addEmtpyTableReference(StringBuilder sb) {
        sb.append("FROM DUAL");
    }

    @Override
    public String getLeastFrequentlyUsedPage(String schema, List<String> layerParamNames) {
        StringBuilder sb = new StringBuilder("SELECT * FROM (");
        sb.append("SELECT TILESET_ID, PAGE_X, PAGE_Y, PAGE_Z, CREATION_TIME_MINUTES FROM ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILEPAGE WHERE FILL_FACTOR > 0 ");
        sb.append("AND TILESET_ID IN (");
        sb.append("SELECT KEY FROM ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILESET WHERE LAYER_NAME IN (");
        for (int i = 0; i < layerParamNames.size(); ++i) {
            sb.append(":" + layerParamNames.get(i));
            if (i >= layerParamNames.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")) ORDER BY FREQUENCY_OF_USE ASC");
        sb.append(") WHERE ROWNUM <= 1");
        return sb.toString();
    }

    @Override
    public String getLeastRecentlyUsedPage(String schema, List<String> layerParamNames) {
        StringBuilder sb = new StringBuilder("SELECT * FROM (");
        sb.append("SELECT TILESET_ID, PAGE_X, PAGE_Y, PAGE_Z, CREATION_TIME_MINUTES FROM ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILEPAGE WHERE FILL_FACTOR > 0 ");
        sb.append("AND TILESET_ID IN (");
        sb.append("SELECT KEY FROM ");
        if (schema != null) {
            sb.append(schema).append(".");
        }
        sb.append("TILESET WHERE LAYER_NAME IN (");
        for (int i = 0; i < layerParamNames.size(); ++i) {
            sb.append(":" + layerParamNames.get(i));
            if (i >= layerParamNames.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(")) ORDER BY LAST_ACCESS_TIME_MINUTES ASC");
        sb.append(") WHERE ROWNUM <= 1");
        return sb.toString();
    }
}

