/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.jdbc;

import java.io.Closeable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.diskquota.QuotaStore;
import org.geowebcache.diskquota.jdbc.SQLDialect;
import org.geowebcache.diskquota.jdbc.SimpleJdbcTemplate;
import org.geowebcache.diskquota.storage.PageStats;
import org.geowebcache.diskquota.storage.PageStatsPayload;
import org.geowebcache.diskquota.storage.Quota;
import org.geowebcache.diskquota.storage.TilePage;
import org.geowebcache.diskquota.storage.TilePageCalculator;
import org.geowebcache.diskquota.storage.TileSet;
import org.geowebcache.diskquota.storage.TileSetVisitor;
import org.geowebcache.storage.DefaultStorageFinder;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DeadlockLoserDataAccessException;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class JDBCQuotaStore
implements QuotaStore {
    private static final Log log = LogFactory.getLog(JDBCQuotaStore.class);
    public static final String GLOBAL_QUOTA_NAME = "___GLOBAL_QUOTA___";
    SQLDialect dialect;
    SimpleJdbcTemplate jt;
    TransactionTemplate tt;
    String schema;
    DefaultStorageFinder finder;
    TilePageCalculator calculator;
    int maxLoops = 100;
    ExecutorService executor;
    private DataSource dataSource;

    public JDBCQuotaStore(DefaultStorageFinder finder, TilePageCalculator tilePageCalculator) {
        this.finder = finder;
        this.calculator = tilePageCalculator;
        this.executor = Executors.newFixedThreadPool(1);
    }

    public SQLDialect getDialect() {
        return this.dialect;
    }

    public void setDialect(SQLDialect dialect) {
        this.dialect = dialect;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        DataSourceTransactionManager dsTransactionManager = new DataSourceTransactionManager(dataSource);
        this.tt = new TransactionTemplate((PlatformTransactionManager)dsTransactionManager);
        this.jt = new SimpleJdbcTemplate(dsTransactionManager.getDataSource());
    }

    public void initialize() {
        if (this.dialect == null || this.jt == null || this.tt == null) {
            throw new IllegalStateException("Please provide both the sql dialect and the data source before calling inizialize");
        }
        this.tt.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                JDBCQuotaStore.this.dialect.initializeTables(JDBCQuotaStore.this.schema, JDBCQuotaStore.this.jt);
                List existingLayers = JDBCQuotaStore.this.jt.query(JDBCQuotaStore.this.dialect.getAllLayersQuery(JDBCQuotaStore.this.schema), (ParameterizedRowMapper)new ParameterizedRowMapper<String>(){

                    public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                        return rs.getString(1);
                    }
                }, new Object[0]);
                Set layerNames = JDBCQuotaStore.this.calculator.getLayerNames();
                HashSet layersToDelete = new HashSet(existingLayers);
                layersToDelete.removeAll(layerNames);
                for (String layerName : layersToDelete) {
                    JDBCQuotaStore.this.deleteLayer(layerName);
                }
                for (String layerName : layerNames) {
                    JDBCQuotaStore.this.createLayerInternal(layerName);
                }
                Quota global = JDBCQuotaStore.this.getUsedQuotaByTileSetIdInternal(JDBCQuotaStore.GLOBAL_QUOTA_NAME);
                if (global == null) {
                    JDBCQuotaStore.this.createLayerInternal(JDBCQuotaStore.GLOBAL_QUOTA_NAME);
                }
            }
        });
    }

    public void createLayer(String layerName) throws InterruptedException {
        this.createLayerInternal(layerName);
    }

    private void createLayerInternal(final String layerName) {
        this.tt.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                Set layerTileSets = !JDBCQuotaStore.GLOBAL_QUOTA_NAME.equals(layerName) ? JDBCQuotaStore.this.calculator.getTileSetsFor(layerName) : Collections.singleton(new TileSet(JDBCQuotaStore.GLOBAL_QUOTA_NAME));
                for (TileSet tset : layerTileSets) {
                    JDBCQuotaStore.this.getOrCreateTileSet(tset);
                }
            }
        });
    }

    public Quota getGloballyUsedQuota() throws InterruptedException {
        return this.getUsedQuotaByTileSetIdInternal(GLOBAL_QUOTA_NAME);
    }

    public Quota getUsedQuotaByTileSetId(String tileSetId) {
        return this.getUsedQuotaByTileSetIdInternal(tileSetId);
    }

    public Quota getUsedQuotaByLayerName(String layerName) {
        String sql = this.dialect.getUsedQuotaByLayerName(this.schema, "layerName");
        return this.jt.queryForOptionalObject(sql, new DiskQuotaMapper(), Collections.singletonMap("layerName", layerName));
    }

    public Quota getUsedQuotaByGridsetid(String gridsetId) {
        String sql = this.dialect.getUsedQuotaByGridSetId(this.schema, "gridSetId");
        return this.jt.queryForOptionalObject(sql, new DiskQuotaMapper(), Collections.singletonMap("gridSetId", gridsetId));
    }

    protected Quota getUsedQuotaByTileSetIdInternal(final String tileSetId) {
        String sql = this.dialect.getUsedQuotaByTileSetId(this.schema, "key");
        return this.jt.queryForOptionalObject(sql, new ParameterizedRowMapper<Quota>(){

            public Quota mapRow(ResultSet rs, int rowNum) throws SQLException {
                BigDecimal bytes = rs.getBigDecimal(1);
                Quota quota = new Quota(bytes.toBigInteger());
                quota.setTileSetId(tileSetId);
                return quota;
            }
        }, Collections.singletonMap("key", tileSetId));
    }

    public void deleteLayer(final String layerName) {
        this.tt.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                JDBCQuotaStore.this.deleteLayerInternal(layerName);
            }
        });
    }

    public void deleteGridSubset(final String layerName, final String gridSetId) {
        this.tt.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                Quota quota = JDBCQuotaStore.this.getUsedQuotaByGridsetid(gridSetId);
                quota.setBytes(quota.getBytes().negate());
                String updateQuota = JDBCQuotaStore.this.dialect.getUpdateQuotaStatement(JDBCQuotaStore.this.schema, "tileSetId", "bytes");
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("tileSetId", JDBCQuotaStore.GLOBAL_QUOTA_NAME);
                params.put("bytes", new BigDecimal(quota.getBytes()));
                JDBCQuotaStore.this.jt.update(updateQuota, params);
                String statement = JDBCQuotaStore.this.dialect.getLayerGridDeletionStatement(JDBCQuotaStore.this.schema, "layerName", "gridSetId");
                params = new HashMap();
                params.put("layerName", layerName);
                params.put("gridSetId", gridSetId);
                JDBCQuotaStore.this.jt.update(statement, params);
            }
        });
    }

    public void deleteLayerInternal(final String layerName) {
        this.getUsedQuotaByLayerName(layerName);
        this.tt.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus arg0) {
                Quota quota = JDBCQuotaStore.this.getUsedQuotaByLayerName(layerName);
                quota.setBytes(quota.getBytes().negate());
                String updateQuota = JDBCQuotaStore.this.dialect.getUpdateQuotaStatement(JDBCQuotaStore.this.schema, "tileSetId", "bytes");
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("tileSetId", JDBCQuotaStore.GLOBAL_QUOTA_NAME);
                params.put("bytes", new BigDecimal(quota.getBytes()));
                JDBCQuotaStore.this.jt.update(updateQuota, params);
                log.info((Object)("Deleting disk quota information for layer '" + layerName + "'"));
                String statement = JDBCQuotaStore.this.dialect.getLayerDeletionStatement(JDBCQuotaStore.this.schema, "layerName");
                JDBCQuotaStore.this.jt.update(statement, Collections.singletonMap("layerName", layerName));
            }
        });
    }

    public void renameLayer(final String oldLayerName, final String newLayerName) throws InterruptedException {
        this.tt.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                String sql = JDBCQuotaStore.this.dialect.getRenameLayerStatement(JDBCQuotaStore.this.schema, "oldName", "newName");
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("oldName", oldLayerName);
                params.put("newName", newLayerName);
                int updated = JDBCQuotaStore.this.jt.update(sql, params);
                log.info((Object)("Updated " + updated + " tile sets after layer rename"));
            }
        });
    }

    public Set<TileSet> getTileSets() {
        String getTileSet = this.dialect.getTileSetsQuery(this.schema);
        List tilesets = this.jt.query(getTileSet, new TileSetRowMapper(), new Object[0]);
        HashSet<TileSet> result = new HashSet<TileSet>();
        for (TileSet ts : tilesets) {
            if (GLOBAL_QUOTA_NAME.equals(ts.getId())) continue;
            result.add(ts);
        }
        return result;
    }

    public void accept(final TileSetVisitor visitor) {
        String getTileSet = this.dialect.getTileSetsQuery(this.schema);
        final TileSetRowMapper tileSetMapper = new TileSetRowMapper();
        this.jt.getJdbcOperations().query(getTileSet, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                TileSet tileSet = tileSetMapper.mapRow(rs, 0);
                if (!JDBCQuotaStore.GLOBAL_QUOTA_NAME.equals(tileSet.getId())) {
                    visitor.visit(tileSet, (QuotaStore)JDBCQuotaStore.this);
                }
            }
        });
    }

    public TileSet getTileSetById(String tileSetId) throws InterruptedException {
        TileSet result = this.getTileSetByIdInternal(tileSetId);
        if (result == null) {
            throw new IllegalArgumentException("Could not find a tile set with id: " + tileSetId);
        }
        return result;
    }

    private TileSet getTileSetByIdInternal(String tileSetId) {
        String getTileSet = this.dialect.getTileSetQuery(this.schema, "key");
        TileSetRowMapper tileSetMapper = new TileSetRowMapper();
        return this.jt.queryForOptionalObject(getTileSet, tileSetMapper, Collections.singletonMap("key", tileSetId));
    }

    private boolean createTileSet(TileSet tset) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating tileset " + tset));
        }
        String createTileSet = this.dialect.getCreateTileSetQuery(this.schema, "key", "layerName", "gridSetId", "blobFormat", "parametersId");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", tset.getId());
        params.put("layerName", tset.getLayerName());
        params.put("gridSetId", tset.getGridsetId());
        params.put("blobFormat", tset.getBlobFormat());
        params.put("parametersId", tset.getParametersId());
        return this.jt.update(createTileSet, params) > 0;
    }

    protected TileSet getOrCreateTileSet(TileSet tileSet) {
        DataAccessException lastException = null;
        for (int i = 0; i < this.maxLoops; ++i) {
            TileSet tset = this.getTileSetByIdInternal(tileSet.getId());
            if (tset != null) {
                return tset;
            }
            try {
                if (!this.createTileSet(tileSet)) continue;
                return tileSet;
            }
            catch (DataAccessException e) {
                lastException = e;
            }
        }
        throw new ConcurrencyFailureException("Failed to create or locate tileset " + tileSet + " after " + this.maxLoops + " attempts", (Throwable)lastException);
    }

    public TilePageCalculator getTilePageCalculator() {
        return this.calculator;
    }

    public void addToQuotaAndTileCounts(final TileSet tileSet, final Quota quotaDiff, final Collection<PageStatsPayload> tileCountDiffs) throws InterruptedException {
        this.tt.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                JDBCQuotaStore.this.getOrCreateTileSet(tileSet);
                this.updateQuotas(tileSet, quotaDiff);
                if (tileCountDiffs != null) {
                    List<PageStatsPayload> sorted = JDBCQuotaStore.this.sortPayloads(tileCountDiffs);
                    for (PageStatsPayload payload : sorted) {
                        this.upsertTilePageFillFactor(payload);
                    }
                }
            }

            private void updateQuotas(TileSet tileSet2, Quota quotaDiff2) {
                if (log.isDebugEnabled()) {
                    log.info((Object)("Applying quota diff " + quotaDiff2.getBytes() + " on tileset " + tileSet2));
                }
                String updateQuota = JDBCQuotaStore.this.dialect.getUpdateQuotaStatement(JDBCQuotaStore.this.schema, "tileSetId", "bytes");
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("tileSetId", tileSet2.getId());
                params.put("bytes", new BigDecimal(quotaDiff2.getBytes()));
                JDBCQuotaStore.this.jt.update(updateQuota, params);
                params.put("tileSetId", JDBCQuotaStore.GLOBAL_QUOTA_NAME);
                JDBCQuotaStore.this.jt.update(updateQuota, params);
            }

            private void upsertTilePageFillFactor(PageStatsPayload payload) {
                if (log.isDebugEnabled()) {
                    log.info((Object)("Applying page stats payload " + payload));
                }
                TilePage page = payload.getPage();
                byte level = page.getZoomLevel();
                BigInteger tilesPerPage = JDBCQuotaStore.this.calculator.getTilesPerPage(tileSet, (int)level);
                int modified = 0;
                int count = 0;
                while (modified == 0 && count < JDBCQuotaStore.this.maxLoops) {
                    try {
                        ++count;
                        PageStats stats = JDBCQuotaStore.this.getPageStats(page.getKey());
                        if (stats != null) {
                            float oldFillFactor = stats.getFillFactor();
                            stats.addTiles((long)payload.getNumTiles(), tilesPerPage);
                            if (oldFillFactor == stats.getFillFactor()) {
                                return;
                            }
                            modified = JDBCQuotaStore.this.updatePageFillFactor(page, stats, oldFillFactor);
                            continue;
                        }
                        stats = new PageStats(0L);
                        stats.addTiles((long)payload.getNumTiles(), tilesPerPage);
                        modified = JDBCQuotaStore.this.createNewPageStats(stats, page);
                    }
                    catch (DeadlockLoserDataAccessException e) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)"Deadlock while updating page stats, will retry", (Throwable)e);
                    }
                }
                if (modified == 0) {
                    throw new ConcurrencyFailureException("Failed to create or update page stats for page " + payload.getPage() + " after " + count + " attempts");
                }
            }
        });
    }

    protected List<PageStatsPayload> sortPayloads(Collection<PageStatsPayload> tileCountDiffs) {
        ArrayList<PageStatsPayload> result = new ArrayList<PageStatsPayload>(tileCountDiffs);
        Collections.sort(result, new Comparator<PageStatsPayload>(){

            @Override
            public int compare(PageStatsPayload pl1, PageStatsPayload pl2) {
                TilePage p1 = pl1.getPage();
                TilePage p2 = pl2.getPage();
                return p1.getKey().compareTo(p2.getKey());
            }
        });
        return result;
    }

    private int updatePageFillFactor(TilePage page, PageStats stats, float oldFillFactor) {
        if (log.isDebugEnabled()) {
            log.info((Object)("Updating page " + page + " fill factor from  " + oldFillFactor + " to " + stats.getFillFactor()));
        }
        String update = this.dialect.conditionalUpdatePageStatsFillFactor(this.schema, "key", "fillFactor", "oldFillFactor");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("key", page.getKey());
        params.put("fillFactor", Float.valueOf(stats.getFillFactor()));
        params.put("oldFillFactor", Float.valueOf(oldFillFactor));
        return this.jt.update(update, params);
    }

    private int setPageFillFactor(TilePage page, PageStats stats) {
        if (log.isDebugEnabled()) {
            log.info((Object)("Setting page " + page + " fill factor to " + stats.getFillFactor()));
        }
        String update = this.dialect.updatePageStatsFillFactor(this.schema, "key", "fillFactor");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("key", page.getKey());
        params.put("fillFactor", Float.valueOf(stats.getFillFactor()));
        return this.jt.update(update, params);
    }

    private int createNewPageStats(PageStats stats, TilePage page) {
        if (log.isDebugEnabled()) {
            log.info((Object)("Creating new page stats: " + stats));
        }
        String insert = this.dialect.contionalTilePageInsertStatement(this.schema, "key", "tileSetId", "pageZ", "pageX", "pageY", "creationTime", "frequencyOfUse", "lastAccessTime", "fillFactor", "numHits");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("key", page.getKey());
        params.put("tileSetId", page.getTileSetId());
        params.put("pageZ", page.getZoomLevel());
        params.put("pageX", page.getPageX());
        params.put("pageY", page.getPageY());
        params.put("creationTime", page.getCreationTimeMinutes());
        params.put("frequencyOfUse", Float.valueOf(stats.getFrequencyOfUsePerMinute()));
        params.put("lastAccessTime", stats.getLastAccessTimeMinutes());
        params.put("fillFactor", Float.valueOf(stats.getFillFactor()));
        params.put("numHits", new BigDecimal(stats.getNumHits()));
        return this.jt.update(insert, params);
    }

    private PageStats getPageStats(String pageStatsKey) {
        String getPageStats = this.dialect.getPageStats(this.schema, "key");
        return this.jt.queryForOptionalObject(getPageStats, new ParameterizedRowMapper<PageStats>(){

            public PageStats mapRow(ResultSet rs, int rowNum) throws SQLException {
                PageStats ps = new PageStats(0L);
                ps.setFrequencyOfUsePerMinute(rs.getFloat(1));
                ps.setLastAccessMinutes(rs.getInt(2));
                ps.setFillFactor(rs.getFloat(3));
                ps.setNumHits(rs.getBigDecimal(4).toBigInteger());
                return ps;
            }
        }, Collections.singletonMap("key", pageStatsKey));
    }

    public Future<List<PageStats>> addHitsAndSetAccesTime(final Collection<PageStatsPayload> statsUpdates) {
        return this.executor.submit(new Callable<List<PageStats>>(){

            @Override
            public List<PageStats> call() throws Exception {
                return (List)JDBCQuotaStore.this.tt.execute(new TransactionCallback(){

                    public Object doInTransaction(TransactionStatus status) {
                        ArrayList<PageStats> result = new ArrayList<PageStats>();
                        if (statsUpdates != null) {
                            List<PageStatsPayload> sorted = JDBCQuotaStore.this.sortPayloads(statsUpdates);
                            for (PageStatsPayload payload : sorted) {
                                TileSet tset = payload.getTileSet();
                                if (tset == null) {
                                    String tileSetId = payload.getPage().getTileSetId();
                                    tset = JDBCQuotaStore.this.getTileSetByIdInternal(tileSetId);
                                    if (tset == null) {
                                        log.warn((Object)("Could not locate tileset with id " + tileSetId + ", skipping page stats update: " + payload));
                                    }
                                } else {
                                    JDBCQuotaStore.this.getOrCreateTileSet(tset);
                                }
                                PageStats stats = this.upsertTilePageHitAccessTime(payload);
                                result.add(stats);
                            }
                        }
                        return result;
                    }

                    private PageStats upsertTilePageHitAccessTime(PageStatsPayload payload) {
                        TilePage page = payload.getPage();
                        if (log.isDebugEnabled()) {
                            log.info((Object)("Updating page " + page + " with payload " + payload));
                        }
                        int modified = 0;
                        int count = 0;
                        PageStats stats = null;
                        while (modified == 0 && count < JDBCQuotaStore.this.maxLoops) {
                            try {
                                ++count;
                                stats = JDBCQuotaStore.this.getPageStats(page.getKey());
                                if (stats != null) {
                                    BigInteger oldHits = stats.getNumHits();
                                    float oldFrequency = stats.getFrequencyOfUsePerMinute();
                                    int oldAccessTime = stats.getLastAccessTimeMinutes();
                                    this.updatePageStats(payload, page, stats);
                                    String update = JDBCQuotaStore.this.dialect.updatePageStats(JDBCQuotaStore.this.schema, "key", "newHits", "oldHits", "newFrequency", "oldFrequency", "newAccessTime", "oldAccessTime");
                                    HashMap<String, Object> params = new HashMap<String, Object>();
                                    params.put("key", page.getKey());
                                    params.put("newHits", new BigDecimal(stats.getNumHits()));
                                    params.put("oldHits", new BigDecimal(oldHits));
                                    params.put("newFrequency", Float.valueOf(stats.getFrequencyOfUsePerMinute()));
                                    params.put("oldFrequency", Float.valueOf(oldFrequency));
                                    params.put("newAccessTime", stats.getLastAccessTimeMinutes());
                                    params.put("oldAccessTime", oldAccessTime);
                                    modified = JDBCQuotaStore.this.jt.update(update, params);
                                    continue;
                                }
                                stats = new PageStats(0L);
                                this.updatePageStats(payload, page, stats);
                                modified = JDBCQuotaStore.this.createNewPageStats(stats, page);
                            }
                            catch (DeadlockLoserDataAccessException e) {
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)"Deadlock while updating page stats, will retry", (Throwable)e);
                            }
                        }
                        if (modified == 0) {
                            throw new ConcurrencyFailureException("Failed to create or update page stats for page " + payload.getPage() + " after " + count + " attempts");
                        }
                        return stats;
                    }

                    private void updatePageStats(PageStatsPayload payload, TilePage page, PageStats stats) {
                        int addedHits = payload.getNumHits();
                        int lastAccessTimeMinutes = (int)(payload.getLastAccessTime() / 1000L / 60L);
                        int creationTimeMinutes = page.getCreationTimeMinutes();
                        stats.addHitsAndAccessTime((long)addedHits, lastAccessTimeMinutes, creationTimeMinutes);
                    }
                });
            }
        });
    }

    public long[][] getTilesForPage(TilePage page) throws InterruptedException {
        TileSet tileSet = this.getTileSetById(page.getTileSetId());
        long[][] gridCoverage = this.calculator.toGridCoverage(tileSet, page);
        return gridCoverage;
    }

    public TilePage getLeastFrequentlyUsedPage(Set<String> layerNames) throws InterruptedException {
        return this.getSinglePage(layerNames, true);
    }

    public TilePage getLeastRecentlyUsedPage(Set<String> layerNames) throws InterruptedException {
        return this.getSinglePage(layerNames, false);
    }

    private TilePage getSinglePage(Set<String> layerNames, boolean leastFrequentlyUsed) {
        HashMap<String, String> params = new HashMap<String, String>();
        ArrayList<String> layerParamNames = new ArrayList<String>();
        int i = 0;
        for (String layer : layerNames) {
            String param = "Layer" + ++i;
            params.put(param, layer);
            layerParamNames.add(param);
        }
        String select = leastFrequentlyUsed ? this.dialect.getLeastFrequentlyUsedPage(this.schema, layerParamNames) : this.dialect.getLeastRecentlyUsedPage(this.schema, layerParamNames);
        TilePageRowMapper mapper = new TilePageRowMapper();
        return this.jt.queryForOptionalObject(select, mapper, params);
    }

    public PageStats setTruncated(final TilePage page) throws InterruptedException {
        return (PageStats)this.tt.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                PageStats stats;
                if (log.isDebugEnabled()) {
                    log.info((Object)("Truncating page " + page));
                }
                if ((stats = JDBCQuotaStore.this.getPageStats(page.getKey())) != null) {
                    stats.setFillFactor(0.0f);
                    int modified = JDBCQuotaStore.this.setPageFillFactor(page, stats);
                    if (modified == 0) {
                        return null;
                    }
                }
                return stats;
            }
        });
    }

    public void close() throws Exception {
        log.info((Object)"Closing up the JDBC quota store ");
        if (this.dataSource instanceof BasicDataSource) {
            ((BasicDataSource)this.dataSource).close();
        } else if (this.dataSource instanceof Closeable) {
            ((Closeable)((Object)this.dataSource)).close();
        }
        this.tt = null;
        this.jt = null;
    }

    static class TilePageRowMapper
    implements ParameterizedRowMapper<TilePage> {
        TilePageRowMapper() {
        }

        public TilePage mapRow(ResultSet rs, int rowNum) throws SQLException {
            String tileSetId = rs.getString(1);
            int pageX = rs.getInt(2);
            int pageY = rs.getInt(3);
            int pageZ = rs.getInt(4);
            int creationTimeMinutes = rs.getInt(5);
            return new TilePage(tileSetId, pageX, pageY, pageZ, creationTimeMinutes);
        }
    }

    static class TileSetRowMapper
    implements ParameterizedRowMapper<TileSet> {
        TileSetRowMapper() {
        }

        public TileSet mapRow(ResultSet rs, int rowNum) throws SQLException {
            String key = rs.getString(1);
            String layerName = rs.getString(2);
            String gridSetId = rs.getString(3);
            String blobFormat = rs.getString(4);
            String parametersId = rs.getString(5);
            if (JDBCQuotaStore.GLOBAL_QUOTA_NAME.equals(key)) {
                return new TileSet(key);
            }
            return new TileSet(layerName, gridSetId, blobFormat, parametersId);
        }
    }

    static class DiskQuotaMapper
    implements ParameterizedRowMapper<Quota> {
        DiskQuotaMapper() {
        }

        public Quota mapRow(ResultSet rs, int rowNum) throws SQLException {
            BigDecimal bytes = rs.getBigDecimal(1);
            if (bytes == null) {
                bytes = BigDecimal.ZERO;
            }
            return new Quota(bytes.toBigInteger());
        }
    }
}

