/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.jdbc;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.io.GeoWebCacheXStream;

public class JDBCConfiguration
implements Serializable {
    String dialect;
    String JNDISource;
    ConnectionPoolConfiguration connectionPool;

    public static JDBCConfiguration load(File sourceFile) throws ConfigurationException {
        JDBCConfiguration jDBCConfiguration;
        XStream xs = JDBCConfiguration.getXStream();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(sourceFile);
            JDBCConfiguration conf = (JDBCConfiguration)xs.fromXML((InputStream)fis);
            JDBCConfiguration.validateConfiguration(conf);
            jDBCConfiguration = conf;
        }
        catch (IOException e) {
            try {
                throw new ConfigurationException("Failed to load the configuration from " + sourceFile.getAbsolutePath(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fis);
        return jDBCConfiguration;
    }

    private static void validateConfiguration(JDBCConfiguration conf) throws ConfigurationException {
        if (conf.getDialect() == null) {
            throw new ConfigurationException("A dialect must be provided, possible values are H2, Oracle, PostgresSQL");
        }
        ConnectionPoolConfiguration cp = conf.getConnectionPool();
        if (conf.getJNDISource() == null && cp == null && !"H2".equals(conf.getDialect())) {
            throw new ConfigurationException("No data source provided, either configure JNDISource or connectionPool");
        }
        if (cp != null) {
            if (cp.getDriver() == null) {
                throw new ConfigurationException("No JDBC driver provided");
            }
            if (cp.getUrl() == null) {
                throw new ConfigurationException("No JDBC URL provided");
            }
        }
    }

    public static void store(JDBCConfiguration config, File file) throws ConfigurationException {
        XStream xs = JDBCConfiguration.getXStream();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            xs.toXML((Object)config, (OutputStream)fos);
        }
        catch (IOException e) {
            try {
                throw new ConfigurationException("Failed to store the configuration into " + file.getAbsolutePath(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    private static XStream getXStream() {
        GeoWebCacheXStream xs = new GeoWebCacheXStream();
        xs.allowTypesByWildcard(new String[]{"org.geowebcache.**"});
        xs.setMode(1001);
        xs.alias("gwcJdbcConfiguration", JDBCConfiguration.class);
        xs.alias("connectionPool", ConnectionPoolConfiguration.class);
        return xs;
    }

    public String getJNDISource() {
        return this.JNDISource;
    }

    public void setJNDISource(String jndiSource) {
        this.JNDISource = jndiSource;
    }

    public ConnectionPoolConfiguration getConnectionPool() {
        return this.connectionPool;
    }

    public void setConnectionPool(ConnectionPoolConfiguration connectionPool) {
        this.connectionPool = connectionPool;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.JNDISource == null ? 0 : this.JNDISource.hashCode());
        result = 31 * result + (this.connectionPool == null ? 0 : this.connectionPool.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JDBCConfiguration other = (JDBCConfiguration)obj;
        if (this.JNDISource == null ? other.JNDISource != null : !this.JNDISource.equals(other.JNDISource)) {
            return false;
        }
        return !(this.connectionPool == null ? other.connectionPool != null : !this.connectionPool.equals(other.connectionPool));
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public String toString() {
        return "JDBCConfiguration [dialect=" + this.dialect + ", JNDISource=" + this.JNDISource + ", connectionPool=" + this.connectionPool + "]";
    }

    public static class ConnectionPoolConfiguration
    implements Serializable {
        private static final long serialVersionUID = 6677252877141737936L;
        String driver;
        String url;
        String username;
        String password;
        int minConnections;
        int maxConnections;
        int connectionTimeout;
        String validationQuery;
        int maxOpenPreparedStatements;

        public String getDriver() {
            return this.driver;
        }

        public void setDriver(String driver) {
            this.driver = driver;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public int getMinConnections() {
            return this.minConnections;
        }

        public void setMinConnections(int minConnections) {
            this.minConnections = minConnections;
        }

        public int getMaxConnections() {
            return this.maxConnections;
        }

        public void setMaxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
        }

        public int getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public void setConnectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }

        public String getValidationQuery() {
            return this.validationQuery;
        }

        public void setValidationQuery(String validationQuery) {
            this.validationQuery = validationQuery;
        }

        public int getMaxOpenPreparedStatements() {
            return this.maxOpenPreparedStatements;
        }

        public void setMaxOpenPreparedStatements(int maxOpenPreparedStatements) {
            this.maxOpenPreparedStatements = maxOpenPreparedStatements;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.connectionTimeout;
            result = 31 * result + (this.driver == null ? 0 : this.driver.hashCode());
            result = 31 * result + this.maxConnections;
            result = 31 * result + this.maxOpenPreparedStatements;
            result = 31 * result + this.minConnections;
            result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
            result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
            result = 31 * result + (this.validationQuery == null ? 0 : this.validationQuery.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConnectionPoolConfiguration other = (ConnectionPoolConfiguration)obj;
            if (this.connectionTimeout != other.connectionTimeout) {
                return false;
            }
            if (this.driver == null ? other.driver != null : !this.driver.equals(other.driver)) {
                return false;
            }
            if (this.maxConnections != other.maxConnections) {
                return false;
            }
            if (this.maxOpenPreparedStatements != other.maxOpenPreparedStatements) {
                return false;
            }
            if (this.minConnections != other.minConnections) {
                return false;
            }
            if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
                return false;
            }
            if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
                return false;
            }
            if (this.username == null ? other.username != null : !this.username.equals(other.username)) {
                return false;
            }
            return !(this.validationQuery == null ? other.validationQuery != null : !this.validationQuery.equals(other.validationQuery));
        }

        public String toString() {
            return "ConnectionPoolConfiguration [driver=" + this.driver + ", url=" + this.url + ", username=" + this.username + ", password=" + this.password + ", minConnections=" + this.minConnections + ", maxConnections=" + this.maxConnections + ", connectionTimeout=" + this.connectionTimeout + ", validationQuery=" + this.validationQuery + ", maxOpenPreparedStatements=" + this.maxOpenPreparedStatements + "]";
        }
    }
}

