/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.geoserver.platform.resource.Resource;

public class Resources {
    public static boolean exists(Resource resource) {
        return resource != null && resource.getType() != Resource.Type.UNDEFINED;
    }

    public static File find(Resource resource) {
        if (resource == null) {
            return null;
        }
        switch (resource.getType()) {
            case DIRECTORY: {
                return resource.dir();
            }
            case RESOURCE: {
                return resource.file();
            }
        }
        return null;
    }

    public static File directory(Resource resource) {
        return Resources.directory(resource, false);
    }

    public static File directory(Resource resource, boolean create) {
        File f = resource == null ? null : (create ? resource.dir() : (resource.getType() == Resource.Type.DIRECTORY ? resource.dir() : null));
        return f;
    }

    public static File file(Resource resource) {
        return Resources.file(resource, false);
    }

    public static File file(Resource resource, boolean create) {
        File f = resource == null ? null : (create ? resource.file() : (resource.getType() == Resource.Type.RESOURCE ? resource.file() : null));
        return f;
    }

    public static File createNewDirectory(Resource resource) throws IOException {
        switch (resource.getType()) {
            case DIRECTORY: {
                throw new IOException("New directory " + resource.path() + " already exists as DIRECTORY");
            }
            case RESOURCE: {
                throw new IOException("New directory " + resource.path() + " already exists as RESOURCE");
            }
            case UNDEFINED: {
                return resource.dir();
            }
        }
        return null;
    }

    public static File createNewFile(Resource resource) throws IOException {
        switch (resource.getType()) {
            case DIRECTORY: {
                throw new IOException("New file " + resource.path() + " already exists as DIRECTORY");
            }
            case RESOURCE: {
                throw new IOException("New file " + resource.path() + " already exists as RESOURCE");
            }
            case UNDEFINED: {
                return resource.file();
            }
        }
        return null;
    }

    public static List<Resource> search(Resource resource, long lastModified) {
        if (resource.getType() == Resource.Type.DIRECTORY) {
            ArrayList<Resource> results = new ArrayList<Resource>();
            for (Resource child : resource.list()) {
                switch (child.getType()) {
                    case RESOURCE: {
                        if (child.lastmodified() <= lastModified) break;
                        results.add(child);
                        break;
                    }
                }
            }
            return results;
        }
        return Collections.emptyList();
    }

    public static void copy(InputStream data, Resource destination) throws IOException {
        try (OutputStream out = destination.out();){
            IOUtils.copy((InputStream)data, (OutputStream)out);
        }
    }

    public static void copy(Resource data, Resource destination) throws IOException {
        try (InputStream in = data.in();){
            Resources.copy(in, destination);
        }
    }

    public static void copy(InputStream data, Resource directory, String filename) throws IOException {
        Resources.copy(data, directory.get(filename));
    }

    public static void copy(File data, Resource directory) throws IOException {
        String filename = data.getName();
        try (FileInputStream in = new FileInputStream(data);){
            Resources.copy(data, directory.get(filename));
        }
    }

    public static boolean renameByCopy(Resource source, Resource destination) {
        try {
            Resources.copy(source, destination);
            return source.delete();
        }
        catch (IOException e) {
            return false;
        }
    }
}

