/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.resource;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geoserver.platform.resource.Paths;

public class ResourceNotification {
    private final String path;
    private final Kind kind;
    private final List<Event> delta;
    private final long timestamp;

    public static List<Event> delta(File baseDirectory, List<File> created, List<File> removed, List<File> modified) {
        int size;
        if (created == null) {
            created = Collections.emptyList();
        }
        if (removed == null) {
            removed = Collections.emptyList();
        }
        if (modified == null) {
            modified = Collections.emptyList();
        }
        if ((size = created.size() + removed.size() + modified.size()) == 0) {
            return null;
        }
        ArrayList<Event> delta = new ArrayList<Event>(size);
        for (File file : created) {
            String newPath = Paths.convert(baseDirectory, file);
            delta.add(new Event(newPath, Kind.ENTRY_CREATE));
        }
        for (File file : removed) {
            String deletePath = Paths.convert(baseDirectory, file);
            delta.add(new Event(deletePath, Kind.ENTRY_DELETE));
        }
        for (File file : modified) {
            String changedPath = Paths.convert(baseDirectory, file);
            delta.add(new Event(changedPath, Kind.ENTRY_MODIFY));
        }
        return delta;
    }

    ResourceNotification(String path, Kind kind, long timestamp) {
        this.path = path;
        this.kind = kind;
        this.delta = Collections.emptyList();
        this.timestamp = timestamp;
    }

    public ResourceNotification(String path, Kind kind, long timestamp, List<Event> delta) {
        this.path = path;
        this.kind = kind;
        this.delta = delta != null ? Collections.unmodifiableList(delta) : Collections.emptyList();
        this.timestamp = timestamp;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getPath() {
        return this.path;
    }

    public List<Event> events() {
        return this.delta;
    }

    public String toString() {
        return "ResourceNotification [path=" + this.path + ", kind=" + (Object)((Object)this.kind) + ", delta=" + this.delta + ", timestamp=" + this.timestamp + "]";
    }

    public static class Event {
        final String path;
        final Kind kind;

        public Event(String path, Kind kind) {
            this.path = path;
            this.kind = kind;
        }

        public Kind getKind() {
            return this.kind;
        }

        public String getPath() {
            return this.path;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Event other = (Event)obj;
            if (this.kind != other.kind) {
                return false;
            }
            return !(this.path == null ? other.path != null : !this.path.equals(other.path));
        }

        public String toString() {
            return "Event [path=" + this.path + ", kind=" + (Object)((Object)this.kind) + "]";
        }
    }

    public static enum Kind {
        ENTRY_CREATE,
        ENTRY_DELETE,
        ENTRY_MODIFY;

    }
}

